@php
    $header_title = 'Aurobees  | General Page Management | Contact Us';
    $header_name = 'general_management';
    $page_name = 'general_page_contact-us';
@endphp
@extends('admin.admin_master')
@section('admin')
    <style>
        .select2-container .select2-selection--single {
            height: 37px !important;
        }
    </style>
    <script src="https://cdn.ckeditor.com/4.19.1/standard/ckeditor.js"></script>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Contact Us/Global Offices</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard')}}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('page.contact-us.list')}}">Contact Us</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('page.contact-us.global-office.list',$contact_us_id)}}">Global Offices</a></li>
                            <li class="breadcrumb-item active">Address</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Edit Address</h3>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                @if($errors->any())
                                    {!! implode('', $errors->all('<div>:message</div>')) !!}
                                @endif
                                <form method="POST" autocomplete="off" action="{{route('page.contact-us.global-office.address.update',[$contact_us_id,$contact_us_global_office_id])}}" enctype="multipart/form-data">
                                    @csrf
                                    @php $j=0; $i=1000; @endphp
                                    @foreach ($datas as $data)
                                        <div class="row main-row">
                                            <div class="col-md-7">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label>Title<span style="color:red;font-size: 120%;">*</span></label>
                                                            <input type="text" name="row[{{$j}}][title]" id="title"  value="{{$data->title}}" class="form-control" placeholder="Title"  required>
                                                            <input type="hidden" name="row[{{$j}}][old_id]"   value="{{$data->id}}" >
                                                            <input type="hidden" name="row[{{$j}}][old_image]"  value="{{$data->image}}" >
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label>Link</label>
                                                            <input type="url" name="row[{{$j}}][link]" id="link"  value="{{$data->link}}" class="form-control" placeholder="Link"  >
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label>Description<span style="color:red;font-size: 120%;">*</span></label>
                                                            <textarea name="row[{{$j}}][description]" class="form-control" placeholder="Description" id="description{{$j}}"  required>{{$data->description}}</textarea>
                                                            <script> CKEDITOR.replace("description{{$j}}"); </script>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="form-group image_div">
                                                            <label for="exampleInputFile">Image</label>
                                                            <div class="input-group">
                                                                <div class="custom-file">
                                                                    <input type="file" class="custom-file-input image" name="row[{{$j++}}][image]">
                                                                    <label class="custom-file-label">Choose Image</label>
                                                                </div>
                                                            </div>
                                                            <small style="color:red;">Image Size should be 736 × 490 px</small>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <img class="rounded-circle showImage" id="showImage{{$i++}}" style="width: 150px;height:150px;" src="{{$data->image?url($data->image):url('image-placeholder.png')}}">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <center><button type="button" class="btn btn-danger" onclick="DeleteRow(this,{{$data->id}})">Delete</button></center>
                                            </div>
                                        </div>
                                    @endforeach
                                    <div id="row_add"></div>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <button type="button" class="btn btn-round btn-link" onclick="AddRow()">Add Row</button>
                                        </div>
                                    </div>
                                    <hr>
                                    <center><input type="submit" value="Submit" class="btn btn-round btn-primary"></center>
                                </form>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>
@endsection
@section('script')
    <script>
        function AddRow(){
            let x = Math.floor((Math.random() * 100) + 1);
            let data=`<div class="row main-row">
                        <div class="col-md-7">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label>Title<span style="color:red;font-size: 120%;">*</span></label>
                                        <input type="text" name="row[${x}][title]" id="title" class="form-control" placeholder="Title"  required>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label>Link</label>
                                        <input type="text" name="row[${x}][link]" id="link" class="form-control" placeholder="Link" >
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label>Description<span style="color:red;font-size: 120%;">*</span></label>
                                        <textarea name="row[${x}][description]" id="description_${x}" class="form-control" placeholder="Description"  required></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group image_div">
                                        <label for="exampleInputFile">Image</label>
                                        <div class="input-group">
                                            <div class="custom-file">
                                                <input type="file" class="custom-file-input image" name="row[${x}][image]">
                                                <label class="custom-file-label">Choose Image</label>
                                            </div>
                                        </div>
                                        <small style="color:red;">Image Size should be 736 × 490 px</small>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <img class="rounded-circle showImage" id="showImage${x}"  style="width: 150px;height:150px;" src="{{url('image-placeholder.png')}}">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <center><button class="btn btn-danger" onclick="$(this).closest('.row).remove();">Delete</button></center>
                        </div>
                    </div>`;
            $('#row_add').append(data);
            CKEDITOR.replace('description_'+x);
            $('.image').change(function(e) {
                let id= $(this).closest('.row').find("div:nth-child(2) .showImage").attr('id');
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#'+id).attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
        }

        $('.image').change(function(e) {
            let id= $(this).closest('.row').find("div:nth-child(2) .showImage").attr('id');
            var reader = new FileReader();
            reader.onload = function(e) {
                $('#'+id).attr('src', e.target.result);
            }
            reader.readAsDataURL(e.target.files['0']);
        });

        function DeleteRow(th,id){
            $.ajax({
                type: 'post',
                url: "{{route('page.contact-us.global-office.address.delete')}}",
                data:{
                    id:id,
                    _token:$("[name='_token']").val()
                },
                success: function (data) {
                    $(th).closest('.main-row').remove();
                }
            });
        }

    </script>
@endsection

