@php
    $header_title = 'Aurobees  | Event Page Management | Event';
    $header_name = 'general_page_event';
    $sub_header_name = 'general_page_event';
    $page_name = 'general_page_event_date';
@endphp
@extends('admin.admin_master')
@section('admin')
    <style>
        .select2-container .select2-selection--single {
            height: 37px !important;
        }
    </style>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Events</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard')}}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('page.event.list')}}">Event</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('page.event.event-date.list')}}">Events</a></li>
                            <li class="breadcrumb-item active">Edit</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Edit Event</h3>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                <form method="POST" autocomplete="off" action="{{route('page.event.event-date.update',$data->id)}}" enctype="multipart/form-data">

                                    <input type="hidden" name="old_image" value="{{@$data->image}}">
                                    <input type="hidden" name="old_video" value="{{@$data->video}}">
                                    <input type="hidden" name="old_pdf" value="{{@$data->pdf}}">
                                    <input type="hidden" name="old_thumbnail_image" value="{{@$data->thumbnail_image}}">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-9">
                                            <div class="form-group">
                                                <label>Title<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="title" id="title" class="form-control"
                                                    placeholder="Title" value="{{$data->title}}" required>
                                                @error('title')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            @if($defaultLanguagePagesList)
                                                <div class="form-group select-language-page-div">
                                                    <label>Select Page<span style="color:red;font-size: 120%;">*</span></label>
                                                    <select name="default_language_page" id="default_language_page" class="form-control">
                                                        @foreach ($defaultLanguagePagesList as $value)
                                                            <option value="{{ $value->id }}" {{$value->id==$data->default_language_page?'selected':''}}>{{ $value->title }}</option>
                                                        @endforeach
                                                    </select>
                                                    @error('default_language_page')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            @endif
                                            <div class="form-group form-default">
                                                <label>Description<span style="color:red;font-size: 120%;">*</span> </label>
                                                <textarea name="description" id="description" class="form-control" required>{{$data->description}}</textarea>
                                                <span class="form-bar"></span>
                                                @error('description')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Meeting Type<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="meeting_type" class="form-control"
                                                    placeholder="Meeting Type"  value="{{$data->meeting_type}}" required>
                                                @error('meeting_type')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Meeting Link<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="url" name="meeting_link" class="form-control"
                                                    placeholder="Meeting Link"  value="{{$data->meeting_link}}" required>
                                                @error('meeting_link')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>

                                            {{-- <div class="form-group">
                                                <label>Zoom Link<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="url" name="zoom_link" class="form-control"
                                                    placeholder="Zoom Link"  value="{{$data->zoom_link}}" required>
                                                @error('zoom_link')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div> --}}
                                            {{-- <div class="form-group">
                                                <label>Zoom ID<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="zoom_id" class="form-control"
                                                    placeholder="Zoom ID"  value="{{$data->zoom_id}}" required>
                                                @error('zoom_id')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Zoom Password<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="zoom_password" class="form-control"
                                                    placeholder="Zoom Password"  value="{{$data->zoom_password}}" required>
                                                @error('zoom_password')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div> --}}
                                            
                                            <div class="form-group">
                                                <label>Zoom Meeting Details:</label>
                                            </div>
                                            
                                            <div class="form-group">
                                                <table class="table table-bordered table-striped">
                                                    <tbody>
                                                    <tr>
                                                        <th>Zoom Meeting ID:</th>
                                                        <td>{{$data->zoom_id}}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>Zoom Meeting Password:</th>
                                                        <td>{{$data->zoom_password}}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>Zoom Meeting Start Url:</th>
                                                        <td><p></p><a href="{{$data->zoom_start_url}}" target="_blank">Zoom Meeting Start Url</a></p></td>
                                                    </tr>
                                                    <tr>
                                                        <th>Zoom Meeting Join Url:</th>
                                                        <td><a href="{{$data->zoom_join_url}}" target="_blank">Zoom Meeting Join Url</a></td>
                                                    </tr>
                                                    </tbody>
                                                </table>
                                            </div>

                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>Language<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="language" class="form-control" id="language" required onchange="LanguageChangePage(this.value);">
                                                    @foreach ($languages as $value)
                                                        @if($data->language=='en' && $value->code=='en')
                                                            <option value="{{ $value->code }}" {{$value->code==$data->language?'selected':''}}>{{ $value->name }}</option>
                                                        @elseif ($data->language !='en' && $value->code !='en')
                                                            <option value="{{ $value->code }}" {{$value->code==$data->language?'selected':''}}>{{ $value->name }}</option>
                                                        @endif
                                                    @endforeach;
                                                </select>
                                                @error('language')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Datetime<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="datetime-local" name="datetime" class="form-control" value="{{$data->datetime}}" required>
                                                @error('datetime')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Duration (in Minutes)<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="number" name="duration" step="1" class="form-control" value="{{$data->duration}}" required>
                                                @error('duration')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Status<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="status" class="form-control" required>
                                                    <option value="Published" {{$data->status=='Published'?'selected':''}} >Published</option>
                                                    <option value="Draft" {{$data->status=='Draft'?'selected':''}} >Draft</option>
                                                    <option value="Trash" {{$data->status=='Trash'?'selected':''}} >Trash</option>
                                                </select>
                                                @error('status')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            {{-- ---------------------------------------------------------------------------------------------- --}}
                                            <div class="form-group">
                                                <label>Type<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="media_type" class="form-control" id="media_type" required>
                                                    <option value="Image" {{$data->media_type=='Image'?'selected':''}}>Image</option>
                                                    <option value="Video" {{$data->media_type=='Video'?'selected':''}}>Video</option>
                                                </select>
                                                @error('media_type')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>

                                            <div class="form-group image_div">
                                                <label for="exampleInputFile">Image<span style="color:red;font-size: 120%;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="image" id="image">
                                                        <label class="custom-file-label">Choose Image</label>
                                                    </div>
                                                </div>
                                                <small style="color:red;">Image Size should be 1605 × 737 px</small>
                                                @error('image')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group image_div">
                                                <img class="rounded-circle" id="showImage" style="width: 150px;height:150px;" src="{{(!empty($data->image))? url($data->image):url('image-placeholder.png')}}">
                                            </div>

                                            <div class="form-group video_div">
                                                <label>Video Type<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="video_type" id='video_type' class="form-control" onchange="VideoTypeChange()">
                                                    <option value="MP4" {{$data->video_type=='MP4'?'selected':''}}>MP4</option>
                                                    <option value="Youtube" {{$data->video_type=='Youtube'?'selected':''}}>Youtube</option>
                                                </select>
                                                @error('video_type')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group video_div video_mp4">
                                                <label for="exampleInputFile">Video<span style="color:red;font-size: 120%;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="video" id="video">
                                                        <label class="custom-file-label">Choose Video</label>
                                                    </div>
                                                </div>
                                                @error('video')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group video_div video_mp4">
                                                <video width="150" controls>
                                                    @if($data->video)
                                                        <source src="{{url($data->video)}}" id="video_here">
                                                    @else
                                                        <source src="" id="video_here">
                                                    @endif
                                                </video>
                                            </div>
                                            <div class="form-group video_div video_mp4 ">
                                                <label for="exampleInputFile">Thumbnail Image<span style="color:red;font-size: 120%;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="thumbnail_image" id="thumbnail_image" >
                                                        <label class="custom-file-label">Choose Image</label>
                                                    </div>
                                                </div>
                                                <small style="color:red;">Image Size should be 1605 × 737 px</small>
                                                @error('thumbnail_image')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group video_div video_mp4">
                                                <img class="rounded-circle" id="thumbnail_image_showImage" style="width: 150px;height:150px;" src="{{(!empty($data->thumbnail_image))? url($data->thumbnail_image):url('image-placeholder.png')}}">
                                            </div>
                                            <div class="form-group video_div youtube">
                                                <label>Youtube<span style="color:red;font-size: 120%;">*</span></label>
                                                <textarea name="youtube"  class="form-control">{{$data->youtube}}</textarea>
                                                @error('youtube')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label for="exampleInputFile">Pdf</label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="pdf" id="pdf" >
                                                        <label class="custom-file-label">Choose PDF</label>
                                                    </div>
                                                </div>
                                                @if(@$data->pdf) <a href="{{url(@$data->pdf)}}" target="_blank">PDF</a> @endif
                                                @error('pdf')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <center><input type="submit" value="Submit" class="btn btn-round btn-primary"></center>
                                </form>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>
@endsection
@section('script')
    <script src="https://cdn.ckeditor.com/4.19.1/standard/ckeditor.js"></script>
    <script>
        CKEDITOR.replace( 'description', { format_tags: 'p;h1;h2;h3;h4;h5;h6;pre;address;div'});
    </script>
    <script>
        function VideoTypeChange(){
            var video_type=$('#video_type').val();
            if(video_type=='MP4'){
                $('.youtube').hide();
                $('.video_mp4').show();
            }else if(video_type=='Youtube'){
                $('.video_mp4').hide();
                $('.youtube').show();
            }
        }

        $(document).ready(function() {
            var media_type=$('#media_type').val();
            if(media_type=="Image"){
                $('.video_div').hide();
                $('.image_div').show();
            }else if(media_type=="Video"){
                $('.image_div').hide();
                $('.video_div').show();
                VideoTypeChange();
            }

            //image
            $('#image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
            //header_icon
            $('#header_icon').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#header_icon_showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
            //banner_image
            $('#banner_image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#banner_image_showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
            //benefits_background_image
            $('#benefits_background_image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#benefits_background_image_showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
            //thumbnail_image
            $('#thumbnail_image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#thumbnail_image_showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
            //video
            $(document).on("change", "#video", function(evt) {
                var $source = $('#video_here');
                $source[0].src = URL.createObjectURL(this.files[0]);
                $source.parent()[0].load();
            });
            //media_type
            $('#media_type').click(function(){
                if(this.value=="Image"){
                    $('.video_div').hide();
                    $('.image_div').show();
                }else if(this.value=="Video"){
                    $('.image_div').hide();
                    $('.video_div').show();
                    VideoTypeChange();
                }
            })

        });
    </script>
    <script>
        $(document).ready(function() {
            @if($data->language=='en')
                $('.select-language-page-div').hide();
                $('.select-language-page-div select').prop('required', false);
            @endif
        });
        function LanguageChangePage(value){
            if(value=='en'){
                $('.select-language-page-div').hide();
                $('.select-language-page-div select').prop('required', false);
            }else{
                $('.select-language-page-div').show();
                $('.select-language-page-div select').prop('required', true);
            }
        }
    </script>
@endsection

