@php
    $header_title = 'Aurobees  | Go Online Management | Create Website';
    $header_name = 'go-online_management';
    $page_name = 'go-online-create-website';
@endphp
@extends('admin.admin_master')
@section('admin')
    <style>
        .select2-container .select2-selection--single {
            height: 37px !important;
        }
    </style>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Go Online/Create Website</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard')}}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('go-online.create-website.list')}}">Create Website</a></li>
                            <li class="breadcrumb-item active">Add</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Add Create Website</h3>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                <form method="POST" autocomplete="off" action="{{ route('go-online.create-website.store') }}" enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-9">
                                            <div class="form-group">
                                                <label>Title<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="title" id="title" class="form-control"  maxlength="30"
                                                    placeholder="Title" value="{{old('title')}}" required>
                                                @error('title')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group slug-div">
                                                <label>Slug<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="slug" id="slug" class="form-control" required
                                                    placeholder="Slug"  value="{{old('slug')}}">
                                                @error('slug')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            @if($defaultLanguagePagesList)
                                                <div class="form-group select-language-page-div">
                                                    <label>Select Page<span style="color:red;font-size: 120%;">*</span></label>
                                                    <select name="default_language_page" id="default_language_page" class="form-control">
                                                        @foreach ($defaultLanguagePagesList as $value)
                                                            <option value="{{ $value->id }}">{{ $value->title }}</option>
                                                        @endforeach
                                                    </select>
                                                    @error('default_language_page')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            @endif
                                            <div class="form-group">
                                                <label>Sub Title</label>
                                                <input type="text" name="sub_title" class="form-control"  maxlength="65"
                                                    placeholder="Sub Title"  value="{{old('sub_title')}}" >
                                                @error('sub_title')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group form-default">
                                                <label>Description<span style="color:red;font-size: 120%;">*</span> </label>
                                                <textarea name="description" id="description" class="form-control" required>{{old('description')}}</textarea>
                                                <span class="form-bar"></span>
                                                @error('description')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>

                                            <div class="form-group">
                                                <label>Title 2<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="title_2" class="form-control" maxlength="45"
                                                    placeholder="Title 2"  value="{{old('title_2')}}" required>
                                                @error('title_2')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Button Text<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="button_text" class="form-control" maxlength="35"
                                                    placeholder="Button Text"  value="{{old('button_text')}}" required>
                                                @error('button_text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Button Link<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="button_link" class="form-control"
                                                    placeholder="Button Link"  value="{{old('button_link')}}" required>
                                                @error('button_link')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Text 1<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="text_1" class="form-control" maxlength="25"
                                                    placeholder="Text 1"  value="{{old('text_1')}}" required>
                                                @error('text_1')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Text 2<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="text_2" class="form-control" maxlength="20"
                                                    placeholder="Text 2"  value="{{old('text_2')}}" required>
                                                @error('text_2')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>

                                            <div class="form-group">
                                                <label>Meta Key<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="meta_key" id="meta_key" class="form-control"
                                                    placeholder="Meta Key"  value="{{old('meta_key')}}" required>
                                                @error('meta_key')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Meta Title<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="meta_title" id="meta_title" class="form-control"
                                                    placeholder="Meta Title"  value="{{old('meta_title')}}" required>
                                                @error('meta_title')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Meta Description<span style="color:red;font-size: 120%;">*</span></label>
                                                <textarea name="meta_description" placeholder="Meta Description" class="form-control" required>{{old('meta_description')}}</textarea>
                                                @error('meta_description')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>Language<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="language" id="language" onchange="LanguageChangePage(this.value);" class="form-control" required>
                                                    @foreach ($languages as $value)
                                                        <option value="{{ $value->code }}">{{ $value->name }}</option>
                                                    @endforeach
                                                </select>
                                                @error('language')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>

                                            <div class="form-group ">
                                                <label for="exampleInputFile">Banner Image<span style="color:red;font-size: 120%;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="banner_image" id="header_icon" required>
                                                        <label class="custom-file-label">Choose Image</label>
                                                    </div>
                                                </div>
                                                <small style="color:red;">Image Size should be 1920 × 654 px</small>
                                                @error('banner_image')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <img class="rounded-circle" id="header_icon_showImage" style="width: 150px;height:150px;" src="{{ url('image-placeholder.png') }}">
                                            </div>
                                            <div class="form-group">
                                                <label>Type<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="media_type" class="form-control" id="media_type" required>
                                                    <option value="Image">Image</option>
                                                    <option value="Video">Video</option>
                                                </select>
                                                @error('media_type')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>

                                            <div class="form-group image_div">
                                                <label for="exampleInputFile">Image<span style="color:red;font-size: 120%;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="image" id="image">
                                                        <label class="custom-file-label">Choose Image</label>
                                                    </div>
                                                </div>
                                                <small style="color:red;">Image Size should be 812 × 509 px</small>
                                                @error('image')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group image_div">
                                                <img class="rounded-circle" id="showImage" style="width: 150px;height:150px;" src="{{ url('image-placeholder.png') }}">
                                            </div>

                                            <div class="form-group video_div">
                                                <label>Video Type<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="video_type" id='video_type' class="form-control" onchange="VideoTypeChange()">
                                                    <option value="MP4">MP4</option>
                                                    <option value="Youtube">Youtube</option>
                                                </select>
                                                @error('video_type')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group video_div video_mp4">
                                                <label for="exampleInputFile">Video<span style="color:red;font-size: 120%;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="video" id="video">
                                                        <label class="custom-file-label">Choose Video</label>
                                                    </div>
                                                </div>
                                                @error('video')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group video_div video_mp4">
                                                <video width="150" controls>
                                                    <source src="" id="video_here">
                                                </video>
                                            </div>
                                            <div class="form-group video_div video_mp4">
                                                <label for="exampleInputFile">Thumbnail Image<span style="color:red;font-size: 120%;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="thumbnail_image" id="thumbnail_image">
                                                        <label class="custom-file-label">Choose Image</label>
                                                    </div>
                                                </div>
                                                <small style="color:red;">Image Size should be 812 × 509 px</small>
                                                @error('thumbnail_image')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group video_div video_mp4">
                                                <img class="rounded-circle" id="thumbnail_image_showImage" style="max-width: 150px;max-height:150px;" src="{{ url('image-placeholder.png') }}">
                                            </div>
                                            <div class="form-group video_div youtube">
                                                <label>Youtube<span style="color:red;font-size: 120%;">*</span></label>
                                                <textarea name="youtube"  class="form-control">{{old('youtube')}}</textarea>
                                                @error('youtube')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <center><input type="submit" value="Submit" class="btn btn-round btn-primary"></center>
                                </form>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>
@endsection
@section('script')
    <script src="https://cdn.ckeditor.com/4.19.1/standard/ckeditor.js"></script>
    <script>
        CKEDITOR.replace( 'description', { format_tags: 'p;h1;h2;h3;h4;h5;h6;pre;address;div'});
    </script>
    <script>
        function VideoTypeChange(){
            var video_type=$('#video_type').val();
            if(video_type=='MP4'){
                $('.youtube').hide();
                $('.video_mp4').show();
            }else if(video_type=='Youtube'){
                $('.video_mp4').hide();
                $('.youtube').show();
            }
        }

        $(document).ready(function() {
            $('.video_div').hide();
            //image
            $('#image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
            //header_icon
            $('#header_icon').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#header_icon_showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
            //banner_image
            $('#banner_image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#banner_image_showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
            //thumbnail_image
            $('#thumbnail_image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#thumbnail_image_showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
            //video
            $(document).on("change", "#video", function(evt) {
                var $source = $('#video_here');
                $source[0].src = URL.createObjectURL(this.files[0]);
                $source.parent()[0].load();
            });

            //slug
            const post_title = document.querySelector('#title');
            post_title.addEventListener('keyup', function() {
                const inputString = $(this).val();
                const outputString = inputString.replace(/[^a-zA-Z0-9]/g, "-").replace(/\s+/g, "-");
                console.log(outputString);
                $('#slug').val(outputString);
            });
            $('#editSlug').click(function(){
                $('#slug').prop('disabled',false);
                $(this).hide();
            });

            //media_type
            $('#media_type').click(function(){
                if(this.value=="Image"){
                    $('.video_div').hide();
                    $('.image_div').show();
                }else if(this.value=="Video"){
                    $('.image_div').hide();
                    $('.video_div').show();
                    VideoTypeChange();
                }
            })
        });
    </script>
    <script>
        $(document).ready(function() {
            $('.select-language-page-div').hide();
            // $('.slug-div').hide();
        });
        function LanguageChangePage(value){
            if(value=='en'){
                $('.select-language-page-div').hide();
                $('.select-language-page-div select').prop('required', false);
                $('.slug-div').show();
                $('.slug-div input').prop('required', true);
            }else{
                $('.slug-div').hide();
                $('.slug-div input').prop('required', false);
                $('.select-language-page-div').show();
                $('.select-language-page-div select').prop('required', true);
            }
        }
    </script>
@endsection
