@php
    $header_title = 'Aurobees  | Go Online Management | Digital Marketing Services';
    $header_name = 'go-online_management';
    $page_name = 'go-online-digital-marketing-services';
@endphp
@extends('admin.admin_master')
@section('admin')
    <style>
        .select2-container .select2-selection--single {
            height: 37px !important;
        }
    </style>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Go Online/Digital Marketing Services</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard')}}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('go-online.digital-marketing-services.list')}}">Digital Marketing Services</a></li>
                            <li class="breadcrumb-item active">Edit Benefits</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Edit Digital Marketing Services Benefits</h3>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                @if($errors->any())
                                    {!! implode('', $errors->all('<div>:message</div>')) !!}
                                @endif
                                <form method="POST" autocomplete="off" action="{{route('go-online.digital-marketing-services.benefits.update',$id)}}" enctype="multipart/form-data">
                                    @csrf
                                    @php $j=0; $i=1000; @endphp
                                    @foreach ($datas as $data)
                                        <div class="row">
                                            <div class="col-md-5">
                                                <div class="form-group">
                                                    <label>Title<span style="color:red;font-size: 120%;">*</span></label>
                                                    <input type="text" name="title[]" maxlength="30" value="{{$data->title}}" class="form-control" placeholder="Title"  required>
                                                </div>
                                            </div>
                                            <div class="col-md-5">
                                                <div class="form-group">
                                                    <label>Link<span style="color:red;font-size: 120%;">*</span></label>
                                                    <input type="url" name="link[]"  value="{{$data->link}}" class="form-control" placeholder="Link"  required>
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <center><button type="button" class="btn btn-danger" onclick="$(this).closest('.row').remove();">Delete</button></center>
                                            </div>
                                        </div>
                                    @endforeach
                                    <div id="row_add"></div>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <button type="button" class="btn btn-round btn-link" onclick="AddRow()">Add Row</button>
                                        </div>
                                    </div>
                                    <hr>
                                    <center><input type="submit" value="Submit" class="btn btn-round btn-primary"></center>
                                </form>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>
@endsection
@section('script')
    <script>
        function AddRow(){
            let x = Math.floor((Math.random() * 100) + 1);
            let data=`<div class="row">
                        <div class="col-md-5">
                            <div class="form-group">
                                <label>Title<span style="color:red;font-size: 120%;">*</span></label>
                                <input type="text" name="title[]" maxlength="30" class="form-control" placeholder="Title"  required>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="form-group">
                                <label>Link<span style="color:red;font-size: 120%;">*</span></label>
                                <input type="url" name="link[]" class="form-control" placeholder="Link"  required>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <center><button type="button" class="btn btn-danger" onclick="$(this).closest('.row').remove();">Delete</button></center>
                        </div>
                    </div>`;
            $('#row_add').append(data);
        }
    </script>
@endsection

