@php
    $section_type=ucwords(str_replace('-',' ',$type));
    $header_title = 'Aurobees  | Home Page Management | '.$section_type;
    $header_name = 'home_management';
    $sub_header_name = 'home_'.$type;
    $page_name = 'home_page_'.$type;
@endphp
@extends('admin.admin_master')
@section('admin')
    <style>
        .select2-container .select2-selection--single {
            height: 37px !important;
        }
    </style>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Features</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{route('home-page.section.list',$type)}}">{{$section_type}}</a></li>
                            <li class="breadcrumb-item active">Edit {{$section_type}}</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Edit Features</h3>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                <form method="POST" autocomplete="off" action="{{route('home-page.section.update',[$type,$data->id])}}" enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-6">
                                            @if($type=='our-service' ||$type=='industries' ||$type=='cloud' ||$type=='latest-news' ||$type=='customers-derive' ||$type=='blogs' ||$type=='brands')
                                                <div class="form-group">
                                                    <label>Title 1<span style="color:red;font-size: 120%;">*</span></label>
                                                    <input type="text" name="title_1" class="form-control"
                                                        placeholder="Title 1" value="{{$data->title_1}}" required>
                                                    @error('title_1')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            @endif
                                            @if($type=='industries' ||$type=='cloud')
                                                <div class="form-group">
                                                    <label>Description<span style="color:red;font-size: 120%;">*</span></label>
                                                        <textarea name="description" class="form-control" id="description" >{{$data->description}}</textarea>
                                                    @error('description')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            @endif
                                        </div>
                                        <div class="col-md-6">
                                            @if($type=='our-service' ||$type=='industries' ||$type=='cloud' ||$type=='latest-news' ||$type=='customers-derive')
                                                <div class="form-group">
                                                    <label>Title 2</label>
                                                    <input type="text" name="title_2" class="form-control"
                                                        placeholder="Title 2" value="{{$data->title_2}}" >
                                                    @error('title_2')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            @endif
                                            @if($type=='customers-derive' ||$type=='latest-news' ||$type=='blogs')
                                                <div class="form-group">
                                                    <label>Button Text</label>
                                                    <input type="text" name="button_text" class="form-control"
                                                        placeholder="Button Text" value="{{$data->button_text}}" >
                                                    @error('button_text')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            @endif
                                            @if($type=='customers-derive' ||$type=='latest-news' ||$type=='blogs')
                                                <div class="form-group">
                                                    <label>Button Link</label>
                                                    <input type="url" name="button_link" class="form-control"
                                                        placeholder="Button Link" value="{{$data->button_link}}" >
                                                    @error('button_link')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            @endif
                                            <div class="form-group">
                                                <label>Language<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="language" class="form-control" required>
                                                    @foreach ($languages as $value)
                                                        <option value="{{ $value->code }}" {{$value->code==$data->language?'selected':''}}>{{ $value->name }}</option>
                                                    @endforeach;
                                                </select>
                                                @error('language')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Status<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="status" class="form-control" required>
                                                    <option value="Published" {{$data->status=='Published'?'selected':''}} >Published</option>
                                                    <option value="Draft" {{$data->status=='Draft'?'selected':''}} >Draft</option>
                                                    <option value="Trash" {{$data->status=='Trash'?'selected':''}} >Trash</option>
                                                </select>
                                                @error('status')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <center>
                                        <input type="submit" value="Submit" class="btn btn-round btn-primary">
                                        <a href="{{route('home-page.section.list',$type)}}" class="btn btn-round btn-link">Back</a>
                                    </center>
                                </form>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>
@endsection
@section('script')
    <script src="https://cdn.ckeditor.com/4.19.1/standard/ckeditor.js"></script>
    <script>
        CKEDITOR.replace('description');
    </script>
@endsection
