@php
    $header_title = 'Aurobees  | Home Page Management | Auto Slider';
    $header_name = 'home_management';
    $page_name = 'home_slider-auto';
@endphp
@extends('admin.admin_master')
@section('admin')
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Auto Slider</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{route('home.slider.list')}}">Auto Slider</a></li>
                            <li class="breadcrumb-item active">View Auto Slider</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
    <!-- /.content-header -->
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">View Auto Slider</h3>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <table class="table table-striped">
                                <tbody>
                                    <tr>
                                        <th>Title</th>
                                        <td>{{$data->title}}</td>
                                   </tr>
                                   <tr>
                                        <th>Image</th>
                                        <td><img class="rounded-circle" style="max-width: 300px;" src="{{(!empty($data->image))? url($data->image):url('image-placeholder.png')}}"></td>
                                    </tr>
                                   <tr>
                                        <th>Language</th>
                                        <td>{{$data['Language']['name']}}</td>
                                   </tr>
                                    <tr>
                                        <th>Status</th>
                                        <td>{{$data->status}}</td>
                                    </tr>
                                </tbody>
                              </table>
                              <hr>
                              <center><a href="{{route('home.slider-auto.list')}}" class="btn btn-round btn-primary">Back</a></center>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
</div>
@endsection
