@php
    $header_title = 'Aurobees  | Home Page Management | Slider';
    $header_name = 'home_management';
    $page_name = 'home_slider';
@endphp
@extends('admin.admin_master')
@section('admin')
    <style>
        .select2-container .select2-selection--single {
            height: 37px !important;
        }
    </style>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Slider</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{route('home.slider.list')}}">Slider</a></li>
                            <li class="breadcrumb-item active">Edit Slider</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Edit Slider</h3>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                <form method="POST" autocomplete="off" action="{{route('home.slider.update',$data->id)}}" enctype="multipart/form-data">
                                    <input type="hidden" name="old_image" value="{{@$data->image}}">
                                    <input type="hidden" name="old_icon" value="{{@$data->icon}}">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-9">
                                            <div class="form-group">
                                                <label>Title<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="title" maxlength="25" id="title" class="form-control"
                                                    placeholder="Title" value="{{$data->title}}" required>
                                                @error('title')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group form-default">
                                                <label>Description<span style="color:red;font-size: 120%;">*</span> </label>
                                                <textarea name="description" id="description" maxlength="150" class="form-control" required>{{$data->description}}</textarea>
                                                <span class="form-bar"></span>
                                                @error('description')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Text<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="text" class="form-control" placeholder="Text" maxlength="25" value="{{$data->text}}" required>
                                                @error('text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="row">
                                                <div class="col-12 add-row">
                                                    <div class="row form-group">
                                                        <div class="col-5">
                                                            <label>Title<span style="color:red;font-size: 120%;">*</span></label>
                                                        </div>
                                                        <div class="col-6">
                                                            <label>Link<span style="color:red;font-size: 120%;">*</span</label>
                                                        </div>
                                                        <div class="col-1">
                                                            <label>Action</label>
                                                        </div>
                                                    </div>
                                                    @if(@$data['SliderChild'])
                                                    @foreach (@$data['SliderChild'] as $child)
                                                        <div class="row form-group">
                                                            <div class="col-5">
                                                                <input type="text" name="child_title[]" value="{{$child->button_text}}" maxlength="30" placeholder="Enter Title" required class="form-control">
                                                            </div>
                                                            <div class="col-6">
                                                                <input type="text" name="child_link[]" value="{{$child->button_link}}" placeholder="Enter Link" required class="form-control">
                                                            </div>
                                                            <div class="col-1">
                                                                <button type="button" class="btn btn-round btn-danger" onclick="$(this).closest('.row').remove();">Delete</button>
                                                            </div>
                                                        </div>
                                                    @endforeach
                                                    @endif
                                                </div>
                                                <div class="col-12">
                                                    <button type="button" class="btn btn-round btn-link" id="addRow">Add Row</button>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>Language<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="language" class="form-control" required>
                                                    @foreach ($languages as $value)
                                                        <option value="{{ $value->code }}" {{$value->code==$data->language?'selected':''}}>{{ $value->name }}</option>
                                                    @endforeach;
                                                </select>
                                                @error('language')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Status<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="status" class="form-control" required>
                                                    <option value="Published" {{$data->status=='Published'?'selected':''}} >Published</option>
                                                    <option value="Draft" {{$data->status=='Draft'?'selected':''}} >Draft</option>
                                                    <option value="Trash" {{$data->status=='Trash'?'selected':''}} >Trash</option>
                                                </select>
                                                @error('status')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group ">
                                                <label for="exampleInputFile">Icon<span style="color:red;font-size: 120%;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="icon" id="icon" >
                                                        <label class="custom-file-label">Choose Image</label>
                                                    </div>
                                                </div>
                                                <small style="color:red;">Image Size should be 92 × 118 px</small>
                                                @error('icon')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <img class="rounded-circle" id="icon_showImage" style="width: 150px;height:150px;" src="{{(!empty($data->icon))? url($data->icon):url('image-placeholder.png')}}">
                                            </div>
                                            {{-- ---------------------------------------------------------------------------------------------- --}}

                                            <div class="form-group">
                                                <label for="exampleInputFile">Image<span style="color:red;font-size: 120%;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="image" id="image">
                                                        <label class="custom-file-label">Choose Image</label>
                                                    </div>
                                                </div>
                                                <small style="color:red;">Image Size should be 1920 × 1000 px</small>
                                                @error('image')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <img class="rounded-circle" id="showImage" style="width: 150px;height:150px;" src="{{(!empty($data->image))? url($data->image):url('image-placeholder.png')}}">
                                            </div>

                                            {{-- ------------------------------------------------------------------------------------------------- --}}
                                        </div>
                                    </div>
                                    <hr>
                                    <center>
                                        <input type="submit" value="Submit" class="btn btn-round btn-primary">
                                        <a href="{{route('home.slider.list')}}" class="btn btn-round btn-link">Back</a>
                                    </center>
                                </form>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>
@endsection
@section('script')
    <script src="https://cdn.ckeditor.com/4.19.1/standard/ckeditor.js"></script>
    <script>
        CKEDITOR.replace('description');
    </script>
    <script>
        $(document).ready(function() {
            //image
            $('#image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
            //header_icon
            $('#icon').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#icon_showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });

            $('#addRow').on('click',function(){
                var data=`<div class="row form-group">
                        <div class="col-5">
                            <input type="text" name="child_title[]" maxlength="30" placeholder="Enter Title" required class="form-control">
                        </div>
                        <div class="col-6">
                            <input type="text" name="child_link[]" placeholder="Enter Link" required class="form-control">
                        </div>
                        <div class="col-1">
                            <button type="button" class="btn btn-round btn-danger" onclick="$(this).closest('.row').remove();">Delete</button>
                        </div>
                    </div>`;
                $('.add-row').append(data);
            });
        });

    </script>
@endsection

