@php
    $header_title = 'Aurobees  | LOB | Category';
    $header_name = 'industries_management';
    $page_name = 'industries_category';
@endphp
@extends('admin.admin_master')
@section('admin')
    <style>
        .select2-container .select2-selection--single {
            height: 37px !important;
        }
    </style>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>LOB Category</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard')}}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('industries.industry.list')}}">LOB</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('industries.category.list')}}">Category</a></li>
                        <li class="breadcrumb-item active">Edit</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Edit LOB Category</h3>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                <form method="POST" autocomplete="off" action="{{route('industries.category.update',$data->id)}}" enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-9">
                                            <div class="form-group">
                                                <label>Name<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="name" id="name" class="form-control"
                                                    placeholder="Name" value="{{$data->name}}" required>
                                                @error('name')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group  slug-div">
                                                <label>Slug<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="slug" id="slug" class="form-control"
                                                    placeholder="Slug"  value="{{$data->slug}}" readonly >
                                                @error('slug')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            @if($defaultLanguagePagesList)
                                                <div class="form-group select-language-page-div">
                                                    <label>Select Page<span style="color:red;font-size: 120%;">*</span></label>
                                                    <select name="default_language_page" id="default_language_page" class="form-control">
                                                        @foreach ($defaultLanguagePagesList as $value)
                                                            <option value="{{ $value->id }}" {{$value->id==$data->default_language_page?'selected':''}}>{{ $value->name }}</option>
                                                        @endforeach
                                                    </select>
                                                    @error('default_language_page')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            @endif
                                            <div class="form-group">
                                                <label>Meta Key<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="meta_key" id="meta_key" class="form-control"
                                                    placeholder="Meta Key"  value="{{$data->meta_key}}" >
                                                @error('meta_key')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Meta Title<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="meta_title" id="meta_title" class="form-control"
                                                    placeholder="Meta Title"  value="{{$data->meta_title}}" >
                                                @error('meta_title')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Meta Description<span style="color:red;font-size: 120%;">*</span></label>
                                                    <textarea name="meta_description" placeholder="Meta Description" class="form-control" required>{{$data->meta_description}}</textarea>
                                                @error('meta_description')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>Language<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="language" class="form-control" required onchange="LanguageChangePage(this.value);">
                                                    
                                                    @foreach ($languages as  $value)
                                                        @if($data->language=='en' && $value->code=='en')
                                                            <option value="{{ $value->code }}" {{$value->code==$data->language?'selected':''}}>{{ $value->name }}</option>
                                                        @elseif ($data->language !='en' && $value->code !='en')
                                                            <option value="{{ $value->code }}" {{$value->code==$data->language?'selected':''}}>{{ $value->name }}</option>
                                                        @endif
                                                    @endforeach;
                                                </select>
                                                @error('language')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Status<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="status" class="form-control" required>
                                                    <option value="Published" {{$data->status=='Published'?'selected':''}} >Published</option>
                                                    <option value="Draft" {{$data->status=='Draft'?'selected':''}} >Draft</option>
                                                    <option value="Trash" {{$data->status=='Trash'?'selected':''}} >Trash</option>
                                                </select>
                                                @error('status')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <center><input type="submit" value="Submit" class="btn btn-round btn-primary"></center>
                                </form>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>
@endsection
@section('script')
    <script src="https://cdn.ckeditor.com/4.19.1/standard/ckeditor.js"></script>
    <script>
        CKEDITOR.replace('post_content');
    </script>
    <script>
        $(document).ready(function() {
            //slug
            const post_title = document.querySelector('#name');
            post_title.addEventListener('keyup', function() {
                const inputString = $(this).val();
                const outputString = inputString.replace(/[^a-zA-Z0-9]/g, "-").replace(/\s+/g, "-");
                console.log(outputString);
                $('#slug').val(outputString);
            });
            $('#editSlug').click(function(){
                $('#slug').prop('disabled',false);
                $(this).hide();
            });
        });
    </script>
    <script>
        $(document).ready(function() {
            @if($data->language=='en')
                $('.select-language-page-div').hide();
                $('.select-language-page-div select').prop('required', false);
            @else
                $('.slug-div').hide();
                $('.select-language-page-div select').prop('required', true);
            @endif
        });
        function LanguageChangePage(value){
            if(value=='en'){
                $('.select-language-page-div').hide();
                $('.select-language-page-div select').prop('required', false);
                $('.slug-div').show();
                $('.slug-div input').prop('required', true);
            }else{
                $('.slug-div').hide();
                $('.slug-div input').prop('required', false);
                $('.select-language-page-div').show();
                $('.select-language-page-div select').prop('required', true);
            }
        }
    </script>
@endsection
