@php
    $header_title = 'Aurobees  | LOB | Category';
    $header_name = 'industries_management';
    $page_name = 'industries_category';
@endphp
@extends('admin.admin_master')
@section('admin')
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>LOB Category</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard')}}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('industries.industry.list')}}">LOB</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('industries.category.list')}}">Category</a></li>
                        <li class="breadcrumb-item active">View</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <!-- /.content-header -->
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">View LOB Category Details</h3>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <table class="table table-striped">
                                <tbody>
                                    <tr>
                                        <th>Name</th>
                                        <td>{{$data->name}}</td>
                                   </tr>
                                    <tr>
                                        <th>Slug</th>
                                        <td>{{$data->slug}}</td>
                                   </tr>
                                   <tr>
                                        <th>Language</th>
                                        <td>{{$data['Language']['name']}}</td>
                                   </tr>
                                   <tr>
                                        <th>Created Datetime</th>
                                        <td>{{$data->created_at}}</td>
                                   </tr>
                                    <tr>
                                        <th>Meta Title</th>
                                        <td>{{$data->meta_title}}</td>
                                    </tr>
                                    <tr>
                                        <th>Meta Key</th>
                                        <td>{{$data->meta_key}}</td>
                                    </tr>
                                    <tr>
                                        <th>Meta Description</th>
                                        <td>{{$data->meta_description}}</td>
                                    </tr>
                                    <tr>
                                        <th>Status</th>
                                        <td>{{$data->post_status}}</td>
                                    </tr>
                                </tbody>
                              </table>
                              <hr>
                              <center><a href="{{route('industries.category.list')}}" class="btn btn-round btn-primary">Back</a></center>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
</div>
@endsection
