@php
    $header_title = 'Aurobees  | Partner Page Management';
    $header_name = 'partner_management';
    $page_name = 'partner_page_management';
@endphp
@extends('admin.admin_master')
@section('admin')
    <style>
        .select2-container .select2-selection--single {
            height: 37px !important;
        }
    </style>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Partner Page Management</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard')}}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('user.partner-page.view')}}">Partner Page Management</a></li>
                            <li class="breadcrumb-item active">Edit</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Edit Partner Page Management</h3>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                <form method="POST" autocomplete="off" action="{{route('user.partner-page.update',$data->id)}}" enctype="multipart/form-data">
                                    <input type="hidden" name="old_banner_image" value="{{@$data->banner_image}}">
                                    <input type="hidden" name="old_image" value="{{@$data->image}}">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-9">
                                            <div class="form-group">
                                                <label>Title<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="title" id="title" class="form-control" maxlength="30"
                                                    placeholder="Title" value="{{$data->title}}" required>
                                                @error('title')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>

                                            <div class="form-group">
                                                <label>Sub Title<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="sub_title" class="form-control" maxlength="40"
                                                    placeholder="Sub Title"  value="{{$data->sub_title}}" required>
                                                @error('sub_title')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group form-default">
                                                <label>Description<span style="color:red;font-size: 120%;">*</span> </label>
                                                <textarea name="description" id="description" class="form-control" required>{{$data->description}}</textarea>
                                                <span class="form-bar"></span>
                                                @error('description')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                             <div class="form-group">
                                                <label>Business Text<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="business_text" class="form-control"
                                                    placeholder="Business Text"  value="{{$data->business_text}}" required>
                                                @error('business_text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group form-default">
                                                <label>Business Description<span style="color:red;font-size: 120%;">*</span> </label>
                                                <textarea name="business_description" id="business_description" class="form-control" required>{{$data->business_description}}</textarea>
                                                <span class="form-bar"></span>
                                                @error('business_description')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Marketing Text<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="marketing_text" class="form-control"
                                                    placeholder="Typical Benefits Text"  value="{{$data->marketing_text}}" required>
                                                @error('marketing_text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group form-default">
                                                <label>Marketing Description<span style="color:red;font-size: 120%;">*</span> </label>
                                                <textarea name="marketing_description" id="marketing_description" class="form-control" required>{{$data->marketing_description}}</textarea>
                                                <span class="form-bar"></span>
                                                @error('marketing_description')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>

                                            <div class="form-group">
                                                <label>Typical Benefits Text<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="typical_benefits_text" class="form-control" maxlength="40"
                                                    placeholder="Typical Benefits Text"  value="{{$data->typical_benefits_text}}" required>
                                                @error('typical_benefits_text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group form-default">
                                                <label>Typical Benefits Description<span style="color:red;font-size: 120%;">*</span> </label>
                                                <textarea name="typical_benefits_description" id="typical_benefits_description" class="form-control" required>{{$data->typical_benefits_description}}</textarea>
                                                <span class="form-bar"></span>
                                                @error('typical_benefits_description')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            
                                            <div class="form-group">
                                                <label>How to Join as a Partner Text<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="how_to_join_as_a_partner_text" class="form-control" maxlength="40"
                                                    placeholder="How to Join as a Partner Text"  value="{{$data->how_to_join_as_a_partner_text}}" required>
                                                @error('how_to_join_as_a_partner_text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group form-default">
                                                <label>How to Join as a Partner Description<span style="color:red;font-size: 120%;">*</span> </label>
                                                <textarea name="how_to_join_as_a_partner_description" id="how_to_join_as_a_partner_description" class="form-control" required>{{$data->how_to_join_as_a_partner_description}}</textarea>
                                                <span class="form-bar"></span>
                                                @error('how_to_join_as_a_partner_description')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>KYC Form Text<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="kyc_form_text" id="kyc_form_text" class="form-control"
                                                    placeholder="KYC Form Text"  value="{{$data->kyc_form_text}}" required>
                                                @error('kyc_form_text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>View Terms of Use Text<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="view_terms_of_use_text" id="view_terms_of_use_text" class="form-control"
                                                    placeholder="View Terms of Use Text"  value="{{$data->view_terms_of_use_text}}" >
                                                @error('view_terms_of_use_text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>View Terms of Use Link<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="view_terms_of_use_link" id="view_terms_of_use_link" class="form-control"
                                                    placeholder="View Terms of Use Link"  value="{{$data->view_terms_of_use_link}}" >
                                                @error('view_terms_of_use_link')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Status Reject Text<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="status_reject_text" id="status_reject_text" class="form-control"
                                                    placeholder="Status Reject Text"  value="{{$data->status_reject_text}}" required>
                                                @error('status_reject_text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Status Under-process Text<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="status_under_process_text" id="status_under_process_text" class="form-control"
                                                    placeholder="Status Under-process Text"  value="{{$data->status_under_process_text}}" required>
                                                @error('status_under_process_text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Status Success Text<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="status_success_text" id="status_success_text" class="form-control"
                                                    placeholder="Status Success Text"  value="{{$data->status_success_text}}" required>
                                                @error('status_success_text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Meta Key<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="meta_key" id="meta_key" class="form-control"
                                                    placeholder="Meta Key"  value="{{$data->meta_key}}" >
                                                @error('meta_key')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Meta Title<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="meta_title" id="meta_title" class="form-control"
                                                    placeholder="Meta Title"  value="{{$data->meta_title}}" >
                                                @error('meta_title')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Meta Description<span style="color:red;font-size: 120%;">*</span></label>
                                                    <textarea name="meta_description" placeholder="Meta Description" class="form-control" required>{{$data->meta_description}}</textarea>
                                                @error('meta_description')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>Language<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="language" class="form-control" id="language" required>
                                                    @foreach ($languages as $value)
                                                        <option value="{{ $value->code }}" {{$value->code==$data->language?'selected':''}}>{{ $value->name }}</option>
                                                    @endforeach;
                                                </select>
                                                @error('language')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Status<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="status" class="form-control" required>
                                                    <option value="Published" {{$data->status=='Published'?'selected':''}} >Published</option>
                                                    <option value="Draft" {{$data->status=='Draft'?'selected':''}} >Draft</option>
                                                    <option value="Trash" {{$data->status=='Trash'?'selected':''}} >Trash</option>
                                                </select>
                                                @error('status')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>

                                            <div class="form-group ">
                                                <label for="exampleInputFile">Banner Image<span style="color:red;font-size: 120%;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="banner_image" id="banner_image" >
                                                        <label class="custom-file-label">Choose Image</label>
                                                    </div>
                                                </div>
                                                <small style="color:red;">Image Size should be 1920 × 788 px</small>
                                                @error('banner_image')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <img class="rounded-circle" id="banner_image_showImage" style="width: 150px;height:150px;" src="{{(!empty($data->banner_image))? url($data->banner_image):url('image-placeholder.png')}}">
                                            </div>
                                            
                                            {{-- image 2--}}
                                            <div class="form-group ">
                                                <label for="exampleInputFile">Page 2 Image<span style="color:red;font-size: 120%;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="page_2_image" id="page_2_image" >
                                                        <label class="custom-file-label">Choose Image</label>
                                                    </div>
                                                </div>
                                                <small style="color:red;">Image Size should be 354 × 550 px</small>
                                                @error('page_2_image')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <img class="rounded-circle" id="page_2_image_showImage" style="width: 150px;height:150px;" src="{{(!empty($data->page_2_image))? url($data->page_2_image):url('image-placeholder.png')}}">
                                            </div>
                                            {{-- image 3--}}
                                            <div class="form-group ">
                                                <label for="exampleInputFile">Page 3 Image<span style="color:red;font-size: 120%;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="page_3_image" id="page_3_image" >
                                                        <label class="custom-file-label">Choose Image</label>
                                                    </div>
                                                </div>
                                                <small style="color:red;">Image Size should be 354 × 550 px</small>
                                                @error('page_3_image')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <img class="rounded-circle" id="page_3_image_showImage" style="width: 150px;height:150px;" src="{{(!empty($data->page_3_image))? url($data->page_3_image):url('image-placeholder.png')}}">
                                            </div>
                                            {{-- image 4--}}
                                            <div class="form-group ">
                                                <label for="exampleInputFile">Page 4 Image<span style="color:red;font-size: 120%;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="page_4_image" id="page_4_image" >
                                                        <label class="custom-file-label">Choose Image</label>
                                                    </div>
                                                </div>
                                                <small style="color:red;">Image Size should be 354 × 550 px</small>
                                                @error('page_4_image')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <img class="rounded-circle" id="page_4_image_showImage" style="width: 150px;height:150px;" src="{{(!empty($data->page_4_image))? url($data->page_4_image):url('image-placeholder.png')}}">
                                            </div>
                                            {{-- image 5--}}
                                            <div class="form-group ">
                                                <label for="exampleInputFile">Page 5 Image<span style="color:red;font-size: 120%;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="page_5_image" id="page_5_image" >
                                                        <label class="custom-file-label">Choose Image</label>
                                                    </div>
                                                </div>
                                                <small style="color:red;">Image Size should be 	354 × 550 px</small>
                                                @error('page_5_image')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <img class="rounded-circle" id="page_5_image_showImage" style="width: 150px;height:150px;" src="{{(!empty($data->page_5_image))? url($data->page_5_image):url('image-placeholder.png')}}">
                                            </div>
                                            {{-- image 6--}}
                                            <div class="form-group ">
                                                <label for="exampleInputFile">Page 6 Image<span style="color:red;font-size: 120%;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="page_6_image" id="page_6_image" >
                                                        <label class="custom-file-label">Choose Image</label>
                                                    </div>
                                                </div>
                                                <small style="color:red;">Image Size should be 	354 × 550 px</small>
                                                @error('page_6_image')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <img class="rounded-circle" id="page_6_image_showImage" style="width: 150px;height:150px;" src="{{(!empty($data->page_6_image))? url($data->page_6_image):url('image-placeholder.png')}}">
                                            </div>
                                            {{-- image 7--}}
                                            <div class="form-group ">
                                                <label for="exampleInputFile">Page 7 Image<span style="color:red;font-size: 120%;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="page_7_image" id="page_7_image" >
                                                        <label class="custom-file-label">Choose Image</label>
                                                    </div>
                                                </div>
                                                <small style="color:red;">Image Size should be 354 × 550 px</small>
                                                @error('page_7_image')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <img class="rounded-circle" id="page_7_image_showImage" style="width: 150px;height:150px;" src="{{(!empty($data->page_7_image))? url($data->page_7_image):url('image-placeholder.png')}}">
                                            </div>
                                            {{-- pdf --}}
                                            <div class="form-group ">
                                                <label for="exampleInputFile">KYC Form<span style="color:red;font-size: 120%;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="kyc_form" id="kyc_form" >
                                                        <label class="custom-file-label">Choose File</label>
                                                    </div>
                                                </div>
                                                @error('kyc_form')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                @if (!empty($data->kyc_form))
                                                    <a href="{{url($data->kyc_form)}}" target="_blank" rel="noopener noreferrer">View KYC Form</a>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <center><input type="submit" value="Submit" class="btn btn-round btn-primary"></center>
                                </form>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>
@endsection
@section('script')
    <script src="https://cdn.ckeditor.com/4.19.1/standard/ckeditor.js"></script>
    <script>
        CKEDITOR.replace('description');
        CKEDITOR.replace('typical_benefits_description');
        CKEDITOR.replace('how_to_join_as_a_partner_description');
        CKEDITOR.replace('business_description');
        CKEDITOR.replace('marketing_description');
    </script>
    <script>
        $(document).ready(function() {
            //image
            $('#image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#image_showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });

            //banner_image
            $('#banner_image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#banner_image_showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
            //page_2_image
            $('#page_2_image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#page_2_image_showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
            //page_3_image
            $('#page_3_image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#page_3_image_showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
            //page_4_image
            $('#page_4_image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#page_4_image_showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
            //page_5_image
            $('#page_5_image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#page_5_image_showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
            //page_6_image
            $('#page_6_image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#page_6_image_showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
            //page_7_image
            $('#page_7_image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#page_7_image_showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
        });
    </script>
@endsection

