@php
$header_title="Aurobees | Partner Management | Partner";
$header_name = 'partner_management';
$page_name = 'partner';
@endphp
@extends('admin.admin_master')
@section('admin')
<style>
    .pagination-wrapper nav svg
    {
        width:20px!important;
    }
    .pagination-wrapper nav{
        display: inline-flex!important;
        width:100%;
        justify-content: space-between;
        margin-top:10px;
    }
    .pagination-wrapper nav div:nth-child(2)
    {
        display:flex;
        gap:15px;
    }

    .partner__data_table {
        overflow: auto;
    }

    .partner__data_table table#example {
        width: 1750px;
    }
</style>

    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Find a Partner</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard')}}">Dashboard</a></li>
                            <li class="breadcrumb-item active">Partner Management</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">List All Partner</h3>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                <form action="{{route('admin.partner.view')}}" id="search-form">
                                    <div class="row" style="align-items: end;">
                                        <div class="col-2">
                                            <div class="form-group">
                                                <label for="code">Registartion number</label>
                                                <input type="text" name="code" id="code" value="{{$code}}" class="form-control">
                                            </div>
                                        </div>
                                        <div class="col-2">
                                            <div class="form-group">
                                                <label for="company">Company Name</label>
                                                <input type="text" name="company" id="company" value="{{$company}}" class="form-control">
                                            </div>
                                        </div>
                                        <div class="col-2">
                                            <div class="form-group">
                                                <label for="country">Country</label> 
                                                <select name="country" id="country" class="form-control">
                                                    <option value="">Select</option>
                                                    @foreach($countryList as $item)
                                                        <option value="{{$item->code}}" @if($country==$item->code) selected @endif>{{$item->name}}</option>
                                                    @endforeach                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           ;
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-2">
                                            <div class="form-group">
                                                <label for="email">Email id</label>
                                                <input type="text" name="email" id="email" value="{{$email}}" class="form-control">
                                            </div>
                                        </div>
                                        <div class="col-2">
                                            <div class="form-group">
                                                <label for="phone">Mobile no</label>
                                                <input type="text" name="phone" id="phone" value="{{$phone}}" class="form-control">
                                            </div>
                                        </div>
                                        <div class="col-2">
                                            <div class="form-group">
                                                <label for="agreement_expire">Advanced Search</label>
                                                <select name="agreement_expire" id="agreement_expire" class="form-control">
                                                    <option value="">Select</option>
                                                    <option value="Y" @if($agreement_expire=='Y') selected @endif >Expired Partner's Agreement</option>
                                                    <option value="N" @if($agreement_expire=='N') selected @endif >Agreement Going to expire</option>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               ;
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-2 agreement_date_div">
                                            <div class="form-group">
                                                <label for="">Expired Agreement From Date</label>
                                                <input type="date" name="agreement_from_date" value="{{$agreement_from_date}}" class="form-control">
                                            </div>
                                        </div>
                                        <div class="col-2 agreement_date_div">
                                            <div class="form-group">
                                                <label for="">Expired Agreement To Date</label>
                                                <input type="date" name="agreement_to_date" value="{{$agreement_to_date}}" class="form-control">
                                            </div>
                                        </div>
                                        <div class="col-2">
                                            <div class="form-group">
                                                <input type="submit" value="Search" class="btn btn-success">
                                                <button type="button" onclick="exportExcel();" class="btn btn-info">Export </button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>



                            <div class="card-body">
                                <div class="partner__data_table">
                                    <table id="example" class="table table-bordered table-striped" cellspacing="0" width="100%">
                                        <thead>
                                            <tr>
                                                <th>Action</th>
                                                <th>#</th>
                                                <th>Registraion partner ID</th>
                                                <th>Bussiness registration Number</th>
                                                <th>Partner company name</th>
                                                <th>Country</th>
                                                <th>Aggrement From and to Date</th>
                                                <th>Contct Number</th>
                                                <th>Point of Contact</th>
                                                <th>Website</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @forelse ($datas as $key => $data)
                                                <tr>
                                                    <td>
                                                        <a href="{{route('admin.partner.edit',$data->id)}}" class="btn btn-rounded btn-info"><i class="fas fa-edit"></i></a>
                                                        <a href="{{route('admin.partner.delete',$data->id)}}" onclick="return confirm('Are you sure you want to delete this item?');" class="btn btn-rounded btn-danger"><i class="fas fa-trash"></i></a>
                                                        <a href="{{route('admin.partner.show',$data->id)}}"  class="btn btn-rounded btn-success"><i class="fas fa-eye"></i></a>
                                                    </td>
                                                    <td>{{ $key + 1 }}</td>
                                                    <td>{{ $data->code }}</td>
                                                    <td>{{\App\Providers\PartnerRegistrationProvider::GetParentData('company_registration_number', $data->id)}}</td>
                                                    <td>{{ $data->company }}</td>
                                                    <td>{{ @$data['Country']['name'] }}</td>
                                                    <td>{{ $data->agreement_from_date.' - '.$data->agreement_to_date }}</td>
                                                    <td>{{$data->phone}}</td>
                                                    <td>{{ $data->f_name.' '.$data->l_name }}</td>
                                                    <td>{{\App\Providers\PartnerRegistrationProvider::GetParentData('primary_company_website_or_social_media_page', $data->id)}}</td>
                                                    
                                                </tr>
                                            @empty
                                                <tr><td colspan="7" style="text-align: center;"><span>No Partner registered</span></td></tr>
                                            @endforelse
                                        </tbody>
                                    </table>
                                </div>
                                <div class="row">
                                    <div class="col-12">
                                        <div class="pagination-wrapper">
                                            {{ $datas->links() }}
                                        </div>
                                    </div>
                                </div>
                                
                                
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>
@endsection
@section('script')
    <script>
        $(document).ready(function() {
            $('#country').select2();
            $('.agreement_date_div').hide();

            @if($agreement_expire=='N')
                $('.agreement_date_div').show();
            @endif
        });

        $('#agreement_expire').on('change', function(){
            if($(this).val()=='N'){
                $('.agreement_date_div').show();
            }else{
                $('.agreement_date_div').hide();
            }
        });
        function exportExcel() {   
            var url = '{{ route('admin.partner.export') }}';
            let data = $('#search-form').serialize();
            window.location.href = url + '?' + data;
        }

    </script>
@endsection