@php
$header_title="Aurobees | Partner Management | Partner";
$header_name = 'partner_management';
$page_name = 'partner';
@endphp
@extends('admin.admin_master')
@section('admin')
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Partner</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard')}}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('admin.partner.view')}}">Partner Management</a></li>
                            <li class="breadcrumb-item active">View</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">View Partner Details</h3>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                <table class="table table-striped">
                                    <tbody>
                                        <tr>
                                            <th>First Name</th>
                                            <td>{{ $data->f_name }}</td>
                                        </tr>
                                        <tr>
                                            <th>Last Name</th>
                                            <td>{{ $data->l_name }}</td>
                                        </tr>
                                        <tr>
                                            <th>Phone</th>
                                            <td>{{ $data->phone }}</td>
                                        </tr>
                                        <tr>
                                            <th>Email</th>
                                            <td>{{ $data->email }}</td>
                                        </tr>
                                        <tr>
                                            <th>Company Name</th>
                                            <td>{{ $data->company }}</td>
                                        </tr>
                                        @if($data['Country'])
                                            <tr>
                                                <th>Country</th>
                                                <td>{{ $data['Country']['name'] }}</td>
                                            </tr>
                                        @endif
                                        @if($data['State'])
                                            <tr>
                                                <th>State</th>
                                                <td>{{ $data['State']['name'] }}</td>
                                            </tr>
                                        @endif
                                        <tr>
                                            <th>City</th>
                                            <td>{{ $data->city }}</td>
                                        </tr>
                                        <tr>
                                            <th>Address</th>
                                            <td>{{ $data->address }}</td>
                                        </tr>
                                        <tr>
                                            <th>Pincode</th>
                                            <td>{{ $data->pincode }}</td>
                                        </tr>
                                        @if($data['CallingCode'])
                                            <tr>
                                                <th>International Calling Code</th>
                                                <td>{{ '('.$data['CallingCode']['code'].')'. $data['CallingCode']['name']}}</td>
                                            </tr>
                                        @endif
                                        <tr>
                                            <th>Active Partner</th>
                                            <td>{{ ($data->status=='N')?'Yes':'No' }}</td>
                                        </tr>
                                        <tr>
                                            <th>Verified</th>
                                            <td>{{ ($data->is_email_verified=='1')?'Yes':'No' }}</td>
                                        </tr>
                                        @if(isset($partner_details) && !$partner_details->isEmpty())
                                        @foreach ($partner_details as $partner)
                                            <tr>
                                                <th><?=ucfirst(str_replace('_',' ',$partner->key))?></th>
                                                @php $arr=array('pan_card_copy','aadhar_card_copy','company_address_proof','company_registration_copy','passport_copy','passport_copy','passport_copy','kyc_form','acra_profile_copy','tax_registration_document','passport_size_photo','partners_signature_copy','partner_contract'); @endphp
                                                @if (in_array($partner->key,$arr))
                                                <td><a href="{{url($partner->value)}}" target="_blank">View</a></td>
                                                @else
                                                    <td>{{ $partner->value }}</td>
                                                @endif
                                            </tr>
                                        @endforeach
                                        @endif
                                    </tbody>
                                </table>
                                <hr>
                                <center><a href="{{ route('admin.partner.view') }}" class="btn btn-round btn-primary">Back</a></center>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>
@endsection
