@php
    $header_title = 'Aurobees | Pricing Management';
    $header_name = 'industries_management';
    $page_name = 'pricing';
@endphp
@extends('admin.admin_master')
@section('admin')
<style>
    .select2-container .select2-selection--single { height: 37px !important; }
</style>
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Pricing</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard')}}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('pricing.index') }}">Manage Pricing</a></li>
                        <li class="breadcrumb-item active">Feature</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <!-- /.content-header -->
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">{{$parent['LOB']['title']}}</h3>
                            <div style="float: right">
                                <a href="{{ route('pricing.index') }}" class="btn btn-link">Back</a>
                                <a href="{{route('pricing.feature.addnew',$id)}}" class="btn btn-primary btn-rounded">Add New</a>
                            </div>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <table id="example1" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Name</th>
                                        <th>Features</th>
                                        <th style="min-width: 100px;">Action</th>
                                    </tr>
                                </thead>
                                <tbody id="blog_category_body">
                                    @foreach ($datas as $key => $data)
                                        <tr>
                                            <td>{{ $key + 1 }}</td>
                                            <td>{{ $data->name }}</td>
                                            <td>
                                                <a href="{{route('pricing.addons',$data->id)}}" class="btn btn-link">Addons</a>
                                            </td>
                                            <td>
                                                <a href="{{ route('pricing.feature.edit',[$id,$data->id]) }}" class="btn btn-outline-info"><i class="fas fa-edit"></i></a>
                                                @if($data->status=='Trash')
                                                    <a href="{{ route('pricing.feature.delete',[$id,$data->id]) }}" onclick="return confirm('Are you sure you want to delete this item?');" class="btn btn-outline-danger"  title="Permanently delete"><i class="fas fa-trash"></i></a>
                                                @else
                                                    <a href="{{ route('pricing.feature.delete',[$id,$data->id]) }}" onclick="return confirm('Are you sure you want to trash this item?');" class="btn btn-outline-warning" title="Trash Item"><i class="fas fa-trash"></i></a>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
</div>
@endsection
