@php
    $header_title = 'Aurobees  | Setting | Currency';
    $header_name = 'setting_management';
    $page_name = 'setting_currency';
@endphp
@extends('admin.admin_master')
@section('admin')
    <style>
        .select2-container .select2-selection--single {
            height: 37px !important;
        }
    </style>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Currency</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard')}}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('setting.currency.list')}}">Currency</a></li>
                            <li class="breadcrumb-item active">Edit Currency</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Edit Currency</h3>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                <form method="POST" autocomplete="off" action="{{route('setting.currency.update',$data->id)}}" >
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Code<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" class="form-control" value="{{$data->code}}" disabled>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Rate<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="rate" class="form-control"
                                                    placeholder="Rate" value="{{$data->rate}}" required>
                                                @error('rate')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <center>
                                        <input type="submit" value="Submit" class="btn btn-round btn-primary">
                                        <a href="{{route('setting.currency.list')}}" class="btn btn-round btn-link">Back</a>
                                    </center>
                                </form>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>

@endsection
