@php
$header_title = 'Aurobees | Setting | Tax';
$header_name = 'setting_management';
$page_name = 'setting_gst';
@endphp
@extends('admin.admin_master')
@section('admin')
<style>
    .select2-container .select2-selection--single {
        height: 37px !important;
    }
</style>
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Tax</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard')}}">Dashboard</a></li>
                        <li class="breadcrumb-item active">Tax</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <!-- /.content-header -->
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title"> Tax</h3>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">

                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>Country</th>
                                        <th>Currency</th>
                                        <th>Tax Name</th>
                                        <th>Tax Rate</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($datas as $data)
                                    <form action="{{route('setting.gst.update')}}" method="post">
                                        @csrf
                                        <tr>
                                            <td>{{$data['CountryList']['name']}}</td>
                                            <td>{{$data->currency}}</td>
                                            <td>
                                                <input type="text" value="{{ $data->tax_name }}" name="tax_name" class="form-control" required>
                                                @error('tax_name')
                                                <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </td>
                                            <td>
                                                <input type="text" value="{{ $data->rate }}" name="rate" class="form-control" required>
                                                <input type="hidden" value="{{ $data->id }}" name="id" required>
                                                @error('rate')
                                                <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </td>
                                            <td>
                                                <input type="submit" value="Update" class="btn btn-outline-info">
                                            </td>
                                        </tr>
                                    </form>
                                    @endforeach
                                </tbody>
                            </table>

                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
</div>
@endsection
