@php
$header_title = 'Aurobees | Setting | Payment Gateway';
$header_name = 'setting_management';
$page_name = 'setting_payment-gateway';
@endphp
@extends('admin.admin_master')
@section('admin')
<style>
    .select2-container .select2-selection--single {
        height: 37px !important;
    }
</style>
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Payment Gateway</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard')}}">Dashboard</a></li>
                        <li class="breadcrumb-item active">AuroPay Key</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <!-- /.content-header -->
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">AuroPay Key</h3>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">

                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>Country</th>
                                        <th>Api Key</th>
                                        <th>Access Key </th>
                                        <th>Secret Key </th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($datas as $data)
                                    <form action="{{route('setting.payment-gateway.update')}}" method="post">
                                        @csrf
                                        <tr>
                                            <td>{{$data['CountryList']['name']}}</td>
                                            <td>
                                                <input type="text" value="{{ $data->apikey }}" name="apikey" class="form-control" required>
                                                @error('apikey')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </td>
                                            <td>
                                                <input type="text" value="{{ $data->accesskey }}" name="accesskey" class="form-control" required>
                                                @error('accesskey')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </td>
                                            <td>
                                                <input type="text" value="{{ $data->secretkey }}" name="secretkey" class="form-control" required>
                                                <input type="hidden" value="{{ $data->id }}" name="id" required>
                                                @error('secretkey')
                                                <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </td>
                                            <td>
                                                <input type="submit" value="Update" class="btn btn-outline-info">
                                            </td>
                                        </tr>
                                    </form>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
</div>
@endsection
