@php
$header_title="Aurobees | User Management | User";
$header_name = 'home';
$page_name = 'user';
@endphp
@extends('admin.admin_master')
@section('admin')
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>User</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                             <li class="breadcrumb-item"><a href="{{ route('dashboard')}}">Dashboard</a></li>
                            <li class="breadcrumb-item active">User</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Edit User</h3>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                <form method="POST" autocomplete="off" action="{{ route('user.update',$data->id) }}">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>First Name<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="f_name" id="f_name" value="{{$data->f_name}}" class="form-control" placeholder="Enter First Name" required>
                                                @error('f_name')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Last Name<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="l_name" id="l_name" value="{{$data->l_name}}" class="form-control" placeholder="Enter Last Name" required>
                                                @error('l_name')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Phone Number<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="number" name="phone" id='phone' value="{{$data->phone}}" class="form-control" placeholder="Enter Phone Number" required>
                                                @error('phone')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Email<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="email" name="email" id="email" value="{{$data->email}}" class="form-control" placeholder="Enter Email" readonly>
                                                @error('email')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <center><input type="submit" value="Update" class="btn btn-round btn-primary"></center>
                                </form>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>

    <script>
        //Dealer Name
        jQuery(document).on('keypress', '#f_name,#l_name,#company,#state,#city', function(event) {
            $(this).css({'text-transform': 'capitalize'});
            var regex = new RegExp("^[a-zA-Z ]+$");
            var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
            if (!regex.test(key)) {
                event.preventDefault();
                return false;
            }
        });
        //phone
        jQuery(document).on('keypress', '#phone', function(event) {
            var regex = new RegExp("^[0-9]+$");
            var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
            if (!regex.test(key)) {
                event.preventDefault();
                return false;
            }
            var phone_no=$('#phone').val();
            if(phone_no.length>10){
                return false;
            }
        });
    </script>
@endsection
