<div class="tab-pane fade" id="basic-information" role="tabpanel">
    <div class="form_content_inner">
        <form name='basic-information'>
            @csrf
            <div class="edit_form">
                <a href="javascript:void(0);" class="edit-button-basic-information">Edit</a>
            </div>
            <div class="form_group">
                <label for="">How did you hear about our program?<span style="color: red;">*</span></label>
                <div class="form_feild">
                    @php $how_did_you_hear_about_our_program=@$data['how_did_you_hear_about_our_program']; @endphp
                    <select name="how_did_you_hear_about_our_program" class="edit-field-basic-information"  id="how_did_you_hear_about_our_program">
                        <option value="Website" @if($how_did_you_hear_about_our_program=='Website') selected @endif >Website</option>
                        <option value="Google" @if($how_did_you_hear_about_our_program=='Google') selected @endif >Google</option>
                        <option value="Social Media" @if($how_did_you_hear_about_our_program=='Social Media') selected @endif >Social Media</option>
                        <option value="Email Newslatter" @if($how_did_you_hear_about_our_program=='Email Newslatter') selected @endif >Email Newslatter</option>
                        <option value="Employess" @if($how_did_you_hear_about_our_program=='Employess') selected @endif >Employess</option>
                        <option value="Existing Partners" @if($how_did_you_hear_about_our_program=='Existing Partners') selected @endif >Existing Partners</option>
                        <option value="Event and Promotions" @if($how_did_you_hear_about_our_program=='Event and Promotions') selected @endif >Event and Promotions</option>
                        <option value="Others" @if($how_did_you_hear_about_our_program=='Others') selected @endif >Others</option>
                    </select>
                </div>
            </div>
            <div class="form_group">
                <label for="">In what region do you want to represent Aurobees as a channel partner?<span style="color: red;">*</span></label>
                <div class="form_feild">
                    <div class="form_feild">
                        @php $in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner=@$data['in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner']; @endphp
                        <select name="in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner" class="edit-field-basic-information" id="in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner">
                            <option value="">Select</option>
                            <option value="APAC(Asia Pacific)" @if($in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner=='APAC(Asia Pacific)') selected @endif >APAC(Asia Pacific)</option>
                            <option value="Europe" @if($in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner=='Europe') selected @endif >Europe</option>
                            <option value="Middle East" @if($in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner=='Middle East') selected @endif >Middle East</option>
                            <option value="Africa" @if($in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner=='Africa') selected @endif >Africa</option>
                            <option value="India" @if($in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner=='India') selected @endif >India</option>
                            <option value="North America" @if($in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner=='North America') selected @endif >North America</option>
                            <option value="South America" @if($in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner=='South America') selected @endif >South America</option>
                            <option value="Australasia" @if($in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner=='Australasia') selected @endif >Australasia</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="form_group">
                <label for="">Individual / Business<span style="color: red;">*</span> </label>
                @php $individual_business=@$data['individual_business']; @endphp
                <div class="form_feild radio-wrap">
                    <div class="radio_button">
                        <input type="radio" id="Individual"  class="edit-field-basic-information"  name="individual_business" @if($individual_business=='Individual') checked @endif value="Individual">
                        <label for="Individual">Individual</label>
                    </div>
                    <div class="radio_button">
                        <input type="radio" id="Business"  class="edit-field-basic-information"  name="individual_business" @if($individual_business=='Business') checked @endif value="Business">
                        <label for="Business">Business</label>
                    </div>
                </div>
            </div>
            <div class="save_discard div-button-basic-information">
                <button type="button" class="discard_btn discard-button-basic-information">DISCARD</button>
                <button type="submit" class="save_btn save-button-basic-information">SAVE</button>
            </div>
        </form>
    </div>
</div>

<script>
    var oldBasicInformation = $("form[name='basic-information']").serialize();

    function editFieldBillingInformation(status) {
        const editFields = document.querySelectorAll('.edit-field-basic-information');
        editFields.forEach((element) => {
            element.disabled = status;
        });
        if (status == false) {
            $('.edit-button-basic-information').hide();
            $('.div-button-basic-information').show();
            $('#billing_company_name').focus();
        } else {
            $('.edit-button-basic-information').show();
            $('.div-button-basic-information').hide();
        }
    }
    //default
    editFieldBillingInformation(true);
    //edit button
    $(document).on('click', '.edit-button-basic-information', function() {
        editFieldBillingInformation(false);
    });
    //data submit
    jQuery(function() {
        jQuery("form[name='basic-information']").validate({
            rules: {
                how_did_you_hear_about_our_program:'required',
                in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner:'required',
                individual_business:'required'
            },
            // Specify validation error messages
            messages: {
                how_did_you_hear_about_our_program:"Please select How did you hear about our program.",
                in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner:"Please select In what region do you want to represent Aurobees as a channel partner.",
                individual_business:"Please check Individual / Business"
            },
            submitHandler: function(form) {
                var formData = $("form[name='basic-information']").serialize();
                $.ajax({
                    type: "POST",
                    url: "{{route('partner.profile.basic-information.update')}}",
                    data: formData,
                    success: function(response) {
                        oldBasicInformation = formData;
                        editFieldBillingInformation(true);
                        AlertMassage(response.message);
                        // $('#basic-information-value').val(20);
                        ProgressGraphStatus();
                    },
                    error: function(xhr, status, error) {
                        AlertMassage(`{{ \App\Providers\MessageManagementProvider::MessageManage('customer-profile-something-wrong') }}`);
                    }
                });
            }
        });
    });
    //discard button
    $(document).on('click', '.discard-button-basic-information', function() {
        var params = new URLSearchParams(oldBasicInformation);

        // Set values for each form field using the extracted values
        setFieldValue("how_did_you_hear_about_our_program", params.get("billing_company_name"));
        setFieldValue("in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner", params.get("billing_country"));
        radioButton(params.get("individual_business"));
        editFieldBillingInformation(true);
    });

    function radioButton(value){
        if(value=='Individual'){ $('#Individual').trigger('click');}
        if(value=='Business'){ $('#Business').trigger('click');}
    }
</script>
