<div class="tab-pane fade" id="company-financial-information-1" role="tabpanel">
    <div class="form_content_inner">
        <form name='company-financial-information'>
            @csrf
            <div class="edit_form">
                <a href="javascript:void(0);" class="edit-button-company-financial-information">Edit</a>
            </div>
            <div class="form_group">
                <label>What was the total sales and services revenue generated by your company in its last fiscal year (USD) <span style="color: red;">*</span></label>
                <div class="form_feild">
                    @php $total_sales=$data['what_was_the_total_sales_and_services_revenue_generated_by_your_company_in_its_last_fiscal_year']; @endphp
                    <select name="what_was_the_total_sales_and_services_revenue_generated_by_your_company_in_its_last_fiscal_year" id="what_was_the_total_sales_and_services_revenue_generated_by_your_company_in_its_last_fiscal_year" class="edit-field-company-financial-information">
                        <option value="">Select</option>
                        <option @if($total_sales=='Less than 20,000') selected @endif value="Less than 20,000">Less than 20,000</option>
                        <option @if($total_sales=='Less than 50,000') selected @endif value="Less than 50,000">Less than 50,000</option>
                        <option @if($total_sales=='Less than 100,000') selected @endif value="Less than 100,000">Less than 100,000</option>
                        <option @if($total_sales=='Less than 200,000') selected @endif value="Less than 200,000">Less than 200,000</option>
                        <option @if($total_sales=='More than 200,000') selected @endif value="More than 200,000">More than 200,000</option>
                    </select>
                </div>
            </div>
            <div class="form_group full_label mt-0">
                <label>What percentage of your revenue directly results from the following sales methods in the last fiscal year (must be total 100%)</label>
            </div>
            <div class="form_group">
                <label>Face-to-Face / Field sales</label>
                <div class="form_feild">
                    <input type="text" name="face_to_face_field_sales" value="{{$data['face_to_face_field_sales']}}" id="face_to_face_field_sales" placeholder="" class="edit-field-company-financial-information">
                </div>
            </div>
            <div class="form_group ">
                <label>Telephone Based Consultative Sales Resources</label>
                <div class="form_feild">
                    <input type="text" placeholder="" name="telephone_based_consultative_sales_resources" id="telephone_based_consultative_sales_resources" value="{{@$data['telephone_based_consultative_sales_resources']}}" class="edit-field-company-financial-information">
                </div>
            </div>
            <div class="form_group ">
                <label>Via Internet with limited human interference</label>
                <div class="form_feild">
                    <input type="text" placeholder="" name="via_internet_with_limited_human_interference" id="via_internet_with_limited_human_interference"  value="{{$data['via_internet_with_limited_human_interference']}}" class="edit-field-company-financial-information">
                </div>
            </div>
            <div class="form_group  radio-btn ">
                <label>Do you have a single primary vertical market?<span style="color: red;">*</span></label>
                <div class="form_feild">
                    @php $do_you_have_a_single_primary_vertical_market=$data['do_you_have_a_single_primary_vertical_market']; @endphp
                    <div class="radio_sec radio-wrap">
                        <div class="radio_button">
                            <input type="radio" id="yes_primary_vertical" name="do_you_have_a_single_primary_vertical_market" @if($do_you_have_a_single_primary_vertical_market=='Yes') checked @endif  value="Yes" class="edit-field-company-financial-information">
                            <label for="yes_primary_vertical">Yes</label>
                        </div>
                        <div class="radio_button">
                            <input type="radio" id="No_primary_vertical" name="do_you_have_a_single_primary_vertical_market" @if($do_you_have_a_single_primary_vertical_market=='No') checked @endif  value="No" class="edit-field-company-financial-information">
                            <label for="No_primary_vertical">No</label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="form_group select-opt ">
                <label>What is your company’s primary vertical market focus?<span style="color: red;">*</span></label>
                <div class="form_feild">
                    @php $what_is_your_company_primary_vertical_market_focus = $data['what_is_your_company_primary_vertical_market_focus']; @endphp
                    <select name="what_is_your_company_primary_vertical_market_focus" id="what_is_your_company_primary_vertical_market_focus" class="edit-field-company-financial-information">
                        <option value="">select </option>
                            @if(!$market_sectors_lists->isEmpty())
                                @foreach ($market_sectors_lists as $item)
                                    <option @if($what_is_your_company_primary_vertical_market_focus==$item->name) selected @endif  value="{{$item->name}}">{{$item->name}}</option>
                                @endforeach
                            @endif
                    </select>
                </div>
            </div>
            <div class="form_group full_label resp_spacing prof_spacing ">
                <label>Please specify the number of employees by job category <br>(If a person has multiple roles, count them in one category)</label>
            </div>
            <div class="form_group profile_check ">
                <label>Total number of Employees</label>
                <div class="form_feild">
                    <input type="text" name="total_number_of_employees" value="{{$data['total_number_of_employees']}}" id="total_number_of_employees" placeholder="" class="edit-field-company-financial-information">
                </div>
            </div>
            <div class="form_group profile_check ">
                <label>Total number of Sales Employees</label>
                <div class="form_feild">
                    <input type="text" name="total_number_of_sales_employees" value="{{$data['total_number_of_sales_employees']}}" id="total_number_of_sales_employees" placeholder="" class="edit-field-company-financial-information">
                </div>
            </div>
            <div class="form_group profile_check ">
                <label>Total number of Services</label>
                <div class="form_feild">
                    <input type="text" name="total_number_of_services" value="{{$data['total_number_of_services']}}" id="total_number_of_services" placeholder="" class="edit-field-company-financial-information">
                </div>
            </div>
            <div class="form_group profile_check ">
                <label>Total number of Technical Support Employees</label>
                <div class="form_feild">
                    <input type="text" name="total_number_of_technical_support_employees" value="{{$data['total_number_of_technical_support_employees']}}" id="total_number_of_technical_support_employees" placeholder="" class="edit-field-company-financial-information">
                </div>
            </div>
            <div class="form_group profile_check ">
                <label>Total number of Marketing Employees</label>
                <div class="form_feild">
                    <input type="text" name="total_number_of_marketing_employees" value="{{$data['total_number_of_marketing_employees']}}" id="total_number_of_marketing_employees" placeholder="" class="edit-field-company-financial-information">
                </div>
            </div>
            <div class="save_discard div-button-company-financial-information">
                <button type="button" class="discard_btn discard-button-company-financial-information" >DISCARD</button>
                <button type="submit" class="save_btn save-button-company-financial-information" >SAVE</button>
            </div>
        </form>
    </div>
</div>


<script>
    var oldCompanyFinancialInformation=$("form[name='company-financial-information']").serialize();

    function editFieldCompanyFinancialInformation(status){
        const editFields = document.querySelectorAll('.edit-field-company-financial-information');
        editFields.forEach((element) => {
            element.disabled = status;
        });
        if(status==false){
            $('.edit-button-company-financial-information').hide();
            $('.div-button-company-financial-information').show();
            $('#f_name').focus();
        }else{
            $('.edit-button-company-financial-information').show();
            $('.div-button-company-financial-information').hide();
        }
    }
    //default
    editFieldCompanyFinancialInformation(true);
    //edit button
    $(document).on('click', '.edit-button-company-financial-information', function(){
        editFieldCompanyFinancialInformation(false);
    });

    //data submit
    jQuery(function() {
        jQuery("form[name='company-financial-information']").validate({
            rules: {
                what_was_the_total_sales_and_services_revenue_generated_by_your_company_in_its_last_fiscal_year:'required',
                do_you_have_a_single_primary_vertical_market:'required',
                what_is_your_company_primary_vertical_market_focus:'required'
            },
            // Specify validation error messages
            messages: {
                what_was_the_total_sales_and_services_revenue_generated_by_your_company_in_its_last_fiscal_year : "Please select Please select What was the total sales and services revenue generated by your company in its last fiscal year (USD).",
                do_you_have_a_single_primary_vertical_market : "Please select Please select Do you have a single primary vertical market?.",
                what_is_your_company_primary_vertical_market_focus : "Please select Please select What is your company’s primary vertical market focus."
            },
            submitHandler: function(form) {
                var formData = $("form[name='company-financial-information']").serialize();
                $.ajax({
                    type: "POST",
                    url: "{{route('partner.profile.company-financial-information.update')}}",
                    data: formData,
                    success: function(response) {
                        oldCompanyFinancialInformation=formData;
                        editFieldCompanyFinancialInformation(true);
                        AlertMassage(response.message);
                        ProgressGraphValueAppend();
                    },
                    error: function(xhr, status, error) {
                        AlertMassage(`{{ \App\Providers\MessageManagementProvider::MessageManage('customer-profile-something-wrong') }}`);
                    }
                });
            }
        });
    });
    //discard button
    $(document).on('click', '.discard-button-company-financial-information', function(){
        var params = new URLSearchParams(oldCompanyFinancialInformation);

        // Set values for each form field using the extracted values
        setFieldValue("what_was_the_total_sales_and_services_revenue_generated_by_your_company_in_its_last_fiscal_year", params.get("what_was_the_total_sales_and_services_revenue_generated_by_your_company_in_its_last_fiscal_year"));
        setFieldValue("face_to_face_field_sales", params.get("face_to_face_field_sales"));
        setFieldValue("telephone_based_consultative_sales_resources", params.get("telephone_based_consultative_sales_resources"));
        setFieldValue("via_internet_with_limited_human_interference", params.get("via_internet_with_limited_human_interference"));
        setFieldValue("what_is_your_company_primary_vertical_market_focus", params.get("what_is_your_company_primary_vertical_market_focus"));
        setFieldValue("total_number_of_employees", params.get("total_number_of_employees"));
        setFieldValue("total_number_of_sales_employees", params.get("total_number_of_sales_employees"));
        setFieldValue("total_number_of_services", params.get("total_number_of_services"));
        setFieldValue("total_number_of_technical_support_employees", params.get("total_number_of_technical_support_employees"));
        setFieldValue("total_number_of_marketing_employees", params.get("total_number_of_marketing_employees"));

        radioButtonCFI(params.get("do_you_have_a_single_primary_vertical_market"));

        editFieldCompanyFinancialInformation(true);
    });
    function radioButtonCFI(value){
        if(value=='Yes'){ $('#yes_primary_vertical').trigger('click');}
        if(value=='No'){ $('#No_primary_vertical').trigger('click');}
    }

    function ProgressGraphValueAppend(){
        let financialInformationValue=0;
        if($('#face_to_face_field_sales').val()){ financialInformationValue++; }
        if($('#telephone_based_consultative_sales_resources').val()){ financialInformationValue++; }
        if($('#via_internet_with_limited_human_interference').val()){ financialInformationValue++; }
        if($('#total_number_of_employees').val()){ financialInformationValue++; }
        if($('#total_number_of_sales_employees').val()){ financialInformationValue++; }
        if($('#total_number_of_services').val()){ financialInformationValue++; }
        if($('#total_number_of_technical_support_employees').val()){ financialInformationValue++; }
        if($('#total_number_of_marketing_employees').val()){ financialInformationValue++; }
        $('#company-financial-information-value').val(financialInformationValue);
        ProgressGraphStatus();
    }
</script>