@php
$meta_title = 'Aurobees | Dashboard';
$meta_description = '';
$meta_keywords = '';
$add_class_header='show-nav';
$footer_sign_up_for_free_trial=true;
$active_page='customer-account-profile';
@endphp

@if(!$datas->isEmpty())
    @php
    $data=array();
    @endphp
    @foreach ($datas as $val)
        @php
            $data[$val->key]=$val->value;
        @endphp
    @endforeach
@endif
@extends('frontend.user.includes.master')
@section('body')
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.3/js/select2.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.13/js/intlTelInput-jquery.min.js"></script>
<div class="dashboard_bg">
    <section class="usr_dashboard_user">
        <div class="container">
            <div class="row">
                <div class="col-md-3"></div>
                <div class="col-md-9">
                    <div class="usr_dashboard_title">
                        <h1>ACCOUNT PROFILE</h1>
                        <div class="d-flex">
                            <div class="log_out_btn">
                                <a href="javascript:void(0);" onclick="$('#logout-form').submit();">Log Out</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-3">
                    @include('frontend.become_a_partner.includes.body.sidebar')
                </div>
                <div class="col-md-9">
                    <div class="scroll_screen">
                        <div class="dashboard_right acc-dash-right">
                            <div class="dashboard_top_strip">
                                <div class="d-flex">
                                    <div class="status_pro">
                                        <form id="uploadForm">
                                            @csrf
                                            <input type="file" name="photo" id="photo" style="display: none" accept=".png, .jpg, .jpeg">
                                            <div class="user_profile_img">
                                                <img src="{{ (!empty(Auth::user()->profile_photo_path))? url(Auth::user()->profile_photo_path):url('img/dummy.png') }}" id="photoImage" alt="User Image">
                                            </div>
                                            <div class="edit_remove_link">
                                                <a href="javascript:void(0);" onclick="uploadPhoto();">Update</a>
                                                @if(!empty(Auth::user()->profile_photo_path)) <a href="javascript:void(0);" onclick="removePhoto();">Remove</a>@endif
                                            </div>
                                        </form>
                                    </div>
                                    <div class="user_profile_content">
                                        <h4><a href="javascript:void(0);">{{Auth::user()->f_name.' '.Auth::user()->l_name}}</a></h4>
                                        <h5 class="custom-tooltip" data-tooltip-content="By using this partner code you can enrole the new customer.">{{Auth::user()->code}}</h5>
                                        <h6><a href="javascript:void(0);"><img src="{{url('frontend/images/location-img.svg')}}" alt="img"> {{Auth::user()->address}}</a></h6>
                                    
                                        <div class="border_description">
                                            <form id="edit_bio" name="update-bio">
                                                @csrf
                                                <textarea name="bio" class="form-control edit-bio" id="textarea-edit-bio"><?= @$partnerBio ?></textarea>
                                                <a href="javascript:void(0);" class="update-bio-button" onclick="updateBio();">Update</a>
                                                <a href="javascript:void(0);" class="edit-bio-button" onclick="editBio();">Edit</a>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                <div class="Profile__completion__status">
                                    <h2>Profile Completion Status</h2>
                                    <div class="progress">
                                        {{-- ------------------------------------------ --}}
                                        @php
                                        $profileStatus=82;
                                        if(!empty(Auth::user()->profile_photo_path)){$profileStatus+=5;}
                                        if(@$partnerBio){$profileStatus+=5;}
                                        $financialInformationValue=0;
                                        if(@$data['face_to_face_field_sales']){$financialInformationValue++;}
                                        if(@$data['telephone_based_consultative_sales_resources']){$financialInformationValue++;}
                                        if(@$data['via_internet_with_limited_human_interference']){$financialInformationValue++;}
                                        if(@$data['total_number_of_employees']){$financialInformationValue++;}
                                        if(@$data['total_number_of_sales_employees']){$financialInformationValue++;}
                                        if(@$data['total_number_of_services']){$financialInformationValue++;}
                                        if(@$data['total_number_of_technical_support_employees']){$financialInformationValue++;}
                                        if(@$data['total_number_of_marketing_employees']){$financialInformationValue++;}
                                        $profileStatus= $profileStatus+$financialInformationValue;
                                        @endphp
                                        <input type="hidden" id="default-value" class="progress-data" value="82">
                                        <input type="hidden" id="profile-photo-value" class="progress-data" value="<?= (!empty(Auth::user()->profile_photo_path)) ? 5 : 0 ?>">
                                        <input type="hidden" id="bio-value" class="progress-data" value="<?= (@$partnerBio) ? 5 : 0 ?>">
                                        <input type="hidden" id="company-financial-information-value" class="progress-data" value="<?= @$financialInformationValue ?>">
                                        {{-- ------------------------------------------ --}}
                                        <div class="progress-done" data-done="<?=@$profileStatus?>"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab_grid n-tab-grid">
                                <ul class="nav nav-pills">
                                    <li><button class="nav-link demo_class active" data-bs-toggle="pill" data-bs-target="#login-information" type="button">Login Information</button></li>
                                    <li><button class="nav-link demo_class" data-bs-toggle="pill" data-bs-target="#basic-information" type="button">Basic Information</button></li>
                                    <li><button class="nav-link demo_class" data-bs-toggle="pill" data-bs-target="#company-information" type="button">Company Information</button></li>
                                    <li><button class="nav-link demo_class" data-bs-toggle="pill" data-bs-target="#company-financial-information-1" type="button">Company Financial Information</button></li>
                                    <li><button class="nav-link demo_class" data-bs-toggle="pill" data-bs-target="#company-documents-upload" type="button">Company Documents Upload</button></li>
                                    <li><button class="nav-link demo_class" data-bs-toggle="pill" data-bs-target="#contract-renewal" type="button">Contract Renewal</button></li>
                                </ul>
                                <div class="tab-content">
                                    @if(!$datas->isEmpty())
                                        
                                        @include('frontend.become_a_partner.profile.login-information')
                                        @include('frontend.become_a_partner.profile.basic-information')
                                        @include('frontend.become_a_partner.profile.company-information')
                                        @include('frontend.become_a_partner.profile.company-financial-information-1')
                                        @include('frontend.become_a_partner.profile.company-documents-upload')
                                        @include('frontend.become_a_partner.profile.contract-renewal')
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @include('frontend.become_a_partner.includes.body.help-center-mobile')
        </div>
    </section>
</div>
@endsection
@section('script')
<script>
    function ProgressGraphStatus() {
        var graphData = 0;
        $('.progress-data').each(function () {
            graphData += parseInt($(this).val());
        });
        $('.progress-done').css('width', graphData + '%');
        $('.progress-done').attr('data-done', graphData);
    }
</script>
<script>
    const progress = document.querySelector('.progress-done');
    progress.style.width = progress.getAttribute('data-done') + '%';
    progress.style.opacity = 1;
    $('body').on('click keydown keypress touchstart pointerdown', '.iti__country.iti__standard', function () {
        var flagElement = $(this).find('.iti__flag').attr('class');
        var newText = flagElement.replace("iti__flag iti__", "");
        if ($(this).closest('.form_feild').find('.calling_code').length > 0) {
            $(this).closest('.form_feild').find('.calling_code').val(newText);
        } else {
            $('.calling_code').val(newText);
        }
    });
</script>
<script>
    //photo
    $('#photo').on('change', function (e) {
        var input = e.target;
        var reader = new FileReader();
        // Check if a file is selected
        if (input.files && input.files[0]) {
            var fileType = input.files[0].type;
            // Check if the selected file is an image and has a valid extension
            if (fileType.startsWith('image/') && /\.(png|jpg|jpeg)$/i.test(input.files[0].name)) {
                reader.onload = function (e) {
                    $('#photoImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(input.files[0]);
                uploadPhoto();
            } else {
                // Display an error message for invalid file types
                AlertMassage('Please select a valid PNG, JPG, or JPEG image.');
                $('#photo').val(''); // Clear the file input
                $('#photoImage').attr('src', ''); // Clear the image preview
            }
        }
    });
    $('#photoImage').on('click', function (e) {
        e.preventDefault();
        $('#photo')[0].click();
    });
    //add profile photo
    function uploadPhoto() {
        // Get the form and the photo input element
        const form = $('#uploadForm')[0];
        const photoInput = $('#photo')[0];
        // Check if a file has been selected
        if (!photoInput.files || !photoInput.files[0]) {
            // AlertMassage(`{{ \App\Providers\MessageManagementProvider::MessageManage('customer-profile-photo-select-a-photo') }}`);
            $('#photo').click();
            return;
        }
        // Create a new FormData object
        const formData = new FormData(form);
        // Send the AJAX request
        $.ajax({
            url: "{{route('partner.profile.photo.update')}}",
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function (response) {
                AlertMassage(response.message);
                location.reload();
            },
            error: function (error) {
                // $('#photo').click();
                AlertMassage(`{{ \App\Providers\MessageManagementProvider::MessageManage('customer-profile-photo-error-uploading-photo') }}`);
            }
        });
    }
    //remove profile photo
    function removePhoto() {
        // Get the form and the photo input element
        const form = $('#uploadForm')[0];
        // Create a new FormData object
        const formData = new FormData(form);
        // Send the AJAX request
        $.ajax({
            url: "{{route('partner.profile.photo.remove')}}",
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function (response) {
                AlertMassage(response.message);
                location.reload();
            },
            error: function (error) {
                AlertMassage(`{{ \App\Providers\MessageManagementProvider::MessageManage('customer-profile-photo-error-remove-photo') }}`);
            }
        });
    }

    //bio function
    function editFieldBio(status) {
        if (status === true) {
            $('.update-bio-button').show();
            $('.edit-bio-button').hide();
            $('.edit-bio').prop('disabled', false);
            $('#textarea-edit-bio').focus();
        } else {
            $('.update-bio-button').hide();
            $('.edit-bio-button').show();
            $('.edit-bio').prop('disabled', true);
        }
    }
    //updateBio
    function updateBio() {
        if ($('.edit-bio').val()) {
            var formData = $("form[name='update-bio']").serialize();
            $.ajax({
                type: "POST",
                url: "{{route('partner.profile.bio.update')}}",
                data: formData,
                success: function (response) {
                    editFieldBio(false);
                    AlertMassage(response.message);
                    if($('.edit-bio').val()){
                        $('#bio-value').val(5);
                    }else{
                        $('#bio-value').val(0);
                    }
                    ProgressGraphStatus();
                },
                error: function (xhr, status, error) {
                    AlertMassage(`{{ \App\Providers\MessageManagementProvider::MessageManage('customer-profile-something-wrong') }}`);
                }
            });
        } else {
            AlertMassage(`{{ \App\Providers\MessageManagementProvider::MessageManage('customer-profile-about-blank') }}`);
        }
    }
    //editBio
    function editBio() {
        editFieldBio(true);
    }
    //default
    editFieldBio(false);
</script>
@endsection
