<div class="tab-pane fade active show" id="login-information" role="tabpanel">
    <div class="form_content_inner">
        <form name='login-information'>
            @csrf
            <div class="edit_form">
                <a href="javascript:void(0)" class="edit-button-login-information">Edit</a>
            </div>
            <div class="form_group">
                <label for="">First Name</label>
                <div class="form_feild">
                    <input type="text" maxlength="40" name='f_name' id="f_name" value="{{Auth::user()->f_name}}" disabled >
                </div>
            </div>
            <div class="form_group">
                <label for="">Last Name</label>
                <div class="form_feild">
                    <input type="text"  maxlength="40" name='l_name' id="l_name" value="{{Auth::user()->l_name}}" disabled >
                </div>
            </div>
            <div class="form_group">
                <label for="">Email</label>
                <div class="form_feild">
                    <input type="text" disabled value="{{Auth::user()->email}}" disabled>
                </div>
            </div>
            <div class="form_group">
                <label>Contact</label>
                <div class="form_feild">
                    <input type="text" id="mobile_code" class="form-control" disabled value="{{Auth::user()->phone}}" disabled>
                </div>
            </div>
            <div class="form_group">
                <label for="">Designation<span style="color: red;">*</span></label>
                <div class="form_feild">
                    <input type="text" class="edit-field-login-information" maxlength="100" name='designation' id="designation" value="{{@$data['designation']}}">
                </div>
            </div>
            <div class="form_group">
                <label for="">Agreement from Date</label>
                <div class="form_feild">
                    <input type="text" disabled value="{{Auth::user()->agreement_from_date}}" disabled>
                </div>
            </div>
            <div class="form_group">
                <label for="">Agreement to Date</label>
                <div class="form_feild">
                    <input type="text" disabled value="{{Auth::user()->agreement_to_date}}" disabled>
                </div>
            </div>
            <div class="form_group">
                <label for="">Partner Commission Percentage</label>
                <div class="form_feild">
                    <input type="text" disabled value="{{Auth::user()->partner_commission_percentage}}" disabled>
                </div>
            </div>
            <div class="save_discard div-button-login-information">
                <button type="button" class="discard_btn discard-button-login-information">DISCARD</button>
                <button type="submit" class="save_btn save-button-login-information">SAVE</button>
            </div>
        </form>
    </div>
</div>


<script>
    $("document").ready(function () {
        // -----Country Code Selection
        $("#mobile_code").intlTelInput({
            initialCountry: "{{(Auth::user()->calling_code)?Auth::user()->calling_code:'auto'}}",
            separateDialCode: true,
        });
    });
</script>

<script>
    var loginInformation = $("form[name='login-information']").serialize();
    // Function to set value to the input or select field
    function setFieldValue(fieldName, value) {
        var field = document.querySelector(`[name="${fieldName}"]`);
        if (field) {
            if (field.tagName === "INPUT") {
                field.value = value;
            } else if (field.tagName === "SELECT") {
                // Find the option with the given value and set it as selected
                var option = field.querySelector(`option[value="${value}"]`);
                if (option) {
                    option.selected = true;
                }
            }
        }
    }
    //editFieldLoginInformation
    function editFieldLoginInformation(status) {   
        const editFields = document.querySelectorAll('.edit-field-login-information');
        editFields.forEach((element) => {
            element.disabled = status;
        });
        if (status == false) {
            $('.edit-button-login-information').hide();
            $('.div-button-login-information').show();
            $('#designation').focus();
        } else {
            $('.edit-button-login-information').show();
            $('.div-button-login-information').hide();
        }
    }
    //default
    editFieldLoginInformation(true);
    //edit button
    $(document).on('click', '.edit-button-login-information', function() {
        editFieldLoginInformation(false);
    });

    //data submit
    jQuery(function() {
        jQuery("form[name='login-information']").validate({
            rules: {
                designation: {
                    required: true,
                    maxlength: 101,
                    minlength: 2
                }
            },
            // Specify validation error messages
            messages: {
                designation: {
                    required: "Please enter designation",
                    maxlength: "Designation must be less then 100 characters long.",
                    minlength: "Designation must be greater then 2 characters long."
                }
            },
            submitHandler: function(form) {
                var formData = $("form[name='login-information']").serialize();
                $.ajax({
                    type: "POST",
                    url: "{{route('partner.profile.login-information.update')}}",
                    data: formData,
                    success: function(response) {
                        loginInformation = formData;
                        editFieldLoginInformation(true);
                        AlertMassage(response.message);
                        // $('#login-information-value').val(5);
                        ProgressGraphStatus();
                    },
                    error: function(xhr, status, error) {
                        AlertMassage(`{{ \App\Providers\MessageManagementProvider::MessageManage('customer-profile-something-wrong') }}`);
                    }
                });
            }
        });
    });
    //discard button
    $(document).on('click', '.discard-button-login-information', function() {
        var params = new URLSearchParams(loginInformation);

        // Set values for each form field using the extracted values
        setFieldValue("designation", params.get("designation"));
        editFieldLoginInformation(true);
    });
    
</script>
