@php

$footer_sign_up_for_free_trial = true;

@endphp

@extends('frontend.user.includes.master')

@section('body')

<section class="banner__section payment_gatway <?=(@$partner_page_data->title && @$partner_page_data->sub_title )?'':'one-line-text-box' ?>">

    <div id="baner_slider" class="carousel slide" data-bs-ride="carousel" data-interval="false">

        <div class="carousel-inner">

            <div class="carousel-item active">

                @if($partner_page_data->banner_image)

                    <img src="{{url($partner_page_data->banner_image)}}" class="w-100" alt="">

                @endif

                <div class="carousel-caption">

                    <div class="container">

                        <div class="inner__content_-wrap">

                            <h1><?=@$partner_page_data->title?></h1>

                            <div class="screen__heading">

                                <h2><?=@$partner_page_data->sub_title?></h2>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

</section>

<section class="become_partner_wrap">

    <div class="container">

        <div class="partner_contract_img">

            @if($partner_page_data->contract_page_image)

                <img src="{{url($partner_page_data->contract_page_image)}}" class="contract-page-image" alt="">

            @endif

        </div>




        

        <div class="bottom__strip partner_contract_wrap">

            <form action="{{route('become-a-partner.partner-contract-update')}}" name="patner_registration" id="patner_registration" enctype="multipart/form-data" method="POST" autocomplete="off">

                @csrf

                <div class="d-flex">

                    <div class="Draft_Aggrement">

                        @if ($partner_page_data->draft_agreement_text && $partner_page_data->draft_agreement)

                            <p><a href="{{url($partner_page_data->draft_agreement)}}" download="Draft Agreement"><?=@$partner_page_data->draft_agreement_text?></a></p>

                        @endif

                    </div>

                    <div class="form_group full_label half_grid">

                        <label>{{ HelperServiceProvider::GetLanguageText('upload_contract')}}<span style="color: red;">*</span></label>

                        <div class="form_feild">

                            <label class="filelabel">

                                <span class="title">Upload File</span>

                                <input class="FileUpload1" id="FileInput" name="partner_contract" type="file" />

                            </label>

                            <span class="error" style="display: none;">Please upload contract.</span>

                        </div>

                        <div class="upload_error_message">

                            @if($errormsg)

                                <p>{{$errormsg}}</p>

                            @endif

                        </div>

                    </div>

                </div>

                <div class="check_section">

                    <div class="check_confirm">

                        <input type="checkbox" name="company_registration_checkbox" id="check_terms">

                        <label class="check_terms" for="check_terms"><?=$partner_page_data->draft_agreement_checkbox_text?></label>

                    </div>

                </div>

                <div class="form_btn_grid">

                    <button type="submit" class="btn_cta">{{ HelperServiceProvider::GetLanguageText('finalised_agreement')}}</button>

                </div>

            </form>

        </div>

    </div>

</section>

@endsection

@section('script')

<script>

    jQuery(function () {

        // Add custom validation method for country field

        $.validator.addMethod("validFile", function (value) {

            var count = 0;

            $('.FileUpload1').each(function () {

                if ($(this).val() == '') {

                    $(this).parent().css({ 'border': ' 2px solid red' });

                    $(this).parent().parent().find('.error').show();

                    count++;

                }

            });

            return count == 0;

        }, '');

        $.validator.addMethod("validCheckbox", function (value) {

            if(value){

                $('#company_registration_checkbox-error1').hide();

            }else{

                $('#company_registration_checkbox-error1').show();

            }

            return value?true:false;

        });

        jQuery("form[name='patner_registration']").validate({

            rules: {

                company_registration_checkbox: {

                    validFile: true,

                    required: true

                }

            },

            messages: {

                company_registration_checkbox: {

                    required: "Please accept terms and conditions."

                }

            },

            submitHandler: function (form) {

                form.submit();

            }

        });

    });

</script>

<script>

    // document.getElementById('patner_registration').addEventListener('change', function (event) {

    $(document).ready(function () {

        var fileInputs = document.querySelectorAll('input[type="file"]');

        var allowedExtensions = ['png', 'jpg', 'pdf'];

        fileInputs.forEach(function (fileInput) {

            fileInput.addEventListener('change', function () {

                var fileName = this.value.split('\\').pop(); // Get the file name from the path

                // Check if the file extension is allowed

                var fileExtension = fileName.split('.').pop().toLowerCase();

                // if (allowedExtensions.indexOf(fileExtension) === -1) {

                //     // alert('Invalid file type. Allowed types are PNG, JPG, and PDF.');

                //     this.value = ''; // Clear the input field

                //     $(this).parent().find(".title").text('+Attach');

                //     // color

                //     $(this).parent().find("i").removeClass().addClass('fa fa-paperclip');

                //     $(this).parent().find("i, .title").css({

                //         'color': 'black'

                //     });

                //     $(this).parent().parent().find('.error').show();

                //     $(this).parent().css({

                //         'border': ' 2px solid red'

                //     });

                // } else {

                    var labelVal = $(this).parent().find(".title").text();

                    var oldfileName = $(this).val();

                    var extension = fileName.split('.').pop();

                    if (fileName) {

                        if (fileName.length > 10) {

                            $(this).parent().find(".title").text(fileName.slice(0, 4) + '...' + extension);

                        } else {

                            $(this).parent().find(".title").text(fileName);

                        }

                    } else {

                        $(this).parent().find(".title").text(labelVal);

                    }

                    // color

                    $(this).parent().find("i").removeClass().addClass('fa fa-file-image-o');

                    $(this).parent().find("i, .title").css({

                        'color': '#208440'

                    });

                    $(this).parent().css({

                        'border': ' 2px solid #208440'

                    });

                    $(this).parent().parent().find('.error').hide();

                // }

            });

        });

    });

</script>

@endsection

