@php
    $footer_sign_up_for_free_trial = true;
    $add_class_header = 'show-nav';
@endphp
@extends('frontend.user.includes.master')
@section('body')
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <section class="step_screen_wrap">
        <div class="container">
            <div class="step__title">
                <h1><?=@$partner_page_data->title?></h1>
            </div>
            <div class="form_border">
                <div class="left_grid">
                    <div class="number_list">
                        <ul>
                            <li class="active">1</li>
                            <li><a href="{{route('become-a-partner.basic-information')}}">2</a></li>
                            <li><a href="{{route('become-a-partner.company-information')}}">3</a></li>
                            <li><a href="{{route('become-a-partner.company-financial-information')}}">4</a></li>
                            <li><a href="{{route('become-a-partner.company-financial-information2')}}">5</a></li>
                            <li><a href="{{route('become-a-partner.company-documents-upload')}}">6</a></li>
                            {{-- <li><a href="{{route('become-a-partner.thank-you')}}">7</a></li> --}}
                            <li><a href="{{route('become-a-partner.profile-verification-summary')}}">7</a></li>
                            
                            <li><a href="{{route('become-a-partner.partner-contract')}}">8</a></li>
                            <li><a href="{{route('become-a-partner.contract-verification')}}">9</a></li>
                        </ul>
                    </div>
                    <div class="form_grid_inner">
                        <div class="left_title">
                            <h2>{{ HelperServiceProvider::GetLanguageText('login_information')}}</h2>
                        </div>
                        <form name="patner_registration" action="{{route('become-a-partner.login-information.store')}}"  method="POST" autocomplete="off">
                            @csrf
                            <div class="form_group">
                                <div class="form_feild">
                                    <input type="text" name="f_name" value="{{PartnerRegistrationProvider::PartnerRegistration('f_name')}}" id="f_name" placeholder="{{ HelperServiceProvider::GetLanguageText('first_name')}}*" maxlength="40">
                                    @error('f_name')
                                        <span class="text-danger error-f-name">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form_group">
                                <div class="form_feild">
                                    <input type="text" placeholder="{{ HelperServiceProvider::GetLanguageText('last_name')}}*" name="l_name" value="{{PartnerRegistrationProvider::PartnerRegistration('l_name')}}" id="l_name" maxlength="40">
                                    @error('l_name')
                                        <span class="text-danger error-l-name">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form_group">
                                <div class="form_feild">
                                    <input type="text" placeholder="{{ HelperServiceProvider::GetLanguageText('designation')}}*" id="designation" name="designation" value="{{PartnerRegistrationProvider::PartnerRegistration('designation')}}" maxlength="40">
                                    @error('designation')
                                        <span class="text-danger error-phone">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form_group">
                                <div class="form_feild">
                                    @php $calling_code =PartnerRegistrationProvider::PartnerRegistration('calling_code'); @endphp
                                    <input type="hidden" name="calling_code" class="calling_code" value="{{$calling_code}}" id="calling_code">
                                    <input type="text" placeholder="{{ HelperServiceProvider::GetLanguageText('contact_number')}}*" name="phone" id="phone" value="{{PartnerRegistrationProvider::PartnerRegistration('phone')}}" maxlength="15">
                                    @error('phone')
                                        <span class="text-danger error-phone">{{ $message }}</span>
                                    @enderror
                                    @error('calling_code')
                                        <span class="text-danger error-calling-code">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form_group large-validation">
                                <div class="form_feild">
                                    <input type="text" placeholder="{{ HelperServiceProvider::GetLanguageText('business_email')}}*" name="email" value="{{PartnerRegistrationProvider::PartnerRegistration('email')}}" id="email" maxlength="50">
                                    @error('email')
                                        <span class="text-danger error-email"><?= $message ?></span>
                                    @enderror
                                    @if (Session::has('message'))
                                        <span class="text-danger error-email">{{ Session::get('message') }}</span>
                                    @endif
                                    <span class="text-danger error-email"></span>
                                </div>
                            </div>
                            <div class="form_group">
                                <div class="form_feild">
                                    <input type="password" placeholder="{{ HelperServiceProvider::GetLanguageText('password')}}*" name="password" id="password" maxlength="12">
                                    <span class="password-toggle" onclick="togglePasswordVisibility()">
                                        <i id="eyeIcon" class="fa fa-eye"></i>
                                    </span>
                                    @error('password')
                                        <span class="text-danger error-password">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form_group">
                                <div class="form_feild">
                                    <input type="password" placeholder="{{ HelperServiceProvider::GetLanguageText('confirm_password')}}*" name="password_confirmation" id="password_confirmation" onpaste="return false;" maxlength="12">
                                    <span class="password-toggle" onclick="togglePasswordVisibility1()">
                                        <i id="eyeIcon1" class="fa fa-eye"></i>
                                    </span>
                                    @error('password_confirmation')
                                        <span class="text-danger error-password-confirmation">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form_group capta_img">
                                <div class="form_feild">
                                    <div class="g-recaptcha" data-sitekey="{{env('RECAPTCHA',"6Lcl8AkrAAAAABcKDjYHIZheJ8gwyUVFdPeDEDnr")}}"></div>
                                    <div class="text-danger recaptcha-show-error">please click on the recaptcha box.</div>
                                </div>
                            </div>
                            <div class="form_btn_grid">
                                <button type="submit" class="btn_cta">{{ HelperServiceProvider::GetLanguageText('signup')}}</button>
                                <button type="reset" class="btn_cta">{{ HelperServiceProvider::GetLanguageText('clear_all')}}</button>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="right_grid">
                    <div class="right_gray_bg">
                        <div class="pointer_content listing__content1">
                            <h3><?=@$partner_page_data->how_to_join_as_a_partner_text?></h3>
                            <div class="">
                                <?=@$partner_page_data->how_to_join_as_a_partner_description?>
                            </div>
                        </div>
                    </div>
                    <p>{{ HelperServiceProvider::GetLanguageText('already_a_partner?')}} <a href="{{route('login')}}">{{ HelperServiceProvider::GetLanguageText('sign_in')}} </a></p>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('script')
{{-- ------------------recaptcha---- --}}
<script>
    $('.recaptcha-show-error').hide();
    window.onload = function() {
        var recaptcha = document.querySelector('#g-recaptcha-response');
        if(recaptcha) {
            $('#g-recaptcha-response').attr("required", "required");
        }
    }
    $("document").ready(function () {
        // -----Country Code Selection
        $("#phone").intlTelInput({
            initialCountry: "<?=($calling_code)?$calling_code:'auto'?>",
            separateDialCode: true,
            placeholder: "Enter your phone number"
        });
    });
</script>
{{-- -------------validation------------------- --}}
<script>
    jQuery(function() {
        // Add custom email check validation method
        $.validator.addMethod("checkEmailExists", function(value, element) {
            var emailExists = false;
            // Make an AJAX request to check if the email exists in the database
            $.ajax({
            url: "{{route('check-customer-email')}}",
            type: "POST",
            data: { _token : "<?php echo csrf_token() ?>", email: value },
            async: false, // Make the request synchronous
            success: function(response) {
                emailExists = response;
            }
            });
            return !emailExists; // Return true if the email doesn't exist, false otherwise
        }, "User already exits, you can use <a href='{{route('forget.password.get')}}'>forget password</a> function or register with a different email address");
        // Add custom password validation method
        jQuery.validator.addMethod("password", function(value, element) {
            let password = value;
            if (!(/^(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])(?=.*[@#$%&])(.{8,14}$)/.test(password))) {
            return false;
            }
            return true;
        }, function(value, element) {
            let password = $(element).val();
            if (!(/^(.{8,14}$)/.test(password))) {
            return 'Password must be between 8 to 14 characters long.';
            } else if (!(/^(?=.*[A-Z])/.test(password))) {
            return 'Password must contain at least one uppercase letter.';
            } else if (!(/^(?=.*[a-z])/.test(password))) {
            return 'Password must contain at least one lowercase letter.';
            } else if (!(/^(?=.*[0-9])/.test(password))) {
            return 'Password must contain at least one digit.';
            } else if (!(/^(?=.*[@#$%&])/.test(password))) {
            return 'Password must contain at least one special character from @#$%&.';
            }
            return false;
        });
        // Custom validation method for checking email format
        $.validator.addMethod("customEmail", function(value, element) {
            return this.optional(element) || /^[a-zA-Z0-9_.-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/i.test(value);
        }, "Please enter a valid email address.");
        $.validator.addMethod("CallingCode", function(value, element) {
            return ($('#calling_code').val())?true:false;
        }, "Please select Calling code.");
      jQuery("form[name='patner_registration']").validate({
        rules: {
            f_name:{
                required: true,
                maxlength:41,
                minlength:2
            },
            l_name:{
                required: true,
                maxlength:41,
                minlength:2
            },
            designation: {
                required: true,
                maxlength:41,
                minlength:2
            },
            email: {
                required: true,
                email: true,
                customEmail: true,
                checkEmailExists: true // Add the custom validation rule
            },
            password: {
                required: true,
                minlength: 8,
                maxlength:13,
                password: true // Use the custom password validation method
            },
            password_confirmation: {
                required: true,
                minlength: 8,
                maxlength:13,
                equalTo: "#password"
            },
            phone:{
                CallingCode:true,
                required:true,
                digits:true
            }
        },
        // Specify validation error messages
        messages: {
          f_name:{
            required: "Please enter first name",
            maxlength: "First name must be less then 40 characters long.",
            minlength: "First name must be greater then 2 characters long."
          },
          l_name:{
            required: "Please enter last name",
            maxlength: "Last name must be less then 40 characters long.",
            minlength: "Last name must be greater then 2 characters long."
          },
          designation:{
            required: "Please enter designation",
            maxlength: "Company name must be less then 40 characters long.",
            minlength: "Company name must be greater then 2 characters long."
          },
          calling_code:{
            required:"Please enter International Calling code."
          },
          password: {
            required: "Please provide a password",
            minlength: "Password must be between 8 to 12 characters long.",
            maxlength: "Password must be between 8 to 12 characters long."
          },
          password_confirmation: {
            required: "Please provide a password",
            minlength: "Password must be between 8 to 12 characters long.",
            equalTo: "Password does not match.",
            maxlength: "Password must be between 8 to 12 characters long."
          },
          phone: {
            required: "Please enter phone number.",
            minlength: "Your phone number must be at least 10 digits long",
            maxlength: "Your phone number must be less or equal 15 digits long"
          },
          email: {
            required: "Please enter email address.",
            email: "Please enter a valid business email address"
          }
        },
         submitHandler: function(form) {
            if(grecaptcha.getResponse()){
                form.submit();
            }else{
                $('.recaptcha-show-error').show();
                $('.recaptcha-show-error').delay(5000).hide(0);
            }
        }
      });
    });
</script>
<script>
    //email
    jQuery(document).on('keypress', '#email', function(event) {
        jQuery('.error-email').hide();
        var regex = new RegExp("^[a-zA-Z.0-9.@]+$");
        var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        $('.text-danger').hide();
        if (!regex.test(key) && event.which !== 13) {
            event.preventDefault();
            return false;
        }
    });
    //Dealer Name
    jQuery(document).on('keypress', '#f_name', function(event) {
        jQuery('.error-f-name').hide();
        $(this).css({'text-transform': 'capitalize'});
        var regex = new RegExp("^[a-zA-Z ]+$");
        var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        if (!regex.test(key) && event.which !== 13) {
            event.preventDefault();
            return false;
        }
        var phone_no=$('#f_name').val();
        if(phone_no.length>=40){
            return false;
        }
    });
    //Dealer Name
    jQuery(document).on('keypress', '#l_name', function(event) {
        jQuery('.error-l-name').hide();
        $(this).css({'text-transform': 'capitalize'});
        var regex = new RegExp("^[a-zA-Z ]+$");
        var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        if (!regex.test(key) && event.which !== 13) {
            event.preventDefault();
            return false;
        }
        var phone_no=$('#l_name').val();
        if(phone_no.length>=40){
            return false;
        }
    });
    jQuery(document).on('keypress', '#password', function(event) {
        jQuery('.error-password').hide();
        jQuery('.error-password-confirmation').hide();
        var phone_no=$('#password').val();
        if(phone_no.length>14){
            return false;
        }
    });
    jQuery(document).on('keypress', '#password_confirmation', function(event) {
        jQuery('.error-password').hide();
        jQuery('.error-password-confirmation').hide();
        var phone_no=$('#password_confirmation').val();
        if(phone_no.length>14){
            return false;
        }
    });
    // change calling code
    // $('body').on('click keydown keypress touchstart touchend', '.iti__country.iti__standard', function() {
    //     var flagElement = $(this).find('.iti__flag').attr('class');
    //     var newText = flagElement.replace("iti__flag iti__", "");
    //     $(this).closest('.form_feild').find('.calling_code').val(newText);
    // });
    
    $('body').on('click keydown keypress touchstart pointerdown', '.iti__country.iti__standard', function() {
        var flagElement = $(this).find('.iti__flag').attr('class');
        var newText = flagElement.replace("iti__flag iti__", "");
        $('.calling_code').val(newText);
    });

</script>
{{-- pasword icon --}}
<script>
    function togglePasswordVisibility() {
        const passwordField = document.getElementById("password");
        const eyeIcon = document.getElementById("eyeIcon");
        if (passwordField.type === "password") {
        passwordField.type = "text";
        eyeIcon.classList.remove("fa-eye");
        eyeIcon.classList.add("fa-eye-slash");
        } else {
        passwordField.type = "password";
        eyeIcon.classList.remove("fa-eye-slash");
        eyeIcon.classList.add("fa-eye");
        }
    }
    function togglePasswordVisibility1() {
        const passwordField = document.getElementById("password_confirmation");
        const eyeIcon = document.getElementById("eyeIcon1");
        if (passwordField.type === "password") {
            passwordField.type = "text";
            eyeIcon.classList.remove("fa-eye");
            eyeIcon.classList.add("fa-eye-slash");
        } else {
            passwordField.type = "password";
            eyeIcon.classList.remove("fa-eye-slash");
            eyeIcon.classList.add("fa-eye");
        }
    }
</script>
<script>
    window.addEventListener('load', function() {
        @if (session('status'))
            AlertMassage(`<?= session('status') ?>`);
        @endif
        @if (Session::has('message'))
            AlertMassage(`<?= Session::get('message') ?>`);
        @endif
        $('.iti__selected-flag .iti__flag').addClass('dummy-flag-icon');
    });

</script>
@endsection
