@php
    $footer_sign_up_for_free_trial = true;
    $add_class_header = 'show-nav';
@endphp
@extends('frontend.user.includes.master')
@section('body')
    <section class="step_screen_wrap">
        <div class="container">
            <div class="step__title">
                <h1><?=@$partner_page_data->title?></h1>
            </div>
            <div class="form_border basic_information_form">
                <div class="left_grid">
                    <div class="number_list">
                        <ul>
                            <li><a href="{{route('become-a-partner.login-information')}}">1</a></li>
                            <li class="active">2</li>
                            <li><a href="{{route('become-a-partner.company-information')}}">3</a></li>
                            <li><a href="{{route('become-a-partner.company-financial-information')}}">4</a></li>
                            <li><a href="{{route('become-a-partner.company-financial-information2')}}">5</a></li>
                            <li><a href="{{route('become-a-partner.company-documents-upload')}}">6</a></li>
                            <!-- <li><a href="{{route('become-a-partner.thank-you')}}">7</a></li> -->
                            <li><a href="{{route('become-a-partner.profile-verification-summary')}}">7</a></li>
                            
                            <li><a href="{{route('become-a-partner.partner-contract')}}">8</a></li>
                            <li><a href="{{route('become-a-partner.contract-verification')}}">9</a></li>
                        </ul>
                    </div>
                    <div class="form_grid_inner">
                        <div class="left_title">
                            <h2>{{ HelperServiceProvider::GetLanguageText('basic_information')}}</h2>
                        </div>
                        <form name="patner_registration" action="{{route('become-a-partner.basic-information.store')}}"  method="POST" autocomplete="off">
                            @csrf
                            <div class="form_group">
                                <label for="">{{ HelperServiceProvider::GetLanguageText('how_did_you_hear_about_our_program?')}}<span style="color: red;">*</span> </label>
                                <div class="form_feild">
                                    @php $how_did_you_hear_about_our_program=PartnerRegistrationProvider::PartnerRegistration('how_did_you_hear_about_our_program') @endphp
                                    <select name="how_did_you_hear_about_our_program" id="how_did_you_hear_about_our_program">
                                        <option value="">Select</option>
                                        <option value="Website" @if($how_did_you_hear_about_our_program=='Website') selected @endif >Website</option>
                                        <option value="Google" @if($how_did_you_hear_about_our_program=='Google') selected @endif >Google</option>
                                        <option value="Social Media" @if($how_did_you_hear_about_our_program=='Social Media') selected @endif >Social Media</option>
                                        <option value="Email Newslatter" @if($how_did_you_hear_about_our_program=='Email Newslatter') selected @endif >Email Newslatter</option>
                                        <option value="Employess" @if($how_did_you_hear_about_our_program=='Employess') selected @endif >Employess</option>
                                        <option value="Existing Partners" @if($how_did_you_hear_about_our_program=='Existing Partners') selected @endif >Existing Partners</option>
                                        <option value="Event and Promotions" @if($how_did_you_hear_about_our_program=='Event and Promotions') selected @endif >Event and Promotions</option>
                                        <option value="Others" @if($how_did_you_hear_about_our_program=='Others') selected @endif >Others</option>
                                    </select>
                                    @error('how_did_you_hear_about_our_program')
                                        <span class="text-danger error-how_did_you_hear_about_our_program">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form_group">
                                <label for="">{{ HelperServiceProvider::GetLanguageText('in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner?')}}<span style="color: red;">*</span></label>
                                <div class="form_feild">
                                    @php $in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner=PartnerRegistrationProvider::PartnerRegistration('in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner') @endphp
                                    <select name="in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner" id="in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner">
                                        <option value="">Select</option>
                                        <option value="APAC(Asia Pacific)" @if($in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner=='APAC(Asia Pacific)') selected @endif >APAC(Asia Pacific)</option>
                                        <option value="Europe" @if($in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner=='Europe') selected @endif >Europe</option>
                                        <option value="Middle East" @if($in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner=='Middle East') selected @endif >Middle East</option>
                                        <option value="Africa" @if($in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner=='Africa') selected @endif >Africa</option>
                                        <option value="India" @if($in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner=='India') selected @endif >India</option>
                                        <option value="North America" @if($in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner=='North America') selected @endif >North America</option>
                                        <option value="South America" @if($in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner=='South America') selected @endif >South America</option>
                                        <option value="Australasia" @if($in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner=='Australasia') selected @endif >Australasia</option>
                                    </select>
                                    @error('in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner')
                                        <span class="text-danger error-in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form_group radio_input_grid">
                                <label for="">{{ HelperServiceProvider::GetLanguageText('individual_business')}}<span style="color: red;">*</span> </label>
                                @php $individual_business=PartnerRegistrationProvider::PartnerRegistration('individual_business') @endphp
                                <div class="form_feild ">
                                    <div class="radio_button">
                                        <input type="radio" id="Individual" name="individual_business" @if($individual_business=='Individual') checked @endif value="Individual">
                                        <label for="Individual">{{ HelperServiceProvider::GetLanguageText('individual')}}</label>
                                    </div>
                                    <div class="radio_button">
                                        <input type="radio" id="Business" name="individual_business" @if($individual_business=='Business') checked @endif value="Business">
                                        <label for="Business">{{ HelperServiceProvider::GetLanguageText('business')}}</label>
                                    </div>
                                    @error('individual_business')
                                        <span class="text-danger error-individual_business">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form_btn_grid">
                                <button type="submit" class="btn_cta">{{ HelperServiceProvider::GetLanguageText('save_and_next')}}</button>
                                <button type="reset" class="btn_cta">{{ HelperServiceProvider::GetLanguageText('clear_all')}}</button>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="right_grid">
                    <div class="right_gray_bg basice_information">
                        <div class="right__side_img">
                            <img src="{{url($partner_page_data->page_2_image)}}" alt="Basic Information">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('script')
{{-- -------------validation------------------- --}}
<script>
    jQuery(function() {
      jQuery("form[name='patner_registration']").validate({
        rules: {
            how_did_you_hear_about_our_program:'required',
            in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner:'required',
            individual_business:'required'
        },
        // Specify validation error messages
        messages: {
            how_did_you_hear_about_our_program:"Please select How did you hear about our program.",
            in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner:"Please select In what region do you want to represent Aurobees as a channel partner.",
            individual_business:"Please check Individual / Business"
        },
        submitHandler: function(form) {
            form.submit();
        }
      });
    });
</script>
@endsection
