@php
$meta_title = 'Aurobees | Dashboard';
$meta_description = '';
$meta_keywords = '';
$add_class_header='show-nav';
$footer_sign_up_for_free_trial=true;
$active_page='dashboard';
@endphp
@extends('frontend.user.includes.master')
@section('body')
<div class="dashboard_bg">
    <section class="usr_dashboard_user">
        <div class="container">
            <div class="row">
                <div class="col-md-3"></div>
                <div class="col-md-9">
                    <div class="usr_dashboard_title">
                        <h1>Dashboard</h1>
                        <div class="d-flex">
                            <div class="log_out_btn">
                                <a href="javascript:void(0);" onclick="$('#logout-form').submit();">Log Out</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-3">
                    @include('frontend.customer.includes.body.sidebar')
                </div>
                <div class="col-md-9">
                    <div class="scroll_screen">
                        <div class="dashboard_right n-dash-right">
                            <div class="Subscribed_box">
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="Subscribed_box_inner">
                                            <h4>Subscribed LOB’S</h4>
                                            <div class="box_middle0">
                                                <p><a
                                                        href="{{route('customer.subscription.list')}}">{{$total_no_of_lob}}</a>
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="Subscribed_box_inner">
                                            <h4>Active Users</h4>
                                            <div class="box_middle0">
                                                <p>{{$active_no_of_user}}</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="Subscribed_box_inner">
                                            <h4>Next Billing Cycle</h4>
                                            <div class="box_middle0">
                                                @if(@$invoiceDate)
                                                    <p style="font-size: 13px;">
                                                        Next Billing date: <?=date('d-m-Y', strtotime($invoiceDate))?>
                                                    </p> 
                                                @endif
                                                @if(@$estimatedAmount) <p style="font-size: 13px;">Estimated amount: {{@$estimatedAmount}}</p>
                                                @endif
                                                <p><a href="{{route('customer.billing.list')}}">View Billing</a></p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="Subscribed_box_inner">
                                            <h4>Documents</h4>
                                            <div class="box_middle0">
                                                <p><a href="{{route('customer.profile.show')}}">View</a></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @if($overviewActiveUser)
                                <div class="active_user">
                                    <div class="d-flex aline_content">
                                        <p class="title_user"><strong>LOB Monthly Trend of Active Users</strong>
                                        </p>
                                        @if($overviewActiveUser)
                                        <div class="graph_dropdown">
                                            <select id="" onchange="changeOverview(this.value);">
                                                @foreach ($overviewActiveUser as $overview)
                                                <option value="{{$overview['id']}}">{{$overview['name']}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        @endif
                                    </div>
                                
                                    <div class="active_user_graph">
                                        <div id="bar-chart" style="height: 300px;"></div>
                                    </div>
                                </div>
                            @endif
                            {{-- subscription --}}
                            @if(!$subscription_list->isEmpty())
                            <div class="user_table">
                                <p class="title_user"><strong>Subscription Details</strong></p>
                                <div class="table-responsive">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>Sr. No.</th>
                                                <th>Subscribed LOB</th>
                                                <th>Subscription Type</th>
                                                <th>Subscription Plan</th>
                                                <th>Status</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($subscription_list as $key=> $item)
                                            <tr>
                                                <td>{{$key+1}}</td>
                                                <td>
                                                    <?=@$item['Pricing']['LOB']['title'] ?>
                                                </td>
                                                <td><?=@$item->plan_name ?></td>
                                                <td>@if($item->plan_duration=='YLY') 365
                                                    @elseif($item->plan_duration=='QTR') 90
                                                    @elseif($item->plan_duration=='MTH') 30 @else 15 @endif Days</td>
                                                <td><?=@$item->status ?></td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
            @include('frontend.customer.includes.body.help-center-mobile')
        </div>
    </section>
</div>
@endsection
@section('script')
<script src="https://cdnjs.cloudflare.com/ajax/libs/flot/0.8.3/jquery.flot.min.js"></script>
<script>
    var overviewActiveUser =<?= json_encode($overviewActiveUser);?>;
    function changeOverview(value) {
        $('#bar-chart').css('width', '600px');
        $('#bar-chart').html();
        // Get the data for the selected plan
        let listData = overviewActiveUser[value - 1];
        // Prepare the data for the bar chart
        var bar_data = {
            data: listData.list.map(data => [data.id, data.user]),
            bars: { show: true }
        };
        var maxuser = 0;
        listData.list.map(data => {
            if (parseInt(data.user) > maxuser) {
                maxuser = data.user;
            }
        });
        if (maxuser <= 6) {
            $.plot('#bar-chart', [bar_data], {
                grid: {
                    borderWidth: 1,
                    borderColor: '#f3f3f3',
                    tickColor: '#f3f3f3'
                },
                series: {
                    bars: {
                        show: true, barWidth: 0.5, align: 'center',
                    },
                },
                colors: ['#3c8dbc'],
                xaxis: {
                    ticks: listData.list.map(data => [data.id, data.month])
                },
                yaxis: {
                    ticks: [1, 2, 3, 4, 5, 6],
                    tickFormatter: function (val, axis) {
                        // Use Math.round to display integer values without decimal points
                        return Math.round(val);
                    }
                }
            });
        } else if (maxuser <= 12) {
            $.plot('#bar-chart', [bar_data], {
                grid: {
                    borderWidth: 1,
                    borderColor: '#f3f3f3',
                    tickColor: '#f3f3f3'
                },
                series: {
                    bars: {
                        show: true, barWidth: 0.5, align: 'center',
                    },
                },
                colors: ['#3c8dbc'],
                xaxis: {
                    ticks: listData.list.map(data => [data.id, data.month])
                },
                yaxis: {
                    ticks: [2, 4, 6, 8, 10, 12],
                    tickFormatter: function (val, axis) {
                        // Use Math.round to display integer values without decimal points
                        return Math.round(val);
                    }
                }
            });
        } else {
            $.plot('#bar-chart', [bar_data], {
                grid: {
                    borderWidth: 1,
                    borderColor: '#f3f3f3',
                    tickColor: '#f3f3f3'
                },
                series: {
                    bars: {
                        show: true, barWidth: 0.5, align: 'center',
                    },
                },
                colors: ['#3c8dbc'],
                xaxis: {
                    ticks: listData.list.map(data => [data.id, data.month])
                },
                yaxis: {
                    tickFormatter: function (val, axis) {
                        // Use Math.round to display integer values without decimal points
                        return Math.round(val);
                    }
                }
            });
        }
    }
    // Call the onchange function with the default value (1)
    changeOverview(1);
</script>
@endsection