@php
$meta_keywords = 'Aurobees | Forget Password';
$meta_description = 'Aurobees | Forget Password';
$meta_keywords = 'Aurobees | Forget Password';
@endphp
@extends('frontend.new_user.includes.master')
@section('body')
    <style>
        .form_wrap {
            max-width: 1500px;
            padding: 60px 0px;
        }
        @media only screen and (max-width: 1600px) {
          .form_wrap {
            padding: 30px 0px;
          }
    </style>
    <section class="form_wrap">

        <div class="row g-0">
            <div class="col-md-7">
                <div class="screen_video">
                    <div class="video_grid">
                        @php $forgot_password_thumbnail_image = HelperServiceProvider::ForgotPasswordPageManagement('forgot_password_thumbnail_image'); @endphp
                        @php $forgot_password_video = HelperServiceProvider::ForgotPasswordPageManagement('forgot_password_video'); @endphp
                        
                        @if($forgot_password_thumbnail_image && $forgot_password_video)
                          <video id="myVideo" poster="{{url($forgot_password_thumbnail_image)}}">
                              <source src="{{url($forgot_password_video)}}" type="video/mp4">
                          </video>
                          <div class="content">
                              <button id="myBtn" onclick="myFunction()"><i class="fas fa-play"></i></button>
                          </div>
                        @endif
                    </div>
                </div>
            </div>
            <div class="col-md-5 otp_screen">
                <div class="login_grid forgot_password">
                    <div class="form_title">
                        <h1>{{ HelperServiceProvider::GetLanguageText('forgot_password')}}</h1>
                    </div>

                    <div class="form_tabs ">
                        <ul class="nav nav-pills" role="tablist">
                            <li>
                                <button class="nav-link active" data-bs-toggle="pill" data-bs-target="#User"
                                    type="button" role="tab">{{ HelperServiceProvider::GetLanguageText('user')}}</button>
                            </li>
                            <li>
                                <button class="nav-link" data-bs-toggle="pill" data-bs-target="#Partner"
                                    type="button" role="tab">{{ HelperServiceProvider::GetLanguageText('partner')}}</button>
                            </li>
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane fade show active" role="tabpanel">
                                <form name="customer_registration" id="customer_registration" method="POST" autocomplete="off" action="{{route('forget.password.post')}}">
                                    @csrf
                                    <input type="hidden" name="forget_password" value="forget_password">
                                    <div class="form_feild">
                                        <input type="email" name="email" id="email" value="{{old('email')}}" placeholder="{{ HelperServiceProvider::GetLanguageText('registered_email_id')}}">
                                        @error('email')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                        <p>{{ HelperServiceProvider::GetLanguageText('please_enter_your_registered_email_address')}}</p>

                                    </div>
                                    <div class="form_feild">
                                        <button type="submit" style="width: 100%;" class="create_pass">{{ HelperServiceProvider::GetLanguageText('create_new_password')}}</button>
                                    </div>
                                </form>

                                <div class="account_found">
                                    <p>{{ HelperServiceProvider::GetLanguageText('account_not_found?')}}</p>
                                </div>
                                <div class="registered_grid">
                                    <a class="register_as" href="{{route('customer.create')}}" >{{ HelperServiceProvider::GetLanguageText('register_as_user')}}</a>
                                    <a class="register_as" href="{{route('become-a-partner.index')}}">{{ HelperServiceProvider::GetLanguageText('register_as_partner')}}</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('script')
<script>
    window.addEventListener('load', function() {
        @if (session('status'))
            AlertMassage(`<?= session('status') ?>`);
        @endif
        @if (Session::has('message'))
            AlertMassage(`<?= Session::get('message') ?>`);
        @endif
    });
</script>
<script>
    jQuery(function() {
        // Custom validation method for checking email format
        $.validator.addMethod("customEmail", function(value, element) {
            return this.optional(element) || /^[a-zA-Z0-9_.-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/i.test(value);
        }, "Please enter a valid email address.");

      jQuery("form[name='customer_registration']").validate({
        rules: {
            email: {
            required: true,
            email: true,
            customEmail: true
          }
        },
        // Specify validation error messages
        messages: {
            email: "Please enter a valid email address"
        },
        submitHandler: function(form) {
            $('#modal-loader').modal('show');
            form.submit();
        }
      });
    });

    //email
    jQuery(document).on('keypress', '#email', function(event) {
        $(".text-danger").hide();
        var regex = new RegExp("^[a-zA-Z.0-9.@]+$");
        var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        if (!regex.test(key)) {
            event.preventDefault();
            return false;
        }
    });
    </script>
@endsection

