@php
$meta_keywords = 'Aurobees | Forget Password';
$meta_description = 'Aurobees | Forget Password';
$meta_keywords = 'Aurobees | Forget Password';
@endphp
@extends('frontend.new_user.includes.master')
@section('body')
    <style>
        .form_wrap {
            max-width: 1500px;
            padding: 60px 0px;
        }
        @media only screen and (max-width: 1600px) {
          .form_wrap {
            padding: 30px 0px;
        }
    </style>
    <section class="form_wrap">
        <div class="row g-0">
            <div class="col-md-7">
                <div class="screen_video">
                    <div class="video_grid">
                        @php $otp_thumbnail_image = HelperServiceProvider::ForgotPasswordPageManagement('otp_thumbnail_image'); @endphp
                        @php $otp_video = HelperServiceProvider::ForgotPasswordPageManagement('otp_video'); @endphp
                        @if($otp_thumbnail_image && $otp_video)
                          <video id="myVideo" poster="{{url($otp_thumbnail_image)}}">
                              <source src="{{url($otp_video)}}" type="video/mp4">
                          </video>
                          <div class="content">
                              <button id="myBtn" onclick="myFunction()"><i class="fas fa-play"></i></button>
                          </div>
                        @endif
                    </div>
                </div>
            </div>
            <div class="col-md-5 otp_screen">
                <div class="login_grid forgot_password">
                    <div class="form_title">
                        <h1>{{ HelperServiceProvider::GetLanguageText('validate_email')}}</h1>
                    </div>
                    <div class="form_tabs ">
                        <div class="tab-content">
                            <div class="tab-pane fade show active" role="tabpanel">
                                <form name="customer_registration" id="customer_registration"  method="POST" autocomplete="off" action="{{route('resend.otp.email')}}">
                                    @csrf
                                    <input type="hidden" name="forget_password" value="forget_password">
                                    <div class="form_feild">
                                        <input type="email" name="email" id="email" placeholder="{{ HelperServiceProvider::GetLanguageText('registered_email_id')}}">
                                        @error('email')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                        <span class="text-danger">Please enter a valid email address</span>
                                        <p>{{ HelperServiceProvider::GetLanguageText('please_enter_your_registered_email_address')}}</p>
                                    </div>
                                    <div class="form_feild">
                                        <button type="button" onclick="CheckEmail();" style="width: 100%;" class="create_pass">{{ HelperServiceProvider::GetLanguageText('validate')}}</button>
                                    </div>
                                </form>
                                <div class="account_found">
                                    <p>{{ HelperServiceProvider::GetLanguageText('account_not_found?')}}</p>
                                </div>
                                <div class="registered_grid">
                                    <a class="register_as" href="{{route('customer.create')}}" >{{ HelperServiceProvider::GetLanguageText('register_as_user')}}</a>
                                    <a class="register_as" href="{{route('become-a-partner.index')}}">{{ HelperServiceProvider::GetLanguageText('register_as_partner')}}</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('script')
<script>
    $('.text-danger').hide();
    window.addEventListener('load', function() {
        @if (Session::has('message'))
            AlertMassage(`<?= Session::get('message') ?>`);
        @endif
        @if (Session::has('message1'))
            AlertMassage(`<?= Session::get('message1') ?>`);
        @endif
        @if (@$successmessage)
            AlertMassage(`<?= @$successmessage ?>`);
        @endif
        @if (@$message)
            AlertMassage(`<?= @$message ?>`);
        @endif
    });
</script>
<script>
    //email
    jQuery(document).on('keypress', '#email', function(event) {
        $('.text-danger').hide();
        var regex = new RegExp("^[a-zA-Z.0-9.@]+$");
        var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        if (!regex.test(key)) {
            event.preventDefault();
            return false;
        }
    });
    function isValidEmail(email) {
        // Regular expression for email validation
        var emailRegex = /^[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\.[A-Za-z]{2,}$/;
        return emailRegex.test(email);
    }
    function CheckEmail(){
        if(isValidEmail($('#email').val())){
            $.ajax({
                type: 'post',
                url: "{{route('resend.otp.email.check.ajax')}}",
                data:{
                    email:$('#email').val(),
                    _token:$("[name='_token']").val()
                },
                success: function (data) {
                    AlertMassage(data['otp']);
                    if(data['login']==true){
                        $('#modal-loader').modal('show');
                        setTimeout( function(){
                            $('#customer_registration').submit();
                            return true;
                        } , 10000);
                    }else{
                        return false;
                    }
                }
            });
        }else{
            $('.text-danger').show();
        }
    }
</script>
@endsection
