@php
$meta_title = 'Checkout - Aurobees';
$meta_description = 'Streamline your shopping experience with our efficient and secure checkout page. Complete your purchase effortlessly, with a wide range of payment options and hassle-free order confirmation. Shop confidently and enjoy a seamless checkout process with our user-friendly interface. Start your stress-free checkout now!';
$meta_keywords = 'Checkout, Aurobees, Payment, Secure Payment';
$add_class_header='show-nav';
@endphp
@extends('frontend.user.includes.master')
@section('body')
<style>
    .error {
        border-block-color: red;
    }
    .container {
        /*max-width: 1680px;*/
    }
</style>
<section class="checkout_wrap">
    <div class="container">
        <div class="checkout_title">
            <h1>{{ HelperServiceProvider::GetLanguageText('checkout')}}</h1>
            @if($errors->any())
            {!! implode('', $errors->all('<div>:message</div>')) !!}
            @endif
        </div>
        <form name="customer_checkout" id="customer_checkout" method="POST" autocomplete="off" enctype="multipart/form-data" action="{{route('checkout.store')}}">
            @csrf
            <div class="row">
                <div class="col-md-7">
                    <div class="express__checkout">
                        <div class="payment_mothod">
                            <h2>{{ HelperServiceProvider::GetLanguageText('fill_in_the_form_below_for_gst_invoice')}}</h2>
                        </div>
                    </div>
                    <div class="accordion_wrap">
                        <div class="accordion" id="checkout_accordion">
                            <div class="accordion-item">
                                <button class="general_info" type="button" data-bs-toggle="collapse" data-bs-target="#general_info">
                                    {{ HelperServiceProvider::GetLanguageText('general_information')}}
                                </button>
                                <div id="general_info" class="accordion-collapse collapse show" data-bs-parent="#checkout_accordion">
                                    <div class="accordion-body">
                                        <div class="form_group">
                                            <label>{{ HelperServiceProvider::GetLanguageText('registered_company_name')}}<span style="color: red;">*</span></label>
                                            <div class="form_feild">
                                                <input type="text" name="company_name" readonly value="{{HelperServiceProvider::CheckoutPage('company_name')}}" placeholder="" id="company_name">
                                                @error('company_name')
                                                <span class="text-danger error-company_name">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form_group">
                                            <label>{{ HelperServiceProvider::GetLanguageText('company_code')}}</label>
                                            <div class="form_feild">
                                                <input type="text" name="company_code" readonly value="{{HelperServiceProvider::CheckoutPage('code')}}" placeholder="">
                                                @error('company_code')
                                                <span class="text-danger error-company_code">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form_group">
                                            <label>{{ HelperServiceProvider::GetLanguageText('country')}}<span style="color: red;">*</span></label>
                                            <div class="form_feild">
                                                @php $country=HelperServiceProvider::CheckoutPage('country'); @endphp
                                                <select class="country-select CheckoutCounteryList" name="country" id="country"></select>
                                                <label id="country-error-div" style="display: none;" class="error" for="country">Please select country name</label>
                                                @error('country')
                                                <span class="text-danger error-country">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form_group state_div">
                                            <label>{{ HelperServiceProvider::GetLanguageText('state')}}<span style="color: red;">*</span></label>
                                            <div class="form_feild">
                                                @php $oldstate=HelperServiceProvider::CheckoutPage('state'); @endphp
                                                <select name="state" class="form-control select_list" id="state">
                                                    @foreach ($state_list as $state)
                                                    <option value="{{$state->name}}" @if($state->code==$oldstate) selected @endif>{{$state->name}}</option>
                                                    @endforeach
                                                </select>
                                                @error('state')
                                                    <span class="text-danger error-state">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form_group">
                                            <label>{{ HelperServiceProvider::GetLanguageText('city')}}<span style="color: red;">*</span></label>
                                            <div class="form_feild">
                                                <input type="text" name="city" id="city" value="{{HelperServiceProvider::CheckoutPage('city')}}" maxlength="50" placeholder="">
                                                @error('city')
                                                <span class="text-danger error-city">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form_group">
                                            <label>{{ HelperServiceProvider::GetLanguageText('address_line_1')}}<span style="color: red;">*</span></label>
                                            <div class="form_feild">
                                                <input type="text" name="address_1" id="address_1" value="{{HelperServiceProvider::CheckoutPage('address_1')}}" maxlength="100" placeholder="">
                                                @error('address_1')
                                                <span class="text-danger error-address_1">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form_group">
                                            <label>{{ HelperServiceProvider::GetLanguageText('address_line_2')}}</label>
                                            <div class="form_feild">
                                                <input type="text" name="address_2" id="address_2" value="{{HelperServiceProvider::CheckoutPage('address_2')}}" maxlength="100" placeholder="">
                                                @error('address_2')
                                                <span class="text-danger error-address_2">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form_group pincode-div">
                                            <label>{{ HelperServiceProvider::GetLanguageText('pincode_zipcode')}}<span style="color: red;">*</span></label>
                                            <div class="form_feild">
                                                <input type="text" name="pincode" id="pincode" value="{{HelperServiceProvider::CheckoutPage('pincode')}}" placeholder="" >
                                                @error('pincode')
                                                <span class="text-danger error-pincode">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form_group">
                                            <label>{{ HelperServiceProvider::GetLanguageText('industry')}}<span style="color: red;">*</span></label>
                                            <div class="form_feild">
                                                @php $oldIndustry=HelperServiceProvider::CheckoutPage('industry'); @endphp
                                                <select name="industry" class="form-control select_list" id="industry">
                                                    @foreach ($industry_list as $industry)
                                                    <option value="{{$industry->id}}" @if($industry->id==$oldIndustry) selected @endif>{{$industry->name}}</option>
                                                    @endforeach
                                                </select>
                                                @error('industry')
                                                <span class="text-danger error-industry">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form_group">
                                            <label>{{ HelperServiceProvider::GetLanguageText('no_of_employees')}}<span style="color: red;">*</span></label>
                                            <div class="form_feild">
                                                @php $no_of_employee=HelperServiceProvider::CheckoutPage('no_of_employee'); @endphp
                                                <select class="select_list" name="no_of_employee">
                                                    <option value="1-10" @if(@$no_of_employee =='1-10') selected @endif >1-10</option>
                                                    <option value="11-50" @if(@$no_of_employee =='11-50') selected @endif>11-50 </option>
                                                    <option value="51-100" @if(@$no_of_employee =='51-100') selected @endif>51-100</option>
                                                    <option value="100+" @if(@$no_of_employee =='100+') selected @endif>100+</option>
                                                </select>
                                                @error('no_of_employee')
                                                <span class="text-danger error-no_of_employee">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <button class="collapsed general_info1" type="button" data-bs-toggle="collapse" data-bs-target="#general_info1">
                                    {{ HelperServiceProvider::GetLanguageText('contact_information')}}
                                </button>
                                <div id="general_info1" class="accordion-collapse collapse" data-bs-parent="#checkout_accordion">
                                    <div class="accordion-body">
                                        <div class="form_group">
                                            <label>{{ HelperServiceProvider::GetLanguageText('first_name')}}<span style="color: red;">*</span></label>
                                            <div class="form_feild">
                                                <input type="text" name="f_name" placeholder="" maxlength="40" value="{{HelperServiceProvider::CheckoutPage('f_name')}}">
                                                @error('f_name')
                                                <span class="text-danger error-f_name">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form_group">
                                            <label>{{ HelperServiceProvider::GetLanguageText('last_name')}}<span style="color: red;">*</span></label>
                                            <div class="form_feild">
                                                <input type="text" name="l_name" placeholder="" maxlength="40" value="{{HelperServiceProvider::CheckoutPage('l_name')}}">
                                                @error('l_name')
                                                <span class="text-danger error-l_name">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form_group">
                                            <label>{{ HelperServiceProvider::GetLanguageText('designation')}}<span style="color: red;">*</span></label>
                                            <div class="form_feild">
                                                <input type="text" name="designation" id="designation" maxlength="40" placeholder="" value="{{HelperServiceProvider::CheckoutPage('designation')}}">
                                                @error('designation')
                                                <span class="text-danger error-designation">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form_group">
                                            <label>{{ HelperServiceProvider::GetLanguageText('address')}}<span style="color: red;">*</span></label>
                                            <div class="form_feild">
                                                <input type="text" name="address" placeholder="" maxlength="100" value="{{HelperServiceProvider::CheckoutPage('address')}}">
                                                @error('address')
                                                <span class="text-danger error-address">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form_group">
                                            <label>{{ HelperServiceProvider::GetLanguageText('email_address')}}<span style="color: red;">*</span></label>
                                            <div class="form_feild">
                                                <input type="email" name="email" id="email" placeholder="" value="{{HelperServiceProvider::CheckoutPage('email')}}">
                                                @error('email')
                                                <span class="text-danger error-email">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form_group">
                                            <label>{{ HelperServiceProvider::GetLanguageText('contact_number')}}<span style="color: red;">*</span></label>
                                            <div class="form_feild calling_code-div">
                                                @php $calling_code=HelperServiceProvider::CheckoutPage('calling_code'); @endphp
                                                <input type="hidden" name="calling_code" value="{{@$calling_code}}" id="calling_code" class="calling_code">
                                                <input type="text" id="mobile_code_contact" value="{{HelperServiceProvider::CheckoutPage('phone')}}" class="form-control phone" placeholder="Phone Number" name="phone" id="phone">
                                                @error('phone')
                                                <span class="text-danger error-phone">{{ $message }}</span>
                                                @enderror
                                                @error('calling_code')
                                                <span class="text-danger error-calling-code">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <button class="collapsed general_info2" type="button" data-bs-toggle="collapse" data-bs-target="#general_info2">
                                    {{ HelperServiceProvider::GetLanguageText('billing_information')}}
                                </button>
                                <div id="general_info2" class="accordion-collapse collapse" data-bs-parent="#checkout_accordion">
                                    <div class="accordion-body">
                                        <div class="same_above">
                                            <label class="custom_check">{{ HelperServiceProvider::GetLanguageText('same_as_above')}}
                                                <input type="checkbox" id="same_as_above">
                                                <span class="checkmark"></span>
                                            </label>
                                        </div>
                                        <div class="form_group">
                                            <label>{{ HelperServiceProvider::GetLanguageText('registered_company_name')}}<span style="color: red;">*</span></label>
                                            <div class="form_feild">
                                                <input type="text" name="billing_company_name" id="billing_company_name" placeholder="" value="{{HelperServiceProvider::CheckoutPage('billing_company_name')}}">
                                                @error('billing_company_name')
                                                <span class="text-danger error-billing_company_name">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form_group">
                                            <label>{{ HelperServiceProvider::GetLanguageText('country')}}<span style="color: red;">*</span></label>
                                            <div class="form_feild">
                                                @php $billing_country=HelperServiceProvider::CheckoutPage('billing_country'); @endphp
                                                <select class="country-select CheckoutBillingCounteryList" name="billing_country" id="billing_country"></select>
                                                <label id="billing-country-error-div" style="display: none;" class="error" for="billing_country">Please select country name</label>
                                                @error('billing_country')
                                                <span class="text-danger error-billing_country">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form_group billing_state_div">
                                            <label>{{ HelperServiceProvider::GetLanguageText('state')}}<span style="color: red;">*</span></label>
                                            <div class="form_feild">
                                                @php $old_state_list=HelperServiceProvider::CheckoutPage('billing_state'); @endphp
                                                <select name="billing_state" class="form-control select_list" id="billing_state">
                                                    @foreach ($state_list as $key=> $state)
                                                    <option value="{{$state->name}}" @if($state->code==$old_state_list) selected @endif>{{$state->name}}</option>
                                                    @endforeach
                                                </select>
                                                @error('billing_state')
                                                <span class="text-danger error-state">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form_group">
                                            <label>{{ HelperServiceProvider::GetLanguageText('city')}}<span style="color: red;">*</span></label>
                                            <div class="form_feild">
                                                <input type="text" name="billing_city" id="billing_city" placeholder="" maxlength="50" value="{{HelperServiceProvider::CheckoutPage('billing_city')}}">
                                                @error('billing_city')
                                                <span class="text-danger error-billing_city">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form_group">
                                            <label>{{ HelperServiceProvider::GetLanguageText('address_line_1')}}<span style="color: red;">*</span></label>
                                            <div class="form_feild">
                                                <input type="text" name="billing_address_1" id='billing_address_1' maxlength="100" placeholder="" value="{{HelperServiceProvider::CheckoutPage('billing_address_1')}}">
                                                @error('billing_address_1')
                                                <span class="text-danger error-billing_address_1">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form_group">
                                            <label>{{ HelperServiceProvider::GetLanguageText('address_line_2')}}</label>
                                            <div class="form_feild">
                                                <input type="text" name="billing_address_2" id="billing_address_2" maxlength="100" placeholder="" value="{{HelperServiceProvider::CheckoutPage('billing_address_2')}}">
                                                @error('billing_address_2')
                                                <span class="text-danger error-billing_address_2">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form_group">
                                            <label>{{ HelperServiceProvider::GetLanguageText('email_address')}}<span style="color: red;">*</span></label>
                                            <div class="form_feild">
                                                <input type="email" name="billing_email" id="billing_email" placeholder="" value="{{HelperServiceProvider::CheckoutPage('billing_email')}}">
                                                @error('billing_email')
                                                <span class="text-danger error-billing_email">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form_group">
                                            <label>{{ HelperServiceProvider::GetLanguageText('contact_number')}}<span style="color: red;">*</span></label>
                                            <div class="form_feild billing_calling_code-div">
                                                @php $billing_calling_code=HelperServiceProvider::CheckoutPage('billing_calling_code') @endphp
                                                <input type="hidden" name="billing_calling_code" id="billing_calling_code" class="calling_code" value="{{@$billing_calling_code}}">
                                                <input type="text" id="mobile_code11" value="{{HelperServiceProvider::CheckoutPage('billing_phone')}}" class="form-control billing_phone" placeholder="Phone Number" name="billing_phone" id="billing_phone">
                                                @error('billing_phone')
                                                <span class="text-danger error-billing_phone">{{ $message }}</span>
                                                @enderror
                                                @error('billing_calling_code')
                                                <span class="text-danger error-billing_calling_code">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <button class="collapsed general_info3" type="button" data-bs-toggle="collapse" data-bs-target="#general_info3">
                                    {{ HelperServiceProvider::GetLanguageText('document_information')}}
                                </button>
                                <div id="general_info3" class="accordion-collapse collapse" data-bs-parent="#checkout_accordion">
                                    <div class="accordion-body">
                                        <div class="form_group singapore_document india_document all_document">
                                            <label>{{ HelperServiceProvider::GetLanguageText('gst_number')}}</label>
                                            <div class="form_feild">
                                                <input type="text" name="gst_number" placeholder="" value="{{HelperServiceProvider::CheckoutPage('gst_number')}}">
                                                @error('gst_number')
                                                <span class="text-danger error-gst_number">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form_group india_document all_document">
                                            <label>{{ HelperServiceProvider::GetLanguageText('pan_number')}}</label>
                                            <div class="form_feild">
                                                <input type="text" name="pan_number" placeholder="" value="{{HelperServiceProvider::CheckoutPage('pan_number')}}">
                                                @error('pan_number')
                                                <span class="text-danger error-pan_number">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form_group uae_document all_document">
                                            <label>{{ HelperServiceProvider::GetLanguageText('trn_number')}}</label>
                                            <div class="form_feild">
                                                <input type="text" name="trn_number" placeholder="" value="{{HelperServiceProvider::CheckoutPage('trn_number')}}">
                                                @error('trn_number')
                                                <span class="text-danger error-trn_number">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form_group singapore_document all_document">
                                            <label>{{ HelperServiceProvider::GetLanguageText('acra_number')}}</label>
                                            <div class="form_feild">
                                                <input type="text" name="acra_number" placeholder="" value="{{HelperServiceProvider::CheckoutPage('acra_number')}}">
                                                @error('acra_number')
                                                <span class="text-danger error-acra_number">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form_group indonesia_document all_document">
                                            <label>{{ HelperServiceProvider::GetLanguageText('npwp_number')}}</label>
                                            <div class="form_feild">
                                                <input type="text" name="npwp_number" placeholder="" value="{{HelperServiceProvider::CheckoutPage('npwp_number')}}">
                                                @error('npwp_number')
                                                <span class="text-danger error-npwp_number">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form_group indonesia_document uae_document all_document">
                                            <label>{{ HelperServiceProvider::GetLanguageText('tax_registration_number')}}</label>
                                            <div class="form_feild">
                                                <input type="text" name="tax_registration_number" placeholder="" value="{{HelperServiceProvider::CheckoutPage('tax_registration_number')}}">
                                                @error('tax_registration_number')
                                                <span class="text-danger error-tax_registration_number">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form_group  other_document all_document">
                                            <label>{{ HelperServiceProvider::GetLanguageText('company_registration_number')}}</label>
                                            <div class="form_feild">
                                                <input type="text" name="company_registration_number" placeholder="" value="{{HelperServiceProvider::CheckoutPage('company_registration_number')}}">
                                                @error('company_registration_number')
                                                <span class="text-danger error-company_registration_number">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form_group singapore_document all_document">
                                            <label>{{ HelperServiceProvider::GetLanguageText('acra_profile_copy')}}</label>
                                            @php $acra_profile_copy = HelperServiceProvider::CheckoutPage('acra_profile_copy');  @endphp
                                            <div class="form_feild">
                                                <div class="upload-btn-wrapper">
                                                    <button class="btn">+Attach</button>
                                                    <input type="file" name="acra_profile_copy" />
                                                    @error('acra_profile_copy')
                                                    <span class="text-danger error-acra_profile_copy">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <?php if(@$acra_profile_copy){ ?>
                                                <input type="hidden" value="<?=@$acra_profile_copy?>" name="acra_profile_copy_url" />
                                                <a href="<?=url(@$acra_profile_copy)?>" target="_blank">{{ HelperServiceProvider::GetLanguageText('acra_profile_copy')}}</a>
                                            <?php } ?>
                                        </div>
                                        <div class="form_group indonesia_document uae_document all_document">
                                            <label>{{ HelperServiceProvider::GetLanguageText('tax_registration_document')}}</label>
                                            @php $tax_registration_document = HelperServiceProvider::CheckoutPage('tax_registration_document'); @endphp
                                            <div class="form_feild">
                                                <div class="upload-btn-wrapper">
                                                    <button class="btn">+Attach</button>
                                                    <input type="file" name="tax_registration_document" />
                                                    @error('tax_registration_document')
                                                    <span class="text-danger error-tax_registration_document">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <?php if(@$tax_registration_document){ ?>
                                                <input type="hidden" value="<?=@$tax_registration_document?>" name="tax_registration_document_url" />
                                                <a href="<?=url(@$tax_registration_document)?>" target="_blank">{{ HelperServiceProvider::GetLanguageText('tax_registration_document')}}</a>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-5">
                    <div class="checkout_right">
                        <div class="payment_description">
                            <ul>
                                <li>
                                    <strong>{{ HelperServiceProvider::GetLanguageText('subscription_model')}}:</strong>
                                    <p><?= @$subscription_name ?> (<?= @$plan_type ?>)</p>
                                </li>
                                <li>
                                    <strong>{{ HelperServiceProvider::GetLanguageText('no_of_user')}}:</strong>
                                    <p><?= @$show_no_of_user ?></p>
                                </li>
                                <li>
                                    <strong>{{ HelperServiceProvider::GetLanguageText('payment_plan')}}:</strong>
                                    <p><?= @$plan_duration ?></p>
                                </li>
                            </ul>
                        </div>
                        <hr>
                        <div class="payment_description">
                            <ul>
                                <li>
                                    <strong>{{ HelperServiceProvider::GetLanguageText('sub_total')}}:</strong> 
                                    <p><?= @$currency ?> &nbsp; <?= number_format(@$total_amount, 2) ?></p>
                                </li>
                                <li>
                                    <strong><?= @$tax_name ?>:</strong>
                                    <p><?= @$currency ?> &nbsp; <?= number_format(@$tax, 2) ?></p>
                                </li>
                            </ul>
                        </div>
                        <div class="total_amount">
                            <h4>{{ HelperServiceProvider::GetLanguageText('total')}}:</h4>
                            <div class="amount_value"><?= @$currency ?> &nbsp; 
                                <span> <?= number_format($grand_amount, 2) ?></span>
                            </div>
                        </div>
                        <hr>
                        <div class="payment_description">
                            <ul>
                                <li>
                                    <strong>{{ HelperServiceProvider::GetLanguageText('payment_mode')}}</strong> 
                                    <div class="pay_method_grid">
                                        {{-- @if(!(@$country_code =='IN' || @$country_code=='ID')) --}}
                                            <div class="choose_meethod">
                                                <input type="radio" id="Offline" checked name="payment_mode" value="Offline">
                                                <label for="Offline">{{ HelperServiceProvider::GetLanguageText('offline')}}</label>
                                            </div>
                                        {{-- @else
                                        <div class="choose_meethod">
                                            <input type="radio" id="auropay" checked name="payment_mode" value="auropay">
                                            <label for="auropay"><img style="width: 90px;" src="{{ asset('img/auropay.webp') }}" alt="Logo"></label>
                                        </div>
                                        @endif --}}
                                    </div>
                                </li>
                            </ul>
                        </div>
                        <div class="btn_wrap">
                            <p>
                                <label class="custom_check"> {{ HelperServiceProvider::GetLanguageText('i_agree_to_the_terms_of_use')}}, <a href="http://127.0.0.1:8000/page/terms-and-conditions" target="_blank">{{ HelperServiceProvider::GetLanguageText('view_terms_and_condition')}}</a>
                                    <input type="checkbox" name="checkbox">
                                    <span class="checkmark"></span>
                                </label>
                            </p>
                            <button class="submit_btn" type="submit">{{ HelperServiceProvider::GetLanguageText('proceed_to_payment')}}</button>
                            <!--<button class="submit_btn mt-4" id="change_lob" type="button">Change Lob</button>-->
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</section>
@endsection
@section('script')
    <script>
        $("document").ready(function () {
            $('.error-billing_calling_code-error').hide();
            // -----Country Code Selection
            var element = document.getElementById('mobile_code11');
            if (element) {
                $("#mobile_code11").intlTelInput({
                    initialCountry: "<?=(@$billing_calling_code)?$billing_calling_code:'auto'?>",
                    separateDialCode: true,
                });
                $("#mobile_code_contact").intlTelInput({
                    initialCountry: "<?=(@$calling_code)?$calling_code:'auto'?>",
                    separateDialCode: true,
                });
            }
        });
        $('.accordion-collapse').on('shown.bs.collapse', function(e) {
            var $panel = $(this).closest('.accordion-item');
            $('html,body').animate({
                scrollTop: $panel.offset().top
            }, 500);
        });
        jQuery(function() {
            // Add custom email check validation method
            $.validator.addMethod("checkEmailExists", function(value, element) {
                var emailExists = false;
                // Make an AJAX request to check if the email exists in the database
                $.ajax({
                    url: "{{route('check-checkout-email')}}",
                    type: "POST",
                    data: {
                        _token: "<?php echo csrf_token() ?>",
                        email: value
                    },
                    async: false, // Make the request synchronous
                    success: function(response) {
                        emailExists = response;
                        if(emailExists){
                            $(".general_info1").trigger("click");
                        }
                    }
                });
                return !emailExists; // Return true if the email doesn't exist, false otherwise
            }, "Please use different email address");
            // Add custom validation method for country field
            $.validator.addMethod("validCountry", function (value) {
                if(value !== "-1"){
                    $('#country-error-div').hide();
                }else{
                    $('#country-error-div').show();
                    $(".general_info").trigger("click");
                }
                return value !== "-1";
            }, "Please select country name.");
            $.validator.addMethod("validBillingCountry", function (value) {
                if(value !== "-1"){
                    $('#billing-country-error-div').hide();
                }else{
                    $('#billing-country-error-div').show();
                    $(".general_info2").trigger("click");
                }
                return value !== "-1";
            }, "Please select country name.");
            // Custom validation method for checking email format
            $.validator.addMethod("customEmail", function(value, element) {
                let checkVal=  this.optional(element) || /^[a-zA-Z0-9_.-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/i.test(value);
                if(!checkVal){
                    $(".general_info1").trigger("click");
                }
                return checkVal;
            }, "Please enter a valid email address.");
            $.validator.addMethod("customEmailBilling", function(value, element) {
                let checkVal=  this.optional(element) || /^[a-zA-Z0-9_.-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/i.test(value);
                if(!checkVal){
                    $(".general_info2").trigger("click");
                }
                return checkVal;
            }, "Please enter a valid email address.");
            // calling code
            $.validator.addMethod("BillingCallingCode", function(value, element) {
                let checkVal=  ($('#billing_calling_code').val())?true:false;
                if(!checkVal){
                    $(".general_info2").trigger("click");
                }
                return checkVal;
            }, "Please select Calling code.");
            $.validator.addMethod("CallingCode", function(value, element) {
                let checkVal=  ($('#calling_code').val())?true:false;
                if(!checkVal){
                    $(".general_info1").trigger("click");
                }
                return checkVal;
            }, "Please select Calling code.");
            jQuery("form[name='customer_checkout']").validate({
                ignore: [],
                rules: {
                    f_name: {
                        required: true,
                        maxlength: 41,
                        minlength: 2
                    },
                    l_name: {
                        required: true,
                        maxlength: 41,
                        minlength: 2
                    },
                    email: {
                        required: true,
                        maxlength: 50,
                        minlength: 5,
                        email: true,
                        customEmail: true,
                        checkEmailExists: true
                    },
                    designation: {
                        required: true,
                        maxlength: 41,
                        minlength: 2
                    },
                    billing_company_name: {
                        required: true,
                        maxlength: 101,
                        minlength: 2
                    },
                    city: {
                        required: true,
                        minlength: 2,
                        maxlength: 51
                    },
                    billing_city: {
                        required: true,
                        minlength: 2,
                        maxlength: 51
                    },
                    address: {
                        required: true,
                        maxlength: 101
                    },
                    address_1: {
                        required: true,
                        maxlength: 101
                    },
                    billing_address_1: {
                        required: true,
                        maxlength: 101
                    },
                    country:{
                        validCountry:true
                        // required: true
                    },
                    payment_mode: "required",
                    billing_country:{
                        validBillingCountry:true
                        // required: true
                    },
                    calling_code: "required",
                    checkbox: "required",
                    industry: "required",
                    no_of_employee: "required",
                    billing_email: {
                        required: true,
                        maxlength: 50,
                        minlength: 5,
                        email: true,
                        customEmailBilling: true
                    },
                    phone: {
                        CallingCode:true,
                        required: true,
                        digits: true
                    },
                    billing_phone: {
                        BillingCallingCode:true,
                        required: true,
                        digits: true
                    },
                    pincode: {
                        required:function() {
                            if($("#country").val()=='AE'){
                                return false;
                            }
                            return true;
                        },
                        digits: true
                    },
                    state: {
                        required: function() {
                            if ($("#country").val() === 'IN') {
                                return true;
                            }
                            return false;
                        }
                    },
                    billing_state: {
                        required: function() {
                            if ($("#billing_country").val() === 'IN') {
                                return true;
                            }
                            return false;
                        }
                    }
                },
                // Specify validation error messages
                messages: {
                    f_name: {
                        required: "Please enter first name",
                        maxlength: "First name must be less then 40 characters long.",
                        minlength: "First name must be greater then 2 characters long."
                    },
                    l_name: {
                        required: "Please enter last name",
                        maxlength: "Last name must be less then 40 characters long.",
                        minlength: "Last name must be greater then 2 characters long."
                    },
                    email: {
                        required: "Please enter a valid email address",
                        email: "Please enter a valid email address",
                        maxlength: "Email must be less then 50 characters long.",
                        minlength: "Email must be greater then 5 characters long."
                    },
                    designation: {
                        required: "Please enter designation",
                        maxlength: "Designation must be less then 40 characters long.",
                        minlength: "Designation must be greater then 2 characters long."
                    },
                    billing_company_name: {
                        required: "Please enter company name",
                        maxlength: "Company name must be less then 100 characters long.",
                        minlength: "Company name must be greater then 2 characters long."
                    },
                    city: {
                        required: "Please enter city name",
                        maxlength: "City name must be less then 50 characters long.",
                        minlength: "City name must be greater then 2 characters long."
                    },
                    billing_city: {
                        required: "Please enter city name",
                        maxlength: "City name must be less then 50 characters long.",
                        minlength: "City name must be greater then 2 characters long."
                    },
                    address: {
                        required: "Please enter the address",
                        maxlength: "address must be less then 100 characters long."
                    },
                    address_1: {
                        required: "Please enter address",
                        maxlength: "address must be less then 100 characters long."
                    },
                    billing_address_1: {
                        required: "Please enter the address",
                        maxlength: "address must be less then 100 characters long."
                    },
                    country: "Please select country name",
                    payment_mode: "Please select payment mode",
                    billing_country: "Please select country name",
                    calling_code: "Please select International Calling code",
                    checkbox: "Please agree terms and condition",
                    industry: "Please select Industry",
                    no_of_employee: "Please select no of employee",
                    billing_email: {
                        required: "Please enter a valid email address",
                        email: "Please enter a valid email address",
                        maxlength: "Email must be less then 50 characters long.",
                        minlength: "Email must be greater then 5 characters long."
                    },
                    phone: {
                        required: "Please enter phone number.",
                        digits: "Please enter only digits.",
                        // minlength: "Your phone number must be at least 10 digits long",
                        minlength: $.validator.format("Your phone number must be at least {0} digits long."),
                        maxlength: "Your phone number must be less or equal 15 digits long"
                    },
                    billing_phone: {
                        required: "Please enter phone number.",
                        digits: "Please enter only digits.",
                        // minlength: "Your phone number must be at least 10 digits long",
                        minlength: $.validator.format("Your phone number must be at least {0} digits long."),
                        maxlength: "Your phone number must be less or equal 15 digits long"
                    },
                    pincode: {
                        required: "Please enter Pincode/Zipcode",
                        digits: "Please enter only digits.",
                        minlength: "Pincode/Zipcode must be 6 digits long.",
                        maxlength: "Pincode/Zipcode must be 6 digits long."
                    },
                    state: "Please select state",
                    billing_state: "Please select state",
                },
                invalidHandler: function(event, validator) {
                    var ErrorCount=0;
                    // Check if the validation failed for email or l_name
                    var failedFields = ["city","address_1","country","industry","no_of_employee"];
                    for (var i = 0; i < validator.errorList.length; i++) {
                        var element = validator.errorList[i].element;
                        if (failedFields.indexOf(element.name) !== -1) {
                            $(".general_info").trigger("click");
                            ErrorCount++;
                            break;
                        }
                    }
                    if(ErrorCount==0){
                        // Check if the validation failed for email or l_name
                        var failedFields1 = ["f_name", "l_name","email","address","phone","designation"];
                        for (var i = 0; i < validator.errorList.length; i++) {
                            var element = validator.errorList[i].element;
                            if (failedFields1.indexOf(element.name) !== -1) {
                                $(".general_info1").trigger("click");
                                ErrorCount++;
                                break;
                            }
                        }
                    }
                    if(ErrorCount==0){
                        // Check if the validation failed for email or l_name
                        var failedFields2 = ["billing_company_name", "billing_city","billing_address_1","billing_country","billing_email","billing_phone","billing_state"];
                        for (var i = 0; i < validator.errorList.length; i++) {
                            var element = validator.errorList[i].element;
                            if (failedFields2.indexOf(element.name) !== -1) {
                                $(".general_info2").trigger("click");
                                break;
                            }
                        }
                    }
                },
                submitHandler: function(form) {
                    // $('#modal-loader').modal('show');
                    form.submit();
                }
            });
        });
        jQuery('#country').change(function() {
            if ($(this).val() == 'IN') {
                jQuery('.state_div').show();
            } else {
                jQuery('.state_div').hide();
            }
            if($(this).val()=='AE'){
                $('.pincode-div').hide();
            }else{
                $('.pincode-div').show();
            }
            $('#country-error-div').hide();
        });

        function callingCodeSelect(countryCode){
            var countryCode = countryCode.toLowerCase();
            $('#general_info2').find('li.iti__country').each(function() {
                let country_code=$(this).data('country-code');
                if(countryCode==country_code){
                    let dial_code = $(this).data('dial-code');
                    let country_name = $(this).find('.iti__country-name').html();

                    $('#billing_calling_code').val(country_code);
                    // Update selected dial code
                    $('#general_info2').find('.iti__selected-dial-code').html('+' + dial_code);

                    // Update selected flag title
                    $('#general_info2').find('.iti__selected-flag').attr('title', country_name + ' +' + dial_code);

                    // Remove previous classes and add new classes to the selected flag
                    $('#general_info2').find('.iti__selected-flag .iti__flag').removeClass(function(index, className) {
                        return (className.match(/(^|\s)iti__\S+/g) || []).join(' ');
                    }).addClass('iti__flag iti__' + country_code);
                }
            });
        }

        $('#billing_country').change(function() {
            if ($(this).val() == 'IN') {
                $('.billing_state_div').show();
            } else {
                $('.billing_state_div').hide();
            }
            if ($(this).val() == 'IN') {
                $('.all_document').hide();
                $('.india_document').show();
            } else if ($(this).val() == 'SG') {
                $('.all_document').hide();
                $('.singapore_document').show();
            } else if ($(this).val() == 'AE') {
                $('.all_document').hide();
                $('.uae_document').show();
            } else if ($(this).val() == 'ID') {
                $('.all_document').hide();
                $('.indonesia_document').show();
            } else if ($(this).val() == 'Other') {
                $('.all_document').hide();
                $('.other_document').show();
            }
            $('#billing-country-error-div').hide();
            //------------------------------------------------------------------
            callingCodeSelect($(this).val());
            //------------------------------------------------------------------
        });
        $('body').on('click keydown keypress touchstart pointerdown', '.iti__country.iti__standard', function() {
            var flagElement = $(this).find('.iti__flag').attr('class');
            var newText = flagElement.replace("iti__flag iti__", "");
            if ($(this).closest('.form_feild').find('.calling_code').length > 0) {
                $(this).closest('.form_feild').find('.calling_code').val(newText);
            } else {
                $('.calling_code').val(newText);
            }
        });
        //email
        jQuery(document).on('keypress', '#email,#billing_email', function(event) {
            jQuery('.error-email').hide();
            var regex = new RegExp("^[a-zA-Z.0-9.@-]+$");
            var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
            if (!regex.test(key)) {
                event.preventDefault();
                return false;
            }
        });
        //first Name
        jQuery(document).on('keypress', '#f_name', function(event) {
            jQuery('.error-f-name').hide();
            $(this).css({
                'text-transform': 'capitalize'
            });
            var regex = new RegExp("^[a-zA-Z ]+$");
            var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
            if (!regex.test(key)) {
                event.preventDefault();
                return false;
            }
            var phone_no = $('#f_name').val();
            if (phone_no.length >= 40) {
                return false;
            }
        });
        //last Name
        jQuery(document).on('keypress', '#l_name', function(event) {
            jQuery('.error-l-name').hide();
            $(this).css({
                'text-transform': 'capitalize'
            });
            var regex = new RegExp("^[a-zA-Z ]+$");
            var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
            if (!regex.test(key)) {
                event.preventDefault();
                return false;
            }
            var phone_no = $('#l_name').val();
            if (phone_no.length >= 40) {
                return false;
            }
        });
        //company Name
        jQuery(document).on('keypress', '#company', function(event) {
            jQuery('.error-country').hide();
            $(this).css({
                'text-transform': 'capitalize'
            });
            var regex = new RegExp("^[a-zA-Z 0-9 .-]+$");
            var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
            if (!regex.test(key)) {
                event.preventDefault();
                return false;
            }
            var phone_no = $('#company').val();
            if (phone_no.length >= 100) {
                return false;
            }
        });
        //city Name
        jQuery(document).on('keypress', '#city', function(event) {
            jQuery('.error-city').hide();
            $(this).css({
                'text-transform': 'capitalize'
            });
            var regex = new RegExp("^[a-zA-Z 0-9 ,'-]+$");
            var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
            if (!regex.test(key)) {
                event.preventDefault();
                return false;
            }
            var phone_no = $('#city').val();
            if (phone_no.length > 50) {
                return false;
            }
        });
        //phone
        jQuery(document).on('keypress', '#phone', function(event) {
            jQuery('.error-phone').hide();
            jQuery('.error-calling-code').hide();
            var regex = new RegExp("^[0-9]+$");
            var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
            if (!regex.test(key)) {
                event.preventDefault();
                return false;
            }
            var phone_no = $('#phone').val();
            if (phone_no.length > 15) {
                return false;
            }
        });
        //pincode
        jQuery(document).on('keypress', '#pincode', function(event) {
            jQuery('.error-email').hide();
            var regex = new RegExp("^[0-9]+$");
            var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
            if (!regex.test(key)) {
                event.preventDefault();
                return false;
            }
        });
        //Street  Address
        jQuery(document).on('keypress', '#address', function(event) {
            jQuery('.error-address').hide();
            $(this).css({
                'text-transform': 'capitalize'
            });
            var regex = new RegExp("^[a-zA-Z0-9 .' ,-]+$");
            var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
            if (!regex.test(key)) {
                event.preventDefault();
                return false;
            }
            var phone_no = $('#address').val();
            if (phone_no.length > 100) {
                return false;
            }
        });
        //Street  designation
        jQuery(document).on('keypress', '#designation', function(event) {
            jQuery('.error-designation').hide();
            var phone_no = $('#designation').val();
            if (phone_no.length >= 40) {
                return false;
            }
        });
        $('#same_as_above').click(function() {
            if ($('#same_as_above').is(':checked')) {
                var company_name = $('#company_name').val();
                var city = $('#city').val();
                var address_1 = $('#address_1').val();
                var address_2 = $('#address_2').val();
                var country = $('#country').val();
                var state = $('#state').val();
                var email = $('#email').val();
                var mobile_code = $('#calling_code').val();
                var phone = $('.phone').val();
                $('#billing_company_name').val(company_name);
                $('#billing_state').val(state);
                $('#billing_city').val(city);
                $('#billing_address_1').val(address_1);
                $('#billing_address_2').val(address_2);
                $('#billing_email').val(email);

                $('.billing_phone').val(phone);
                $(".CheckoutBillingCounteryList").val(country).trigger("change");
                if (country == 'IN') {
                    $('.billing_state_div').show();
                } else {
                    $('.billing_state_div').hide();
                }
                $('#billing_calling_code').val(mobile_code);
                //-------------------------------------------------------------------
                // var flagTitle=$('.calling_code-div .iti__selected-flag').attr('title');
                // var flapText=$('.calling_code-div .iti__selected-flag .iti__selected-dial-code').text();
                // $('.billing_calling_code-div .iti__selected-flag').attr('title',flagTitle);
                // $('.billing_calling_code-div .iti__selected-flag .iti__selected-dial-code').text(flapText);
                // $(".billing_calling_code-div .iti__selected-flag").children("div").first().toggleClass("iti__"+mobile_code);

                //-------------------------------------------------------------------
                var countryCode = mobile_code.toLowerCase();
                $('#general_info1').find('li.iti__country').each(function() {
                    let country_code=$(this).data('country-code');
                    if(countryCode==country_code){
                        let dial_code = $(this).data('dial-code');
                        let country_name = $(this).find('.iti__country-name').html();
                        // Update selected dial code
                        $('.iti__selected-dial-code').html('+' + dial_code);

                        // Update selected flag title
                        $('.iti__selected-flag').attr('title', country_name + ' +' + dial_code);

                        // Remove previous classes and add new classes to the selected flag
                        $('.iti__selected-flag .iti__flag').removeClass(function(index, className) {
                            return (className.match(/(^|\s)iti__\S+/g) || []).join(' ');
                        }).addClass('iti__flag iti__' + country_code);
                    }
                });
                //----------------------------------------------------------------
            }
        })
    </script>
    <script>
        $(document).on('click', '#change_lob', function() {
            $.ajax({
                url: "{{route('store-old-data-checkout')}}",
                type: "POST",
                data: $('#customer_checkout').serialize(),
                async: false, // Make the request synchronous
                success: function(response) {
                    window.location.href = response;
                }
            });
        });
    </script>
    <script>
        @php
            if($billing_country!='IN' && $billing_country !='SG' && $billing_country !='AE' && $billing_country !='ID') {$billing_country='Other';}
            if($country!='IN' && $country !='SG' && $country !='AE' && $country !='ID') {$country='Other';}
        @endphp
        $(document).ready(function(){
            setTimeout(() => {
                $(".CheckoutCounteryList").val("<?=@$country?>").trigger("change");
                $(".CheckoutBillingCounteryList").val("<?=@$billing_country?>").trigger("change");
            }, 1000);
            $('#billing_calling_code').on('change',function(){
                $('.error-billing_calling_code-error').hide();
            })
        });
    </script>
    <script>
        window.addEventListener('load', function() {
            @if (session('status'))
                AlertMassage(`<?= session('status') ?>`);
            @endif
            @if (Session::has('message'))
                AlertMassage(`<?= Session::get('message') ?>`);
            @endif
        });
    </script>
    <script>
        $(document).on('click', '.submit_btn', function(){
            var loader = document.getElementById('loader');
            loader.style.display = 'block';
            setTimeout(() => {
                if ($("#customer_checkout").validate().errorList.length !== 0) {
                    loader.style.display = 'none';
                }
            }, 2000);
        });
        @if(!$billing_calling_code)
            $(document).ready(function() {
                $('.billing_calling_code-div .iti__selected-flag .iti__flag').addClass('dummy-flag-icon');
            });
        @endif
    </script>
@endsection
