@php
$meta_title = $data->meta_title;
$meta_description = $data->meta_description;
$meta_keywords = $data->meta_keywords;
//$add_class_header='show-nav';
$footer_sign_up_for_free_trial=true;
@endphp
@extends('frontend.user.includes.master')
@section('body')
@if($data->banner_image)

    <style>
        .payment_gatway #baner_slider {
            height: 680px;
        }
        @media only screen and (max-width: 1600px) {
          .payment_gatway #baner_slider {
            height: 460px;
          }
        }
    </style>

    <section class="banner__section payment_gatway <?=(@$data->title && @$data->sub_title )?'':'one-line-text-box' ?>">
        <div id="baner_slider" class="carousel slide">
            <div class="carousel-inner">
                <div class="carousel-item active">
                    <img src="{{url($data->banner_image)}}" class="w-100" alt="{{$data->title}}">
                    <div class="carousel-caption">
                        <div class="container">
                            <div class="inner__content_-wrap">
                                <h1><?=$data->title?></h1>
                                <div class="screen__heading">
                                    <h2><?=$data->sub_title?></h2>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endif

    <section class="partner__grid">
        <div class="owl-carousel" id="clander_slider">
        </div>
    </section>

@if($eventData)
    @php $dateList=array(); @endphp
    @foreach ($eventData as $item)
        @php
            $date=date('Y-m-d',strtotime($item->datetime));
            $dateList[]=$date;
        @endphp

        <section class="event_middle_content filter_<?=$date;?>">
            <div class="container">
                <div class="event__blog">
                    <div class="event_img">
                        <div class="border_img">
                            @if ($item->media_type=='Image' && $item->image)
                                <img src="{{ url($item->image)}}" alt="{{$item->title}}">
                            @elseif($item->media_type=='Video')
                                @if($item->video_type=='MP4' && $item->video)
                                    <video width="100%" height="100%" autoplay muted loop>
                                        <source src="{{ url($item->video)}}" type="video/mp4">
                                    </video>
                                @elseif ($item->video_type=='Youtube' && $item->youtube)
                                    <iframe width="100%" height="100%" src="{{$item->youtube}}"></iframe>
                                @endif
                            @endif
                        </div>
                    </div>
                    <div class="event_dec">
                        <h2>{{$item->title}}</h2>
                        <?=@$item->description?>
                        @if($item->pdf)
                        <div class="download_agenda">
                            <a href="{{url($item->pdf)}}" download="{{$item->title}}.pdf">{{ HelperServiceProvider::GetLanguageText('download_agenda')}} <img src="{{ asset('frontend/images/download_icon.png')}}" alt="img"></a>
                        </div>
                        @endif

                        <div class="clander__onlineBtn">
                            <div class="flex_btn">
                                <a class="online_text" href="{{$item->meeting_link}}">
                                    <img src="{{ asset('frontend/images/online-play.png')}}" alt="img">
                                    <span>{{$item->meeting_type}}</span>
                                </a>
                                <a class="clander_text" href="javascript:void(0)">
                                    <img src="{{ asset('frontend/images/clander-img.png')}}" alt="img">
                                    <span><?=date('d F, Y | h:i A',strtotime($item->datetime));?></span>
                                </a>
                            </div>
                            <div class="reg_btn">
                                <a class="btn_cta" href="javascript:void(0);">{{ HelperServiceProvider::GetLanguageText('register_now')}}</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="regester__form login_grid sign_up">
                    <div class="cross_btn">
                        <a href="javascript:void(0);">X</a>
                    </div>
                    <div class="step_first">
                        <div class="form_title">
                            <h1>{{$data->form_title}}</h1>
                        </div>
                        <form action="" method="POST">
                            @csrf
                            
                            <input type="hidden" name="event_id" value="{{$data->id}}">
                            <input type="hidden" name="event_child_id" value="{{$item->id}}">
                            <div class="form_group">
                                <label>{{ HelperServiceProvider::GetLanguageText('first_name')}}<span style="color: red;">*</span></label>
                                <div class="form_feild">
                                    <input type="text" id="f_name" class="f_name" name="f_name" placeholder="">
                                </div>
                            </div>
                            <div class="form_group">
                                <label>{{ HelperServiceProvider::GetLanguageText('last_name')}}<span style="color: red;">*</span></label>
                                <div class="form_feild">
                                    <input type="text" id="l_name" class="l_name" name="l_name" placeholder="">
                                </div>
                            </div>
                            <div class="form_group">
                                <label>{{ HelperServiceProvider::GetLanguageText('email')}}<span style="color: red;">*</span></label>
                                <div class="form_feild">
                                    <input type="email" id="email" class="email" name="email" placeholder="">
                                </div>
                            </div>
                            <div class="form_group">
                                <label>{{ HelperServiceProvider::GetLanguageText('contact_number')}}<span style="color: red;">*</span></label>
                                <div class="form_feild">
                                    <input type="hidden" name="calling_code" class="calling_code" id="calling_code">
                                    <input type="text"  class="form-control mobile_code" placeholder="{{ HelperServiceProvider::GetLanguageText('phone_number')}}" name="phone">
                                </div>
                            </div>
                            <div class="form_group">
                                <label></label>
                                <div class="form_feild">
                                    <input type="submit" class="btn_cta" value="{{ HelperServiceProvider::GetLanguageText('register')}}"/>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="step_scound">
                        <div class="thanku_message">
                            <h4>{{$data->form_submit_message}}</h4>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endforeach
    @php $jsonArray = json_encode($dateList); @endphp
@endif

@endsection
@section('script')
    <script>
        $('body').on('click keydown keypress touchstart pointerdown', '.iti__country.iti__standard', function(){
            var code =$(this).attr('data-dial-code');
            $('.calling_code').val(code);
        });

        $(document).ready(function () {
            var checkboxes = $("input#express_checkout[type='checkbox']"),
                actions = $("#actions");
            checkboxes.click(function () {
                actions.attr("hidden", !checkboxes.is(":checked"));
            });
            $(".reg_btn .btn_cta").click(function () {
                // $(".regester__form").toggle();
                $(this).parents('section.event_middle_content').find('.regester__form').toggle();
                var $th =$(this).parents('section.event_middle_content').find('.regester__form');
                $('html, body').animate({
                    scrollTop: $th.offset().top
                }, 600);
                $(this).parents('section.event_middle_content').find('.step_first form input[type="submit"]').trigger('click');

            });
            // $(".form_feild .btn_cta").click(function () {
            //     $(".step_first").hide();
            //     $(".step_scound").show();
            // });
            $(".cross_btn a").click(function () {
                $(".regester__form").hide();
            });
        });

        $('.accordion-collapse').on('shown.bs.collapse', function (e) {
            var $panel = $(this).closest('.accordion-item');
            $('html,body').animate({
                scrollTop: $panel.offset().top
            }, 500);
        });

        function formatDateToYMD(date) {
            const year = date.getFullYear();
            const month = String(date.getMonth() + 1).padStart(2, '0');
            const day = String(date.getDate()).padStart(2, '0');
            return `${year}-${month}-${day}`;
        }

        var eventData = <?php echo $jsonArray; ?>;
        //Generate calendar HTML for a specific month and year
        function generateCalendarHTML(year, month) {
            const monthNames = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];
            const daysInMonth = new Date(year, month + 1, 0).getDate();
            const calendarData = [];
            for (let day = 1; day <= daysInMonth; day++) {
                const formattedDate = new Date(year, month, day).toLocaleDateString('en-US', { month: 'long', day: 'numeric', year: 'numeric' });
                const unformattedDate = new Date(year, month, day);
                const un_formattedDate = formatDateToYMD(unformattedDate);
                const event = `Event for ${formattedDate}`;
                calendarData.push({ date: un_formattedDate, formattedDate: formattedDate, event: event, d: day, m: month, y: year });
            }
            let calendarHTML = `<div class="item"><div class="slider__grid"><div class="calendar"><div class="ui-datepicker-inline">`;
            calendarHTML += `<div class="ui-datepicker-header">`;
            calendarHTML += `<div class="ui-datepicker-title"><span class="ui-datepicker-month">${monthNames[month]}</span>&nbsp;<span class="ui-datepicker-year">${year}</span></div></div>`;
            calendarHTML += `<table class="ui-datepicker-calendar">`;
            calendarHTML += `<tbody><tr>`;
            let high_light = null;
            let act_event = null;
            for (const item of calendarData) {
                const dateString =item.date;
                if (eventData.includes(item.date)) {
                    high_light = `ui-state-default ui-state-highlight ui-state-active ${item.date}`;
                    act_event = `ui-datepicker-days-cell-over  ui-datepicker-current-day ui-datepicker-today eventDay`;
                } else {
                    high_light = `ui-state-default`;
                    act_event = ``;
                }
                calendarHTML += `<td class="${act_event}" data-handler="selectDay" data-event=".filter_${dateString}" data-month="${item.m}" data-year="${item.y}"><a
                    class="${high_light}" href="javascript:void(0);">${item.d}</td>`;
                    
                if (item.d % 7 == 0) {
                    calendarHTML += `</tr><tr>`;
                }
            }
            const emptyDateLength = 35 - parseInt(calendarData.length);
            for (let i = 1; i <= emptyDateLength; i++) {
                calendarHTML += ` <td><a disabled>${i}</td>`;
            }
            calendarHTML += '</tr></tbody></table></div></div></div></div>';
            return calendarHTML;
        }
        // Initialize Owl Carousel
        $(document).ready(function () {
            const carousel = $('.owl-carousel');
            // Generate calendar HTML for each month
            let currentPosition = 1;
            function generateCalendarThreeSlides() {
                const currentDate = new Date();
                const currentYear = currentDate.getFullYear();
                const currentMonth = currentDate.getMonth();
                currentPosition = currentDate.getMonth();
                const monthSlides = [];
                for (let month = 0; month < 12; month++) {
                    const year = month <= currentMonth ? currentYear : currentYear;
                    monthSlides.push(generateCalendarHTML(year, month));
                }
                return monthSlides;
            }
            // Update carousel with calendar slides
            function updateCarousel() {
                const monthSlides = generateCalendarThreeSlides();
                carousel.append(monthSlides);
            }
            // Initial carousel update
            updateCarousel();
            // console.log(currentPosition);
            carousel.owlCarousel({
                items: 3,
                margin: 30,
                nav: true,
                center: true,
                dots: true,
                loop: true,
                autoplay: false,
                autoHeight: true,
                autoplayTimeout: 4000,
                smartSpeed: 800,
                startPosition: currentPosition,
                responsive: {
                    320: {
                        items: 1,
                        margin: 10,
                        nav: true,
                    },
                    484: {
                        items: 1,
                        margin: 10,
                        nav: true,
                    },
                    601: {
                        items: 2,
                        margin: 10,
                        nav: true,
                    },
                    767: {
                        items: 2,
                        margin: 15,
                        nav: true,
                    },
                    1024: {
                        items: 3,
                        margin: 20,
                        nav: true,
                    }
                }
            });
            $("#clander_slider .owl-prev").html('<img src="{{ asset('frontend/images/arrow-img.png')}}" alt="img">');
            $("#clander_slider .owl-next").html('<img src="{{ asset('frontend/images/arrow-img.png')}}" alt="img">');
            $('.event_middle_content').hide();
            $(document).on('click','.eventDay', function(){
                $('.event_middle_content').hide();
                let eventDay = $(this).data('event');
                $(eventDay).show(300);
                var $container = $("html,body");
                var $scrollTo = $(eventDay);
                $container.animate({scrollTop: $scrollTo.offset().top - $container.offset().top + $container.scrollTop(), scrollLeft: 0},600);

                $('html, body').animate({
                    scrollTop: $(eventDay).offset().top
                }, 600);

            });
        });

    function formSubmitHandler(event) {
        event.preventDefault(); // Prevent form submission
        const form = event.target; // Get the form element
        const formName = form.name; // or form.id, depending on your setup
        validateForm(form);
    }

    //form validation
    function validateForm(form) {
        jQuery(function() {
            // Custom validation method for checking email format
            $.validator.addMethod("customEmail", function(value, element) {
                return this.optional(element) || /^[a-zA-Z0-9_.-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/i.test(value);
            }, "Please enter a valid email address.");

            $.validator.addMethod("CallingCode", function(value, element) {
                return ($('#calling_code').val())?true:false;
            }, "Please select Calling code.");

            jQuery(form).validate({
                rules: {
                    f_name: {
                        required: true,
                        maxlength: 41,
                        minlength: 2
                    },
                    l_name: {
                        required: true,
                        maxlength: 41,
                        minlength: 2
                    },
                    email: {
                        required: true,
                        email: true,
                        customEmail: true
                    },
                    phone: {
                        CallingCode:true,
                        required: true,
                        digits: true
                    }
                },
                // Specify validation error messages
                messages: {
                    f_name: {
                        required: "Please enter first name",
                        maxlength: "First name must be less than 40 characters long.",
                        minlength: "First name must be greater than 2 characters long."
                    },
                    l_name: {
                        required: "Please enter last name",
                        maxlength: "Last name must be less than 40 characters long.",
                        minlength: "Last name must be greater than 2 characters long."
                    },
                    phone: {
                        required: "Please enter phone number.",
                        minlength: "Your phone number must be at least 10 digits long",
                        maxlength: "Your phone number must be less than or equal to 15 digits long"
                    },
                    email: {
                        required: "Please enter email address.",
                        email: "Please enter a valid email address"
                    }
                },
                submitHandler: function(form) {
                    // Serialize the form data
                    var formData = $(form).serialize();
                    $('#modal-loader').modal('show');
                    // Send an AJAX request to submit the form data
                    $.ajax({
                        type: "POST",
                        url: "{{route('general.page.event.store')}}",
                        data: formData,
                        success: function(response) {
                            $('#modal-loader').modal('hide');
                            // Handle the successful response
                            if(response.type=='success'){
                                $(form).closest(".step_first").hide();
                                $(form).closest(".step_first").next(".step_scound").show();
                            }else{
                                AlertMassage(response.message);
                            }
                        },
                        error: function(xhr, status, error) {
                            // Handle the error response
                            console.log(error);
                        }
                    });
                }
            });
        });
    }

    // Attach the event listener to all forms on the page
    const forms = document.querySelectorAll('form');
        forms.forEach((form) => {
        form.addEventListener('submit', formSubmitHandler);
    });
       

    //email
    jQuery(document).on('keypress', '.email', function(event) {
        jQuery('.error-email').hide();
        var regex = new RegExp("^[a-zA-Z.0-9.@]+$");
        var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        $('.text-danger').hide();
        if (!regex.test(key)) {
            event.preventDefault();
            return false;
        }
    });
    //Dealer Name
    jQuery(document).on('keypress', '.f_name,.l_name', function(event) {
        jQuery('.error-f-name').hide();
        $(this).css({'text-transform': 'capitalize'});
        var regex = new RegExp("^[a-zA-Z ]+$");
        var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        if (!regex.test(key)) {
            event.preventDefault();
            return false;
        }
    });
    //phone
    jQuery(document).on('keypress', '.mobile_code', function(event) {
        jQuery('.error-phone').hide();
        jQuery('.error-calling-code').hide();
        var regex = new RegExp("^[0-9]+$");
        var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        if (!regex.test(key)) {
            event.preventDefault();
            return false;
        }
    });

    $(document).ready(function() {
        $('.iti__selected-flag .iti__flag').addClass('dummy-flag-icon');
    });
    </script>
@endsection
