@extends('frontend.user.includes.master')
@section('body')
{{-- ---------------------------------------------------------------------------------sliders------------------------------------------------------- --}}
@if(!$sliders->isEmpty() || !$sliderAuto->isEmpty())
    <section class="banner__section">
        <div class="top_banner_slider">
            @if(@$sliderAuto)
                <div id="six_images" class="owl-carousel">
                    @foreach ($sliderAuto as $auto)
                        <div class="item">
                            <div class="slider__img">
                                <img src="{{url($auto->image)}}" alt="img">
                                <div class="slider_content_main">
                                    <div class="inner__content_-wrap">
                                        <h1>{{$auto->title}}</h1>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @endif
            @if(@$sliders)
                <div class="clickable__tabs_btn carousel-clickable-tabs">
                    <ul class="nav nav-pills container" role="tablist">
                        @foreach($sliders as $key =>$slider)
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" data-bs-toggle="pill" data-bs-target="#go-online{{$key}}" type="button"
                                    role="tab" aria-controls="pills-home" aria-selected="false">
                                    <div class="tabButton_img">
                                        <img src="{{ url($slider->icon)}}" alt="img">
                                    </div>
                                    <h4>{{$slider->text}}</h4>
                                </button>
                            </li>
                        @endforeach
                    </ul>
                </div>
            @endif
        </div>
        @if(@$sliders)
            <div class="clickable__tabs">
                <div class="clickable__grid">
                    <div class="tab-content">
                        @foreach($sliders as $key =>$slider)
                            <div class="tab-pane fade  " id="go-online{{$key}}" role="tabpanel" aria-labelledby="pills-home-tab">
                                <div class="select__img">
                                    <img src="{{ url($slider->image)}}" alt="img">
                                </div>
                                <div class="container">
                                    <div class="inner__content_-wrap">
                                        <h1>{{$slider->title}}</h1>
                                        <div class="desc">
                                            <?=@$slider->description;?>
                                        </div>
                                        <div class="btn__list">
                                            @if(@$slider['SliderChild'])
                                                @foreach (@$slider['SliderChild'] as $child)
                                                    <a class="signUp_btn" href="{{@$child->button_link}}">{{$child->button_text}}</a>
                                                @endforeach
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                    <div class="clickable__tabs_btn">
                        <ul class="nav nav-pills container" role="tablist">
                            @foreach($sliders as $key =>$slider)
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" data-bs-toggle="pill" data-bs-target="#go-online{{$key}}" type="button"
                                        role="tab" aria-controls="pills-home" aria-selected="false">
                                        <div class="tabButton_img">
                                            <img src="{{ url($slider->icon)}}" alt="img">
                                        </div>
                                        <h4>{{$slider->text}}</h4>
                                    </button>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
        @endif
    </section>
@endif
{{-- ---------------------------------------------------------------------features------------------------------------------------------------------------------ --}}
@if (!$features->isEmpty())
    <section class="service__grid">
        <div class="container">
            <div class="service__box__list">
                <ul>
                    @foreach($features as $key =>$feature)
                        <li>
                            <div class="box__inner">
                                <div class="icon_img">
                                    <img src="{{ url($feature->image)}}" alt="img">
                                </div>
                                <h4>{{$feature->title}}</h4>
                            </div>
                        </li>
                    @endforeach
                </ul>
            </div>
        </div>
    </section>
@endif
{{-- ----------------------------------------------------------------------------integrated_supply---------------------------------------------------------- --}}
@if($integrated_supply)
    <section class="integrated__supply__grid">
        <div class="container">
            <div class="row">
                <div class="col-md-5">
                    <div class="supply-chain-content">
                        <h4><strong>{{@$integrated_supply->title_1}}</strong> {{@$integrated_supply->title_2}} </h4>
                        <div class="mobile__show">
                            <div class="supply-chain-image" data-aos="fade-up" data-aos-easing="ease-in-back"
                                data-aos-delay="300" data-aos-offset="0">
                                <div id="tilt">
                                    <img src="{{ url($integrated_supply->image)}}" alt="img">
                                </div>
                            </div>
                        </div>
                        <?=@$integrated_supply->description;?>
                        @if(@$integrated_supply->button_link && @$integrated_supply->button_text) <a class="sign__btn" href="{{@$integrated_supply->button_link}}">{{@$integrated_supply->button_text}}</a>@endif
                    </div>
                </div>
                <div class="col-md-7">
                    <div class="desktop__show">
                        <div class="supply-chain-image" data-aos="fade-up" data-aos-easing="ease-in-back"
                            data-aos-delay="300" data-aos-offset="0">
                            <div id="tilt">
                                <img src="{{ url($integrated_supply->image)}}" alt="img">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endif
{{-- -------------------------------------------------------------------------------------our_services------------------------------------------------- --}}
@if(!$our_services->isEmpty())
    <section class="our__services" id="services">
        <div class="container">
            <h4 class="service_title"><span><?=@$section_our_service->title_1?></span> <?=@$section_our_service->title_2?></h4>
            <div class="ourServices__box">
                <div class="row">
                    @foreach($our_services as $key =>$our_service)
                        <div class="col-md-4">
                            <div class="flip_box">
                                <div class="card flipped">
                                    <div class="front"
                                        style="background-image: linear-gradient(rgba(255, 255, 255, 0.8), rgba(255, 255, 255, 0.8)), url('{{$our_service->image_1}}');">
                                        <div class="fixed__box__title">
                                            <h4>{{$our_service->title}}</h4>
                                        </div>
                                        <div class="fixed__description">
                                            <?=@$our_service->description?>
                                        </div>
                                        <div class="fixed__read__more">
                                            <a class="signup_button" href="{{($our_service->button_link)?$our_service->button_link:'javascript:void(0)'}}">{{$our_service->button_text}}</a>
                                        </div>
                                    </div>
                                    <div class="back"
                                        style="background-image: linear-gradient(rgba(255, 255, 255, 0.8), rgba(255, 255, 255, 0.8)), url('{{$our_service->image_2}}');">
                                        <div class="service_card">
                                            <h4>{{$our_service->title}}</h4>
                                            <ul class="card_links">
                                                @foreach($our_service['HomeOurServiceChild'] as $key=> $our_service_child)
                                                    <li>
                                                        <a href="{{$our_service_child->link}}">
                                                            @if($our_service_child->icon)<span><img src="{{ asset($our_service_child->icon)}}" alt="img"></span>@endif
                                                            <span>{{$our_service_child->title}}</span>
                                                        </a>
                                                    </li>
                                                @endforeach
                                            </ul>
                                            <a class="signup_button" href="{{($our_service->button_link)?$our_service->button_link:'javascript:void(0);'}}">{{$our_service->button_text}}</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </section>
@endif
{{-- ------------------------------------------------------------------------industries-------------------------------------------------------- --}}
@if(!$industries->isEmpty())
    <section class="hexagon__wrap">
        <div class="container">
            <div class="industries__grid">
                <h4><?=@$section_industries->title_1?> <span><?=@$section_industries->title_2?></span></h4>
                <?=@$section_industries->description?>
            </div>
            <div class="hexagon__grid mobile__none">
                <ul>
                    <li> @php $i=1; @endphp
                        @foreach($industries as $key =>$industrie)
                           @if($i!=1 && $i!=3 && $i!=6) </li><li> @endif
                            <div class="hexagon__box">
                                <div class="hexagon">
                                    <div class="rect n-s"></div>
                                    <div class="rect nw-se"></div>
                                    <div class="rect sw-ne"></div>
                                </div>
                                <div class="hexagon__content">
                                    <div class="icon_div">
                                        <div class="half_cricle">
                                            <img class="blue__img" src="{{ asset('frontend/images/half_cricle.png')}}" alt="img">
                                            <img class="white__img" src="{{ asset('frontend/images/half_cricle_white.png')}}" alt="img">
                                        </div>
                                        <img class="hexagon__icon" src="{{ url($industrie->image)}}" alt="img">
                                    </div>
                                    <h4>{{$industrie->title}}</h4>
                                    <?=@$industrie->description?>
                                    <a class="readMore_btn" href="{{$industrie->button_link}}">{{$industrie->button_text}}</a>
                                </div>
                            </div>
                            @php $i++; @endphp
                        @endforeach
                    </li>
                </ul>
            </div>
            <div class="hexagon__grid ratangle_design hexagon_mobile desktop__none">
                <ul>
                    @foreach($industries as $key =>$industrie)
                        <li>
                            <div class="hexagon__box">
                                <div class="hexagon">
                                    <div class="rect n-s"></div>
                                    <div class="rect nw-se"></div>
                                    <div class="rect sw-ne"></div>
                                </div>
                                <div class="hexagon__content">
                                    <div class="icon_div">
                                        <div class="half_cricle">
                                            <img class="blue__img" src="{{ asset('frontend/images/half_cricle.png')}}" alt="img">
                                            <img class="white__img" src="{{ asset('frontend/images/half_cricle_white.png')}}" alt="img">
                                        </div>
                                        <img class="hexagon__icon" src="{{ url($industrie->image)}}" alt="img">
                                    </div>
                                    <h4>{{$industrie->title}}</h4>
                                    <?=@$industrie->description?>
                                    <a class="readMore_btn" href="{{$industrie->button_link}}">{{$industrie->button_text}}</a>
                                </div>
                            </div>
                        </li>
                    @endforeach
                </ul>
            </div>
        </div>
    </section>
@endif
{{-- ---------------------------------------------------------------------clouds------------------------------------------------ --}}
@if(!$clouds->isEmpty())
    <section class="counter__section">
        <div class="container">
            <div class="grid_row">
                <div class="left__grid">
                    <div class="counter_description">
                        <h4><?=@$section_cloud->title_1?> <span><?=@$section_cloud->title_2?></span></h4>
                        <?=@$section_cloud->description?>
                    </div>
                </div>
                <div class="right__grid">
                    <div class="counter_grid">
                        <ul id="counter">
                            @foreach($clouds as $key =>$cloud)
                                @php $number=$cloud->number;
                                    preg_match_all('!\d+\.*\d*!', $number, $matches);
                                    $val=$matches[0][0];
                                    $data=explode($val,$number);
                                @endphp
                                <li>
                                    <div class="counter_box" @if($cloud->image) style="background-image: url({{url($cloud->image)}});" @endif >
                                        <h4>{{$data[0]}} <span class="count percent" data-count="{{$val}}">0</span> {{$data[1]}}</h4>
                                        <p>{{$cloud->text}}</p>
                                    </div>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endif
{{-- ----------------------------------------------news----------------------------------------------------------- --}}
@if(!@$latest_news->isEmpty())
    <section class="news_section">
        <div class="container">
            <div class="title_grid">
                <h4><?=@$section_latest_news->title_1?> <span><?=@$section_latest_news->title_2?></span></h4>
                @if(@$section_latest_news->button_link && @$section_latest_news->button_text) <a class="view_more_cta" href="<?=@$section_latest_news->button_link?>"><?=@$section_latest_news->button_text?><span><img src="{{ asset('frontend/images/new_arrow.png')}}" alt="img"></span></a>@endif
            </div>
            <div class="row">
                @foreach($latest_news as $key =>$news)
                    <div class="col-md-4">
                        <div class="news_blog">
                            @if ($news->language!='en' && $news->default_language_page && @$news['DefaultLanguagePage']['post_slug'])
                                <a href="{{route('news.page.single',$news['DefaultLanguagePage']['post_slug'])}}">
                            @elseif($news->post_slug)
                                <a href="{{route('news.page.single',$news->post_slug)}}">
                            @else
                                <a href="">
                            @endif
                                <figure>
                                    @if ($news->media_type=='Image' && $news->image)
                                        <img src="{{ url($news->image)}}" alt="{{$news->post_title}}">
                                    @elseif($news->media_type=='Video')
                                        @if($news->video_type=='MP4' && $news->video)
                                            <video width="100%" height="100%" autoplay muted loop>
                                                <source src="{{ url($news->video)}}" type="video/mp4">
                                            </video>
                                        @elseif ($news->video_type=='Youtube' && $news->youtube)
                                            <iframe width="100%" height="100%" src="{{$news->youtube}}"></iframe>
                                        @endif
                                    @endif
                                    <figcaption>
                                        <h4>{{$news->post_title}}</h4>
                                        <p>{{$news['CreatedBy']['f_name']}} | <?=date('F d, Y',strtotime($news->created_at))?></p>
                                    </figcaption>
                                </figure>
                            </a>
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="mobile-show">
                @if(@$section_latest_news->button_link && @$section_latest_news->button_text) <a class="view_more_cta" href="<?=@$section_latest_news->button_link?>"><?=@$section_latest_news->button_text?><span><img src="{{ asset('frontend/images/new_arrow.png')}}" alt="img"></span></a>@endif
            </div>
        </div>
    </section>
@endif
{{-- -----------------------------------------------brand section--------------------------------------------------------------- --}}
@if(!$brands->isEmpty())
    <section class="gray_bg logo__slider">
        <div class="container">
            <h4 class="title_text"><?=@$section_brands->title_1?></h4>
            <div class="owl-carousel" id="client_slider">
                @foreach($brands as $brand)
                    <div class="item">
                        <div class="logo_slide">
                            @if($brand->link) <a href="{{$brand->link}}"> @endif <img src="{{ url($brand->logo)}}" alt="img"> @if($brand->link) </a> @endif
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>
@endif
{{-- --------------------------------------------------------------- customers_derive section-----------------------------------------------}}
@if(!$customers_derive->isEmpty())
    <section class="customer__grid">
        <div class="container">
            <div class="row">
                <div class="col-md-5">
                    <div class="customer__content">
                        <h4><span><?=@$section_customers_derive->title_1?> </span> <?=@$section_customers_derive->title_2?></h4>
                        @if(@$section_customers_derive->button_link && @$section_customers_derive->button_text) <a href="<?=@$section_customers_derive->button_link?>"><?=@$section_customers_derive->button_text?> </a> @endif
                    </div>
                </div>
                <div class="col-md-7">
                    <div class="slider_profile_wrap">
                        <div class="owl-carousel" id="profile__slider">
                            @foreach($customers_derive as $customer)
                                <div class="item">
                                    <div class="user__profile">
                                        <div class="profile__img">
                                            <img src="{{ url($customer->image)}}" alt="img">
                                        </div>
                                        <?=@$customer->description?>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endif
{{-- ----------------------------------------------------blog----------------------------------------------------------------------------- --}}
@if(!$blogs->isEmpty())
    <section class="news_section">
        <div class="container">
            <div class="title_grid">
                <h4><?=@$section_blogs->title_1?> <span></span></h4>
                @if(@$section_blogs->button_link && @$section_blogs->button_text) <a class="view_more_cta" href="<?=@$section_blogs->button_link?>"><?=@$section_blogs->button_text?> <span><img src="{{ asset('frontend/images/new_arrow.png')}}" alt="img"></span></a> @endif
            </div>
            <div class="row">
                @foreach($blogs as $key =>$blog)
                    <div class="col-md-4">
                        <div class="news_blog">
                            @if ($blog->language!='en' && $blog->default_language_page && @$blog['DefaultLanguagePage']['post_slug'])
                                <a href="{{route('post.page.single',$blog['DefaultLanguagePage']['post_slug'])}}">
                            @elseif($blog->post_slug)
                                <a href="{{route('post.page.single',$blog->post_slug)}}">
                            @else
                                <a href="">
                            @endif
                                <figure>
                                    @if ($blog->media_type=='Image' && $blog->image)
                                        <img src="{{ url($blog->image)}}" alt="img">
                                    @elseif($blog->media_type=='Video')
                                        @if($blog->video_type=='MP4' && $blog->video)
                                            <video width="100%" height="100%" autoplay muted loop>
                                                <source src="{{ url($blog->video)}}" type="video/mp4">
                                            </video>
                                        @elseif ($blog->video_type=='Youtube' && $blog->youtube)
                                            <iframe width="100%" height="100%" src="{{$blog->youtube}}"></iframe>
                                        @endif
                                    @endif
                                    <figcaption>
                                        <h4>{{$blog->post_title}}</h4>
                                        <p>{{$blog['CreatedBy']['f_name']}} | <?=date('F d, Y',strtotime($blog->created_at))?></p>
                                    </figcaption>
                                </figure>
                            </a>
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="mobile-show">
                @if(@$section_blogs->button_link && @$section_blogs->button_text) <a class="view_more_cta" href="<?=@$section_blogs->button_link?>"><?=@$section_blogs->button_text?> <span><img src="{{ asset('frontend/images/new_arrow.png')}}" alt="img"></span></a> @endif
            </div>
        </div>
    </section>
@endif
@endsection
@section('script')
<script>
    window.addEventListener('load', function() {
        @if (session('status'))
            AlertMassage("{{ session('status') }}");
        @endif
        @if (Session::has('message'))
            AlertMassage("{{ Session::get('message') }}");
        @endif
        @if (Session::has('popupImage'))
            $('#modal-loader').modal('hide');
            $('#model-alert-image').modal('show');
        @endif
    });
</script>
@endsection
