@php
$meta_title = $industries->meta_title;
$meta_description = $industries->meta_description;
$meta_keywords =  $industries->meta_key;
$footer_sign_up_for_free_trial=true;
@endphp
@extends('frontend.user.includes.master')
@section('body')
<section class="sub__banner__grid inner_page freight_page_grid <?=(@$industries->title && @$industries->sub_title )?'':'one-line-text-box' ?>">
    <div class="sub__banner__img">
        <img src="{{url($industries->banner_image)}}" alt="img">
    </div>
    <div class="sub_banner_wrap">
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <div class="sub_baaner_content">
                        <h1>{{$industries->title}}</h1>
                        <p>{{$industries->sub_title}}</p>
                        <div class="sign_up_trial">
                            @if(@$industries->button_link && @$industries->button_text) <a class="btn_cta" href="<?=@$industries->button_link ?>"><?=@$industries->button_text ?></a>@endif
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="banner__box_wrap">
                        <div class="service_box_cta">
                            <ul>
                                @foreach($industries_service as $service)
                                    <li>
                                        <div class="border_line">
                                            <div class="service_box_icon"><img src="<?=url(@$service->image) ?>" alt="alt"></div>
                                            <div class="service_box_title">
                                                <p>{{$service->title}}</p>
                                            </div>
                                        </div>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</section>

<section class="video__wrap freight_page_video">
    <div class="video_grid middle-bg">
        @if(@$industries->media_type=='Image' && $industries->image)
            <img src="{{url($industries->image)}}" alt="infograph">
        @elseif(@$industries->media_type=='Video')
            @if($industries->video_type=='MP4' && $industries->video && $industries->thumbnail_image)
                <video  id="myVideo" poster="{{ url($industries->thumbnail_image)}}" >
                    <source src="{{ url($industries->video)}}" type="video/mp4">
                </video>
                <div class="content">
                    <button id="myBtn" onclick="myFunction()"><i class="fas fa-play"></i></button>
                </div>
            @elseif ($industries->video_type=='Youtube' && $industries->youtube)
                <iframe width="100%" height="100%" src="{{$industries->youtube}}"></iframe>
            @endif
        @endif
    </div>
    <div class="urve_design"></div>
</section>

<section class="Aurobees__border_content">
    <div class="container">
        <?=@$industries->description ?>
        <div class="sign_up_trial">
            @if(@$industries->button_link && @$industries->button_text) <a class="btn_cta" href="<?=@$industries->button_link ?>"><?=@$industries->button_text ?></a>@endif
        </div>
    </div>
</section>

<section class="key__offering">
    <div class="">
        <div class="offer_title">
            <h4><span><?=@$industries->key_offerings_text ?></span></h4>
        </div>

        <div class="swiper-container two">
            <div class="swiper-wrapper">
                @foreach($industries_key_offerings as $key_offerings)
                    <div class="swiper-slide">
                        <div class="offering_box">
                            <div class="offering_box_title">
                                <h4><?=@$key_offerings->title ?></h4>
                            </div>
                            <div class="offering_box_img">
                               <img src="{{url($key_offerings->image)}}" alt="image">
                            </div>
                            <div class="offering_box_desc">
                                <?=@$key_offerings->description ?>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="swiper-pagination"></div>
        </div>

    </div>
</section>
@endsection
@section('script')
<script>
    var swiper = new Swiper('.swiper-container.two', {
        pagination: '.swiper-pagination',
        paginationClickable: true,
        autoplay: 2000,
        effect: 'coverflow',
        loop: true,
        centeredSlides: true,
        slidesPerView: '3',
        coverflow: {
            rotate: 0,
            stretch: 100,
            depth: 251,
            modifier: 1,
            slideShadows: true,
        },
        breakpoints: {
            650: {
                slidesPerView: 1
            },
            1200: {
                slidesPerView: 2
            },
            1280: {
                slidesPerView: 3,
                coverflow: {
                    rotate: 0,
                    stretch: 100,
                    depth: 162,
                    modifier: 1,
                    slideShadows: true,
                },
            },
            1366: {
                slidesPerView: 3,
                coverflow: {
                    rotate: 0,
                    stretch: 100,
                    depth: 220,
                    modifier: 1,
                    slideShadows: true,
                },
            }
        }
    });
</script>
@endsection
