@php
$meta_title = $data->meta_title;
$meta_description = $data->meta_description;
$meta_keywords =  $data->meta_key;
$footer_sign_up_for_free_trial=true;
$add_class_header='show-nav';
if($data->language!='en' && $data->default_language_page){
    $data->id=$data->default_language_page;
    $data->post_slug=$data['DefaultLanguagePage']['post_slug'];
}
@endphp
@extends('frontend.user.includes.master')
@section('body')
    <section class="blog_section single_blog_article">
        <div class="container">
            <div class="blog_article_full">
                <h1>{{$data->post_title}}</h1>
                <div class="blog_article_full_img">
                    @if ($data->media_type=='Image' && $data->image)
                        <img src="{{ url($data->image)}}"  alt="{{$data->post_title}}" title="{{$data->post_title}}">
                    @elseif($data->media_type=='Video')
                        @if($data->video_type=='MP4' && $data->video)
                            <video width="100%" height="100%" autoplay muted loop>
                                <source src="{{ url($data->video)}}" type="video/mp4">
                            </video>
                        @elseif ($data->video_type=='Youtube' && $data->youtube)
                            <iframe width="100%" height="100%" src="{{$data->youtube}}"></iframe>
                        @endif
                    @endif
                </div>
                <div class="blog_footer">
                    <div class="blog___title">
                        <strong>{{$data->location}}</strong>
                        <span><?=date('F d, Y',strtotime($data->created_at))?></span>
                    </div>
                    <div class="blog___title__red">
                       @php $word_count= str_word_count(@$data->post_content);
                            $time=ceil($word_count/100);
                            echo $time." min read";
                       @endphp
                    </div>
                </div>
            </div>

            <div class="post_article_description">
                <?=@$data->post_content ?>
            </div>

            <div class="social_strip">
                <ul>
                    <li><a href="https://twitter.com/intent/tweet?text={{$data->post_title}}&url={{route('post.page.single', $data->post_slug)}}" target="_blank"><i class="fab fa-twitter"></i></a></li>
                    <li><a href="https://www.linkedin.com/shareArticle?url={{route('post.page.single', $data->post_slug)}}&title={{$data->post_title}}" target="_blank"><i class="fab fa-linkedin-in"></i></a></li>
                    <li><a href="https://www.facebook.com/sharer/sharer.php?u={{route('post.page.single', $data->post_slug)}}&title={{$data->post_title}}" target="_blank"><i class="fab fa-facebook-f"></i></a></li>
                    <li><a href="javascript:void(0);" onclick="copyLink('{{route('post.page.single', $data->post_slug)}}')"><i class="fas fa-link"></i></a></li>
                </ul>
            </div>

            <div class="comments__grid">
                <div class="view_comment">
                    <a href="javascript:void(0);">{{$data->total_post_view}} {{ HelperServiceProvider::GetLanguageText('view')}}</a>
                    <a href="javascript:void(0);">{{(@$comments)?sizeof(@$comments):'0'}} {{ HelperServiceProvider::GetLanguageText('comment')}}</a>
                </div>
                <div class="comments__line">
                    <form action="post" id="comment-form">
                        @csrf
                        <input type="hidden" name="token" value="{{$data->id}}">
                        <input type="text" name="comment" id="comment" placeholder="{{ HelperServiceProvider::GetLanguageText('write_a_comment')}}" >
                        <button type="submit" class="btn btn-success">{{ HelperServiceProvider::GetLanguageText('submit')}}</button>
                    </form>
                </div>
                @if(@$comments)
                    <div class="user_comment_list">
                        @foreach (@$comments as $comment)
                            <div class="user_comment_inner">
                                <div class="user_img">
                                    <img src="{{ asset('frontend/images/user-image.png')}}" alt="img">
                                </div>
                                <div class="user_comment_content">
                                    <h4>{{@$comment['name']}} <span>{{@$comment['time']}} </span></h4>
                                    <?=@$comment['comment']?>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @endif
            </div>

            <div class="blog_article_post">
                <div class="read_more">
                    <h2 class="read_btn">{{ HelperServiceProvider::GetLanguageText('read_more')}}</h2>
                </div>
                <div class="row">
                    @foreach ($datas as $post )
                        @php
                        if($post->language!='en' && $post->default_language_page){
                            $post->id=$post->default_language_page;
                            $post->post_slug=$post['DefaultLanguagePage']['post_slug'];
                        }
                        @endphp
                        <div class="col-md-6">
                            <div class="post_blog_wrap">
                                <div class="post_blog_img">
                                    <a href="{{route('post.page.single', $post->post_slug)}}">
                                        @if ($post->media_type=='Image' && $post->image)
                                            <img src="{{ url($post->image)}}"  alt="{{$post->post_title}}" title="{{$post->post_title}}">
                                        @elseif($post->media_type=='Video')
                                            @if($post->video_type=='MP4' && $post->video)
                                                <video width="100%" height="100%" autoplay muted loop>
                                                    <source src="{{ url($post->video)}}" type="video/mp4">
                                                </video>
                                            @elseif ($post->video_type=='Youtube' && $post->youtube)
                                                <iframe width="100%" height="100%" src="{{$post->youtube}}"></iframe>
                                            @endif
                                        @endif
                                    </a>
                                </div>

                                <div class="post_blog_">
                                    <h4><a href="{{route('post.page.single', $post->post_slug)}}">{{$post->post_title}}</a></h4>
                                    <div class="like_heart">
                                        <a href="javascript:void(0)" @if(Auth::user()) onclick="addLike(this ,{{$post->id}})" @endif ><i class="@if(Auth::user()) {{HelperServiceProvider::CheckUserLike($post->id)}}  @else far fa-heart @endif "></i></a><span>{{HelperServiceProvider::PostLikeCount($post->id)}}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </section>
@endsection
@section('script')
<script>
    function copyLink(link) {
      var tempInput = document.createElement('input');
      tempInput.value = link;
      document.body.appendChild(tempInput);
      tempInput.select();
      document.execCommand('copy');
      document.body.removeChild(tempInput);
    }

    //post like
    function addLike(th, token) {
        var $icon = $(th).find('i');
        var like=0;
        if ($icon.hasClass('fas fa-heart')) {
            $icon.removeClass('fas fa-heart').addClass('far fa-heart');
            like=0;
        } else {
            $icon.removeClass('far fa-heart').addClass('fas fa-heart');
            like=1;
        }

        $.ajax({
            url: "{{route('post-data-add-like')}}",
            type: "POST",
            data: { _token : "<?php echo csrf_token() ?>", like: like,id: token },
            async: false,
            success: function(response) {
                var $span = $(th).next('span');
                $span.text(response);
            }
        });
    }

    //post comment
    jQuery('#comment-form').validate({
        rules: {
            token: {
                required: true,
                digits: true
            },
            comment: {
                required: true
            }
        },
        // Specify validation error messages
        messages: {
            comment: "Please write a comment..."
        },
        submitHandler: function() {
            // Serialize the form data
            var formData = $('#comment-form').serialize();
            $('#modal-loader').modal('show');
            // Send an AJAX request to submit the form data
            $.ajax({
                type: "POST",
                url: "{{route('post-data-add-comment')}}",
                data: formData,
                success: function(response) {
                    $('#modal-loader').modal('hide');
                    console.log(response);
                    $('#comment').val('');
                    AlertMassage(response);
                    $('#modal-loader').modal('hide');
                },
                error: function(xhr, status, error) {
                    // Handle the error response
                    console.log(error);
                }
            });
        }
    });
</script>
@endsection
