<!DOCTYPE html>
<html lang="en">

<head>
    <meta name="robots" content="noindex, nofollow" />
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo e(@$meta_title?@$meta_title:'Aurobees'); ?></title>
    <meta name="description" content="<?php echo e(@$meta_description?@$meta_description:'Aurobees'); ?>" />
    <meta name="keywords" content="<?php echo e(@$meta_keywords?@$meta_keywords:'Aurobees'); ?>" />
	<link rel="icon" href="<?php echo e(url('frontend/images/favicon.png')); ?>" type="image/png" sizes="64x64">
	<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700;900&display=swap" rel="stylesheet">

	<!-- bootstrap link -->
	<link rel="stylesheet" type="text/css" href="<?php echo e(asset('frontend/css/bootstrap.min.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('frontend/css/owl.carousel.min.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('frontend/css/owl.theme.default.min.css')); ?>">
	<link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">

	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.3/css/select2.min.css">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/flag-icon-css/2.8.0/css/flag-icon.min.css">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.13/css/intlTelInput.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/Swiper/3.4.1/css/swiper.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
	<!-- custom css -->
	<link rel="stylesheet" type="text/css" href="<?php echo e(asset('frontend/css/style.css')); ?>">
	<link rel="stylesheet" type="text/css" href="<?php echo e(asset('frontend/css/responsive.css')); ?>">
	<style>

	    #loader {
            position: fixed;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(255, 255, 255, 0.4);
            z-index: 9999999;

        }

        .loader {
            width: 100%;
            height: 100%;
            position: absolute;
            left: 0;
            top: 0;
            bottom: 0;
            right: 0;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .loader img {
            width: 200px
        }

	</style>
</head>

<body>

    <div id="loader">
        <div class="loader">
              <img src="<?php echo e(url('img/Loading_icon.gif')); ?>" alt="Logo">
        </div>
    </div>
	<div class="wrapper">

        <?php echo $__env->make('frontend.user.includes.body.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->yieldContent('body'); ?>
        <?php echo $__env->make('frontend.user.includes.body.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

	</div>

    <script src="<?php echo e(asset('frontend/js/jquery.min.js')); ?>"></script>
    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.13/js/intlTelInput-jquery.min.js"></script>
    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>

	<script src="<?php echo e(asset('frontend/js/owl.carousel.js')); ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"></script>
	<script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Swiper/3.4.1/js/swiper.min.js"></script>
    <script type="text/javascript">
        function languagePickerSelect(value){
            var ur_model = "<?php echo e(route('changeLang')); ?>";
            window.location.href = ur_model + "?lang="+value;
        }
    </script>
	<script src="<?php echo e(asset('frontend/js/custom.js')); ?>"></script>

    <script>
        function AlertMassage(data){
            $('#model-alert-massage-text').html(data);
            $('#modal-loader').modal('hide');
            $('#model-alert-massage').modal('show');
        }
    </script>
    <?php echo $__env->yieldContent('script'); ?>

    <script>
        //email
        jQuery(document).on('keypress', '#email', function(event) {
            var regex = new RegExp("^[a-zA-Z.0-9.@]+$");
            var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
            if (!regex.test(key)) {
                event.preventDefault();
                return false;
            }
        });
		var counted = 0;
		$(window).scroll(function () {
            var element = document.getElementById('counter');
            if (element) {
                var oTop = $('#counter').offset().top - window.innerHeight;
                if (counted == 0 && $(window).scrollTop() > oTop) {
                    $('.count').each(function () {
                        var $this = $(this),
                            countTo = $this.attr('data-count');
                        $({
                            countNum: $this.text()
                        }).animate({
                            countNum: countTo
                        },
                        {
                            duration: 2000,
                            easing: 'swing',
                            step: function () {
                                $this.text(Math.floor(this.countNum));
                            },
                            complete: function () {
                                $this.text(this.countNum);
                            }

                        });
                    });
                    counted = 1;
                }
            }
		});
	</script>
    
    <script>
        window.addEventListener('load', function() {
            var loader = document.getElementById('loader');
            loader.style.display = 'none'; // Hide the loader when the page is fully loaded
        });
    </script>

    <script>window.$zoho=window.$zoho || {};$zoho.salesiq=$zoho.salesiq||{ready:function(){}}</script><script id="zsiqscript" src="https://salesiq.zohopublic.com/widget?wc=siq117c5d302f5d39d06d151dccf89e83252aa38243f44457ca5b5a94ada8385f0f" defer></script>
</body>

</html>



<?php /**PATH /var/www/html/aurobees/resources/views/frontend/user/includes/master.blade.php ENDPATH**/ ?>