<?php
$meta_title = 'Aurobees | Billing';
$meta_description = '';
$meta_keywords = '';
$add_class_header='show-nav';
$footer_sign_up_for_free_trial=true;
$active_page='customer-billing';
?>

<?php $__env->startSection('body'); ?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
<div class="dashboard_bg">
    <section class="usr_dashboard_user">
        <div class="container">
            <div class="row">
                <div class="col-md-3"></div>
                <div class="col-md-9">
                    <div class="usr_dashboard_title">
                        <h1>Billing</h1>
                        <div class="d-flex">
                            <div class="log_out_btn">
                                <a href="javascript:void(0);" onclick="$('#logout-form').submit();">Log Out</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-3">
                    <?php echo $__env->make('frontend.customer.includes.body.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="col-md-9">
                    <div class="scroll_screen">
                        <div class="dashboard_right dashboard_subscriptions">
                            <?php if(!$datas->isEmpty()): ?>
                                <div class="data_table_wrap">
                                    <div class="table__strip">
                                        <div class="total_record">
                                            <div class="check_input">
                                                <input type="checkbox">
                                                <label for="">Total Records <?php if($datas): ?><span>
                                                        <?= @sizeof($datas) ?>
                                                    </span><?php endif; ?> </label>
                                            </div>
                                        </div>
                                        <div class="download__list">
                                            <a href="<?php echo e(route('customer.billing.excel')); ?>">Download</a>
                                        </div>
                                    </div>
                                    <table id="DataTable" class="table table-striped nowrap">
                                        <thead>
                                            <tr>
                                                <th>No</th>
                                                <th>Subscribe Billing No</th>
                                                <th>LOB Name</th>
                                                <th>LOB Type</th>
                                                <th>LOB Plan</th>
                                                <th>User</th>
                                                <th>Form Date</th>
                                                <th>Due Date</th>
                                                <th>Amount</th>
                                                <th>Status</th>
                                                <th>Paid Date</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php if(!$datas->isEmpty()): ?>
                                            <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td>
                                                    <div class="check_input">
                                                        <input type="checkbox">
                                                        <label for=""><?php echo e($key + 1); ?></label>
                                                    </div>
                                                </td>
                                                <td><?php echo e($data->serial_number); ?></td>
                                                <td><?php echo e($data['Pricing']['LOB']['title']); ?></td>
                                                <td><?= @$data->plan_name ?></td>
                                                <?php if($data->plan_duration=='YLY'){ $plan_duration=365; }elseif($data->plan_duration=='QTR'){ $plan_duration=90; }elseif($data->plan_duration=='MTH'){ $plan_duration=30; }else{ $plan_duration=15; } ?>
                                                <td><?=$plan_duration?> Days</td>
                                                <td><?=(@$data->plan_name=='Ecommerce')?1:@$data->quantity ?></td>
                                                <td><?php echo e($data->start_at); ?></td>
                                                <td><?php echo e($data->end_at); ?></td>
                                                <td><?php echo e($data->currency_code.' '. number_format($data->grand_amount, 2)); ?>

                                                </td>
                                                <td>
                                                    <?php if($data->plan_name=='Free-Trial'): ?> Upgrade <?php elseif($data->plan_name!='Free-Trial' && $data->status=='Active'): ?> Paid <?php else: ?> <?php echo e($data->status); ?> <?php endif; ?>
                                                    
                                                    <?php $currentDate = date('Y-m-d H:i:s');
                                                    $featureDate = date('Y-m-d H:i:s', strtotime($currentDate . ' + ' . $subscription_upgrade_days . 'days')); ?>
                                                    <?php if($data->upgrade_status =='0' && $data->plan_name=='Free-Trial'): ?>
                                                        <p>If you want to upgrade to paid version, Kindly <a href="javascript:void(0);" onclick="subscriptionUpgrade('<?php echo e(Crypt::encrypt($data->id)); ?>');">Upgrade now</a></p>
                                                    <?php elseif($featureDate>=$data->end_at && $data->upgrade_status =='0' &&
                                                        $data->status=='Active' && $data->plan_name!='Free-Trial'): ?>
                                                        <p style="min-width:55px;"><a href="javascript:void(0);" onclick="subscriptionPay('<?php echo e(Crypt::encrypt($data->id)); ?>');">Renew</a></p>
                                                    <?php elseif($data->payment_mode=='auropay' && $data->status=='Pending'): ?>
                                                        <p style="min-width:55px;"><a href="<?php echo e(route('customer.subscription.payment.auropay',Crypt::encrypt($data->id))); ?>">Pay now</a></p>
                                                    <?php endif; ?>
                                                </td>
                                                <td><?php echo e($data->start_at); ?></td>
                                                <td>
                                                    <a href="javascript:void(0);" onclick="viewDetailBilling('<?php echo e(route('customer.billing.show',Crypt::encrypt($data->id))); ?>');"><i id="eyeIcon_table" class="fa fa-eye"></i></a>
                                                    <a href="<?php echo e(route('customer.billing.pdf',Crypt::encrypt($data->id))); ?>"><img width="15" src="<?php echo e(url('frontend/images/download-icon1.png')); ?>" alt="img"></a>
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php echo $__env->make('frontend.customer.includes.body.help-center-mobile', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </section>
</div>

<div class="modal fade" id="exampleModalLong" tabindex="-1" role="dialog" aria-labelledby="exampleModalLongTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle">Billing Details</h5>
                <button type="button" class="close" onclick="$('#exampleModalLong').modal('hide');" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body add-subscription-data">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary"
                    onclick="$('#exampleModalLong').modal('hide');">Close</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="subscription-upgrade" tabindex="-1" role="dialog" aria-labelledby="subscription-upgrade"
    aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-body add-subscription-upgrade-html">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary"
                    onclick="$('#subscription-upgrade').modal('hide');">Close</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="subscription-pay" tabindex="-1" role="dialog" aria-labelledby="subscription-pay" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered " role="document">
        <div class="modal-content">
            <div class="modal-header"></div>
            <div class="modal-body add-subscription-pay-html">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="$('#subscription-pay').modal('hide');">Close</button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script>
    window.addEventListener('load', function () {
        <?php if(Session:: has('message')): ?>
    AlertMassage(`<?= Session::get('message') ?>`);
    <?php endif; ?>
    });
</script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script>
    $(document).ready(function () {
        $('.data_table_wrap .dataTables_wrapper table').wrap('<div class="scroll_table" />');
    });
    new DataTable('#DataTable', {});
    function viewDetailBilling(url) {
        $.ajax({
            type: "GET",
            url: url,
            success: function (response) {
                $('.add-subscription-data').html(response);
                $('#exampleModalLong').modal('show');
            },
            error: function (xhr, status, error) {
                AlertMassage(`<?php echo e(\App\Providers\MessageManagementProvider::MessageManage('customer-profile-something-wrong')); ?>`);
            }
        });
    }
    function subscriptionUpgrade(token) {
        $.ajax({
            type: "GET",
            url: "<?php echo e(route('customer.subscription.upgrade')); ?>",
            data: { 'token': token },
            success: function (response) {
                if (response) {
                    $('.add-subscription-upgrade-html').html(response);
                    $('#subscription-upgrade').modal('show');
                } else {
                    AlertMassage(`<?php echo e(\App\Providers\MessageManagementProvider::MessageManage('customer-profile-something-wrong')); ?>`);
                }
            },
            error: function (xhr, status, error) {
                AlertMassage(`<?php echo e(\App\Providers\MessageManagementProvider::MessageManage('customer-profile-something-wrong')); ?>`);
            }
        });
    }
    function subscriptionPay(token) {
        $.ajax({
            type: "GET",
            url: "<?php echo e(route('customer.subscription.pay.popup')); ?>",
            data: { 'token': token },
            success: function (response) {
                if (response) {
                    $('.add-subscription-pay-html').html(response);
                    $('#subscription-pay').modal('show');
                } else {
                    AlertMassage(`<?php echo e(\App\Providers\MessageManagementProvider::MessageManage('customer-profile-something-wrong')); ?>`);
                }
            },
            error: function (xhr, status, error) {
                AlertMassage(`<?php echo e(\App\Providers\MessageManagementProvider::MessageManage('customer-profile-something-wrong')); ?>`);
            }
        });
    }
    
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.user.includes.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/aurobees/resources/views/frontend/customer/billing/index.blade.php ENDPATH**/ ?>