<?php
$meta_title = 'Aurobees | Subscription';
$meta_description = '';
$meta_keywords = '';
$add_class_header='show-nav';
$footer_sign_up_for_free_trial=true;
$active_page='customer-subscription';
?>

<?php $__env->startSection('body'); ?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css">
<div class="dashboard_bg">
    <section class="usr_dashboard_user">
        <div class="container">
            <div class="row">
                <div class="col-md-3"></div>
                <div class="col-md-9">
                    <div class="usr_dashboard_title">
                        <h1>Subscriptions</h1>
                        <div class="d-flex">
                            <div class="log_out_btn">
                                <a href="javascript:void(0);" onclick="$('#logout-form').submit();">Log Out</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-3">
                    <?php echo $__env->make('frontend.customer.includes.body.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="col-md-9">
                    <div class="scroll_screen">
                        <div class="dashboard_right ">
                            <?php if(!$datas->isEmpty()): ?>
                            <div class="data_table_wrap">
                                <table id="DataTable" class="table table-striped nowrap">
                                    <thead>
                                        <tr>
                                            <th>Sr No.</th>
                                            <th>Subscriptions BOB Type</th>
                                            <th>Subscriptions Type</th>
                                            <th>Subscriptions Plan</th>
                                            <th>No of Users</th>
                                            <th>Email</th>
                                            <th colspan="2">Subscription</th>
                                            <th>Subscription Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if(!$datas->isEmpty()): ?>
                                        <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($key + 1); ?></td>
                                            <td><?php echo e($data['Pricing']['LOB']['title']); ?></td>
                                            <td><?= @$data->plan_name ?></td>
                                            <?php if($data->plan_duration=='YLY'){ $plan_duration=365; }elseif($data->plan_duration=='QTR'){ $plan_duration=90; }elseif($data->plan_duration=='MTH'){ $plan_duration=30; }else{ $plan_duration=15; } ?>
                                            <td><?=$plan_duration?> Days</td>
                                            <td><?=(@$data->plan_name=='Ecommerce')?1:@$data->quantity ?></td>
                                            <?php $email=''; ?>
                                            <?php if($data['OrderMeta']): ?>
                                                <?php $__currentLoopData = $data['OrderMeta']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($item->key=='email'): ?>
                                                        <?php $email=$item->value; ?>
                                                        <?php break; ?>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                            <td><?php echo e($email); ?></td>
                                            <td><?php echo e($data->start_at); ?></td>
                                            <td><?php echo e($data->end_at); ?></td>
                                            <td>
                                                <?php $currentDate=date('Y-m-d H:i:s'); echo ($data->status=='Active' && $data->end_at<$currentDate)?'Expired':@$data->status ?>
                                                <?php $featureDate= date('Y-m-d H:i:s', strtotime($currentDate. ' + '.$subscription_upgrade_days .'days')); ?>
                                                <?php if($data->upgrade_status =='0' && $data->plan_name=='Free-Trial'): ?>
                                                    <p>If you want to upgrade to paid version, Kindly <a href="javascript:void(0);" onclick="subscriptionUpgrade('<?php echo e(Crypt::encrypt($data->id)); ?>');">Upgrade now</a></p>
                                                <?php elseif($featureDate>=$data->end_at && $data->upgrade_status =='0' && $data->status=='Active' && $data->plan_name!='Free-Trial'): ?>
                                                    <p>
                                                        <?=($data->status=='Active' && $data->end_at<$currentDate)?'If you want to paid version, Kindly ':''?>
                                                        <a href="javascript:void(0);" onclick="subscriptionPay('<?php echo e(Crypt::encrypt($data->id)); ?>');">Pay now</a>
                                                    </p>
                                                <?php elseif($data->payment_mode=='auropay' && $data->status=='Pending'): ?>
                                                    <a href="<?php echo e(route('customer.subscription.payment.auropay',Crypt::encrypt($data->id))); ?>">Pay now</a>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php echo $__env->make('frontend.customer.includes.body.help-center-mobile', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </section>
</div>

<div class="modal fade" id="subscription-upgrade" tabindex="-1" role="dialog" aria-labelledby="subscription-upgrade"
    aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-body add-subscription-upgrade-html">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary"
                    onclick="$('#subscription-upgrade').modal('hide');">Close</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="subscription-pay" tabindex="-1" role="dialog" aria-labelledby="subscription-pay" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered " role="document">
        <div class="modal-content">
            <div class="modal-header"></div>
            <div class="modal-body add-subscription-pay-html">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="$('#subscription-pay').modal('hide');">Close</button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script>
    window.addEventListener('load', function () {
        <?php if(Session:: has('message')): ?>
    AlertMassage(`<?= Session::get('message') ?>`);
    <?php endif; ?>
    });
</script>
<script>
    $(document).ready(function () {
        $('.data_table_wrap .dataTables_wrapper table').wrap('<div class="scroll_table" />');
        setTimeout(() => {
            $('select[name="DataTable_length"]').change().val(10)
        }, 1000);
    });
    new DataTable('#DataTable');
    function subscriptionUpgrade(token) {
        $.ajax({
            type: "GET",
            url: "<?php echo e(route('customer.subscription.upgrade')); ?>",
            data: { 'token': token },
            success: function (response) {
                if (response) {
                    $('.add-subscription-upgrade-html').html(response);
                    $('#subscription-upgrade').modal('show');
                } else {
                    AlertMassage(`<?php echo e(\App\Providers\MessageManagementProvider::MessageManage('customer-profile-something-wrong')); ?>`);
                }
            },
            error: function (xhr, status, error) {
                AlertMassage(`<?php echo e(\App\Providers\MessageManagementProvider::MessageManage('customer-profile-something-wrong')); ?>`);
            }
        });
    }
    function subscriptionPay(token) {
        $.ajax({
            type: "GET",
            url: "<?php echo e(route('customer.subscription.pay.popup')); ?>",
            data: { 'token': token },
            success: function (response) {
                if (response) {
                    $('.add-subscription-pay-html').html(response);
                    $('#subscription-pay').modal('show');
                } else {
                    AlertMassage(`<?php echo e(\App\Providers\MessageManagementProvider::MessageManage('customer-profile-something-wrong')); ?>`);
                }
            },
            error: function (xhr, status, error) {
                AlertMassage(`<?php echo e(\App\Providers\MessageManagementProvider::MessageManage('customer-profile-something-wrong')); ?>`);
            }
        });
    }
     
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.user.includes.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/aurobees/resources/views/frontend/customer/subscription/index.blade.php ENDPATH**/ ?>