<?php
$meta_title = 'Aurobees | Dashboard';
$meta_description = '';
$meta_keywords = '';
$add_class_header='show-nav';
$footer_sign_up_for_free_trial=true;
$active_page='customer-account-profile';
?>

<?php $__env->startSection('body'); ?>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.3/js/select2.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.13/js/intlTelInput-jquery.min.js"></script>
<div class="dashboard_bg">
    <section class="usr_dashboard_user">
        <div class="container">
            <div class="row">
                <div class="col-md-3"></div>
                <div class="col-md-9">
                    <div class="usr_dashboard_title">
                        <h1>ACCOUNT PROFILE</h1>
                        <div class="d-flex">
                            <div class="log_out_btn">
                                <a href="javascript:void(0);" onclick="$('#logout-form').submit();">Log Out</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-3">
                    <?php echo $__env->make('frontend.customer.includes.body.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="col-md-9">
                    <div class="scroll_screen">
                        <div class="dashboard_right">
                            <div class="dashboard_top_strip">
                                <div class="d-flex">
                                    <div class="status_pro">
                                        <form id="uploadForm">
                                            <?php echo csrf_field(); ?>
                                            <input type="file" name="photo" id="photo" style="display: none"
                                                accept=".png, .jpg, .jpeg">
                                            <div class="user_profile_img">
                                                <img src="<?php echo e((!empty(Auth::user()->profile_photo_path))? url(Auth::user()->profile_photo_path):url('img/dummy.png')); ?>"
                                                    id="photoImage" alt="User Image">
                                            </div>
                                            <div class="edit_remove_link">
                                                <a href="javascript:void(0);" onclick="uploadPhoto();">Update</a>
                                                <?php if(!empty(Auth::user()->profile_photo_path)): ?> <a href="javascript:void(0);" onclick="removePhoto();">Remove</a><?php endif; ?>
                                               
                                            </div>
                                        </form>
                                    </div>
                                    <div class="user_profile_content">
                                        <h4><a href="javascript:void(0);"><?php echo e(Auth::user()->f_name.'
                                                '.Auth::user()->l_name); ?></a></h4>
                                        <h5><?php echo e(Auth::user()->code); ?></h5>
                                        <h6><a href="javascript:void(0);"><img
                                                    src="<?php echo e(url('frontend/images/location-img.svg')); ?>" alt="img">
                                                <?php echo e(Auth::user()->address); ?></a></h6>
                                        <div class="border_description">
                                            <form id="edit_bio" name="update-bio">
                                                <?php echo csrf_field(); ?>
                                                <textarea name="bio" class="form-control edit-bio"
                                                    id="textarea-edit-bio"><?= @$data->bio ?></textarea>
                                                <a href="javascript:void(0);" class="update-bio-button"
                                                    onclick="updateBio();">Update</a>
                                                <a href="javascript:void(0);" class="edit-bio-button"
                                                    onclick="editBio();">Edit</a>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                <div class="Profile__completion__status">
                                    <h2>Profile Completion Status</h2>
                                    <div class="progress">
                                        
                                        <?php
                                        $profileStatus=25;
                                        if(!empty(Auth::user()->profile_photo_path)){$profileStatus+=10;}
                                        if(@$data->bio){$profileStatus+=10;}
                                        if(@$data->designation){$profileStatus+=10;}
                                        if(@$data->industry){$profileStatus+=5;}
                                        if(@$data->billing_city){$profileStatus+=20;}
                                        if(@$data->gst_number ||@$data->pan_number ||@$data->trn_number
                                        ||@$data->acra_number ||@$data->npwp_number
                                        ||@$data->company_registration_number){$profileStatus+=20;}
                                        ?>
                                        <input type="hidden" id="default-value" class="progress-data" value="25">
                                        <input type="hidden" id="profile-photo-value" class="progress-data"
                                            value="<?= (!empty(Auth::user()->profile_photo_path)) ? 10 : 0 ?>">
                                        <input type="hidden" id="bio-value" class="progress-data"
                                            value="<?= (@$data->bio) ? 10 : 0 ?>">
                                        <input type="hidden" id="company-information-value" class="progress-data"
                                            value="<?= (@$data->industry) ? 5 : 0 ?>">
                                        <input type="hidden" id="authorised-user-value" class="progress-data"
                                            value="<?= (@$data->designation) ? 10 : 0 ?>">
                                        <input type="hidden" id="billing-information-value" class="progress-data"
                                            value="<?= (@$data->billing_city) ? 20 : 0 ?>">
                                        <input type="hidden" id="documents-value" class="progress-data"
                                            value="<?= (@$data->gst_number || @$data->pan_number || @$data->trn_number || @$data->acra_number || @$data->npwp_number || @$data->company_registration_number) ? 20 : 0 ?>">
                                        
                                        <div class="progress-done" data-done="<?php echo e(@$profileStatus); ?>"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab_grid">
                                <ul class="nav nav-pills">
                                    <li><button class="nav-link demo_class active" data-bs-toggle="pill"
                                            data-bs-target="#company_information" type="button">Company
                                            Information</button></li>
                                    <li><button class="nav-link demo_class" data-bs-toggle="pill"
                                            data-bs-target="#authorised_user" type="button">Authorised User</button>
                                    </li>
                                    <li><button class="nav-link demo_class" data-bs-toggle="pill"
                                            data-bs-target="#billing_information" type="button">Billing
                                            Information</button></li>
                                    <li><button class="nav-link demo_class" data-bs-toggle="pill"
                                            data-bs-target="#Documents" type="button">Documents</button></li>
                                </ul>
                                <div class="tab-content">
                                    <?php echo $__env->make('frontend.customer.profile.company-information', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php echo $__env->make('frontend.customer.profile.authorised-user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php echo $__env->make('frontend.customer.profile.billing-information', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php echo $__env->make('frontend.customer.profile.documents', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php echo $__env->make('frontend.customer.includes.body.help-center-mobile', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </section>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script>
    function ProgressGraphStatus() {
        var graphData = 0;
        $('.progress-data').each(function () {
            graphData += parseInt($(this).val());
        });
        $('.progress-done').css('width', graphData + '%');
        $('.progress-done').attr('data-done', graphData);
    }
</script>
<script>
    const progress = document.querySelector('.progress-done');
    progress.style.width = progress.getAttribute('data-done') + '%';
    progress.style.opacity = 1;
    $('body').on('click keydown keypress touchstart pointerdown', '.iti__country.iti__standard', function () {
        var flagElement = $(this).find('.iti__flag').attr('class');
        var newText = flagElement.replace("iti__flag iti__", "");
        if ($(this).closest('.form_feild').find('.calling_code').length > 0) {
            $(this).closest('.form_feild').find('.calling_code').val(newText);
        } else {
            $('.calling_code').val(newText);
        }
    });
</script>
<script>
    //photo
    $('#photo').on('change', function (e) {
        var input = e.target;
        var reader = new FileReader();
        // Check if a file is selected
        if (input.files && input.files[0]) {
            var fileType = input.files[0].type;
            // Check if the selected file is an image and has a valid extension
            if (fileType.startsWith('image/') && /\.(png|jpg|jpeg)$/i.test(input.files[0].name)) {
                reader.onload = function (e) {
                    $('#photoImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(input.files[0]);
                uploadPhoto();
            } else {
                // Display an error message for invalid file types
                AlertMassage('Please select a valid PNG, JPG, or JPEG image.');
                $('#photo').val(''); // Clear the file input
                $('#photoImage').attr('src', ''); // Clear the image preview
            }
        }
    });
    $('#photoImage').on('click', function (e) {
        e.preventDefault();
        $('#photo')[0].click();
    });
    //add profile photo
    function uploadPhoto() {
        // Get the form and the photo input element
        const form = $('#uploadForm')[0];
        const photoInput = $('#photo')[0];
        // Check if a file has been selected
        if (!photoInput.files || !photoInput.files[0]) {
            // AlertMassage(`<?php echo e(\App\Providers\MessageManagementProvider::MessageManage('customer-profile-photo-select-a-photo')); ?>`);
            $('#photo').click();
            return;
        }
        // Create a new FormData object
        const formData = new FormData(form);
        // Send the AJAX request
        $.ajax({
            url: "<?php echo e(route('customer.profile.photo.update')); ?>",
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function (response) {
                AlertMassage(response.message);
                location.reload();
            },
            error: function (error) {
                // $('#photo').click();
                AlertMassage(`<?php echo e(\App\Providers\MessageManagementProvider::MessageManage('customer-profile-photo-error-uploading-photo')); ?>`);
            }
        });
    }
    //remove profile photo
    function removePhoto() {
        // Get the form and the photo input element
        const form = $('#uploadForm')[0];
        // Create a new FormData object
        const formData = new FormData(form);
        // Send the AJAX request
        $.ajax({
            url: "<?php echo e(route('customer.profile.photo.remove')); ?>",
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function (response) {
                AlertMassage(response.message);
                location.reload();
            },
            error: function (error) {
                AlertMassage(`<?php echo e(\App\Providers\MessageManagementProvider::MessageManage('customer-profile-photo-error-remove-photo')); ?>`);
            }
        });
    }
    //bio function
    function editFieldBio(status) {
        if (status === true) {
            $('.update-bio-button').show();
            $('.edit-bio-button').hide();
            $('.edit-bio').prop('disabled', false);
            $('#textarea-edit-bio').focus();
        } else {
            $('.update-bio-button').hide();
            $('.edit-bio-button').show();
            $('.edit-bio').prop('disabled', true);
        }
    }
    //updateBio
    function updateBio() {
        if ($('.edit-bio').val()) {
            var formData = $("form[name='update-bio']").serialize();
            $.ajax({
                type: "POST",
                url: "<?php echo e(route('customer.profile.bio.update')); ?>",
                data: formData,
                success: function (response) {
                    editFieldBio(false);
                    AlertMassage(response.message);
                    $('#bio-value').val(10);
                    ProgressGraphStatus();
                },
                error: function (xhr, status, error) {
                    AlertMassage(`<?php echo e(\App\Providers\MessageManagementProvider::MessageManage('customer-profile-something-wrong')); ?>`);
                }
            });
        } else {
            AlertMassage(`<?php echo e(\App\Providers\MessageManagementProvider::MessageManage('customer-profile-about-blank')); ?>`);
        }
    }
    //editBio
    function editBio() {
        editFieldBio(true);
    }
    //default
    editFieldBio(false);
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.user.includes.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/aurobees/resources/views/frontend/customer/profile/index.blade.php ENDPATH**/ ?>