<div class="tab-pane fade" id="authorised_user" role="tabpanel">
    <div class="form_content_inner">
        <form name='customer_authorised-user'>
            <?php echo csrf_field(); ?>
            <div class="edit_form">
                <a href="javascript:void(0);" class="edit-button-authorised-user">Edit</a>
            </div>
            <div class="form_group">
                <label for="">First Name<span style="color: red;">*</span></label>
                <div class="form_feild">
                    <input type="text" class="edit-field-authorised-user" maxlength="40" name='f_name' id="f_name" value="<?php echo e(Auth::user()->f_name); ?>">
                </div>
            </div>
            <div class="form_group">
                <label for="">Last Name<span style="color: red;">*</span></label>
                <div class="form_feild">
                    <input type="text" class="edit-field-authorised-user" maxlength="40" name='l_name' id="l_name" value="<?php echo e(Auth::user()->l_name); ?>">
                </div>
            </div>
            <div class="form_group">
                <label for="">Email<span style="color: red;">*</span></label>
                <div class="form_feild">
                    <input type="text" disabled value="<?php echo e(Auth::user()->email); ?>" >
                </div>
            </div>
            <div class="form_group">
                <label>Contact <span style="color: red;">*</span></label>
                <div class="form_feild">
                    <input type="text" id="mobile_code" class="form-control" disabled value="<?php echo e(Auth::user()->phone); ?>">
                </div>
            </div>
            <div class="form_group AlternateContact">
                <label>Alternate Contact </label>
                <div class="form_feild" style="width: unset;">
                    <input type="hidden" name="alternate_calling_code" id="alternate_calling_code" class="calling_code edit-field-authorised-user" value="<?php echo e(@$data->alternate_calling_code); ?>">
                    <input type="text" class="edit-field-authorised-user" name='alternate_phone' id="alternate_phone" value="<?php echo e(@$data->alternate_phone); ?>">
                </div>
            </div>
            <div class="form_group">
                <label for="">Designation<span style="color: red;">*</span></label>
                <div class="form_feild">
                    <input type="text" class="edit-field-authorised-user" maxlength="100" name='designation' id="designation" value="<?php echo e(@$data->designation); ?>">
                </div>
            </div>
            <div class="form_group">
                <label for="">Partner Code</label>
                <div class="form_feild">
                    <input type="text" disabled value="<?php echo e(Auth::user()->partner_code); ?>">
                </div>
            </div>
            <div class="save_discard div-button-authorised-user">
                <button type="button" class="discard_btn discard-button-authorised-user" >DISCARD</button>
                <button type="submit" class="save_btn save-button-authorised-user" >SAVE</button>
            </div>
        </form>
    </div>
</div>

<script>
$("document").ready(function () {
    // -----Country Code Selection
    $("#mobile_code").intlTelInput({
        initialCountry: "<?php echo e((Auth::user()->calling_code)?Auth::user()->calling_code:'auto'); ?>",
        separateDialCode: true,
    });
    // -----Country Code Selection
    $("#alternate_phone").intlTelInput({
        initialCountry: "<?php echo e((@$data->alternate_calling_code)?@$data->alternate_calling_code:'auto'); ?>",
        separateDialCode: true,
    });
});
</script>
<script>
    var oldAuthorisedUser=$("form[name='customer_authorised-user']").serialize();

    function editFieldAuthorisedUser(status){
        const editFields = document.querySelectorAll('.edit-field-authorised-user');
        editFields.forEach((element) => {
            element.disabled = status;
        });
        if(status==false){
            $('.edit-button-authorised-user').hide();
            $('.div-button-authorised-user').show();
            $('#f_name').focus();
        }else{
            $('.edit-button-authorised-user').show();
            $('.div-button-authorised-user').hide();
        }
    }
    //default
    editFieldAuthorisedUser(true);
    //edit button
    $(document).on('click', '.edit-button-authorised-user', function(){
        editFieldAuthorisedUser(false);
    });

    //data submit
    jQuery(function() {
        $.validator.addMethod("alternate_calling_code", function(value, element) {
            return (($('#alternate_calling_code').val() && !value)||(!$('#alternate_calling_code').val() && value))?false:true;
        }, "Please select Calling code.");
        jQuery("form[name='customer_authorised-user']").validate({
            rules: {
                f_name:{
                    required: true,
                    maxlength:41,
                    minlength:2
                },
                l_name:{
                    required: true,
                    maxlength:41,
                    minlength:2
                },
                alternate_phone:{
                    alternate_calling_code:true,
                    required:false,
                    digits:true
                },
                designation:{
                    required: true,
                    maxlength:101,
                    minlength:2
                }
            },
            // Specify validation error messages
            messages: {
                f_name:{
                    required: "Please enter first name",
                    maxlength: "First name must be less then 40 characters long.",
                    minlength: "First name must be greater then 2 characters long."
                },
                l_name:{
                    required: "Please enter last name",
                    maxlength: "Last name must be less then 40 characters long.",
                    minlength: "Last name must be greater then 2 characters long."
                },
                alternate_phone:{
                    // minlength: "Your alternate phone number must be at least 10 digits long",
                    minlength: $.validator.format("Your phone number must be at least {0} digits long."),
                    maxlength: "Your alternate phone number must be less or equal 15 digits long",
                    digits: "Alternate phone number must be digits."
                },
                designation:{
                    required: "Please enter designation",
                    maxlength: "Registered designation must be less then 100 characters long.",
                    minlength: "Registered designation be greater then 2 characters long."
                }
            },
            submitHandler: function(form) {
                var formData = $("form[name='customer_authorised-user']").serialize();
                $.ajax({
                    type: "POST",
                    url: "<?php echo e(route('customer.profile.authorised-user.update')); ?>",
                    data: formData,
                    success: function(response) {
                        oldAuthorisedUser=formData;
                        editFieldAuthorisedUser(true);
                        AlertMassage(response.message);
                        $('#authorised-user-value').val(10);
                        ProgressGraphStatus();
                    },
                    error: function(xhr, status, error) {
                        AlertMassage(`<?php echo e(\App\Providers\MessageManagementProvider::MessageManage('customer-profile-something-wrong')); ?>`);
                    }
                });
            }
        });
    });
    //discard button
    $(document).on('click', '.discard-button-authorised-user', function(){
        var params = new URLSearchParams(oldAuthorisedUser);

        // Set values for each form field using the extracted values
        setFieldValue("f_name", params.get("f_name"));
        setFieldValue("l_name", params.get("l_name"));
        setFieldValue("alternate_phone", params.get("alternate_phone"));
        setFieldValue("designation", params.get("designation"));
        setFieldValue("alternate_calling_code", params.get("alternate_calling_code"));

        editFieldAuthorisedUser(true);
    });

    <?php if(!@$data->alternate_calling_code): ?>
        $(document).ready(function() {
            $('.AlternateContact .iti__selected-flag .iti__flag').addClass('dummy-flag-icon');
        });
    <?php endif; ?>
</script>
<?php /**PATH /var/www/html/aurobees/resources/views/frontend/customer/profile/authorised-user.blade.php ENDPATH**/ ?>