<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use stdClass;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;
use App\Providers\EmailProvider;
use App\Models\EmailNotification;
use App\Models\Notification;
use App\Models\PartnerNotification;
use App\Models\EmailManagement;
use App\Models\User;
use App\Providers\MessageManagementProvider;

class CheckPartnerContractRenewalAndSendEmail extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'check-partner-contract-renewal-and-send-email:daily';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Check Partner Contract Renewal And SendEmail';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $list=EmailNotification::where('slug','partner-contract-renewal-before-expire-notification')->first();
        $support_team_email_list=EmailManagement::where('key','support_team_email')->first();
        $days=$list->description;
        if($days>0){
            $newDateTime = Carbon::now()->addDays($days)->toDateString();
            $userList=User::where('role', 'Partner')->where('agreement_to_date', $newDateTime)->where('status', 'N')->get();
            if(!$userList->isEmpty()){
                foreach($userList as $user){
                    //notification partner
                    $partner_notification=new PartnerNotification();
                    $partner_notification->user_id =$user->id;
                    $partner_notification->notification_from ='2';
                    $partner_notification->notification=MessageManagementProvider::MessageManage('partner-contract-renewal-for-partner-notification');
                    $partner_notification->save();

                    ////notification admin
                    $notification=new Notification();
                    $notification->notification_from= '2';
                    $notification->table_id= $user->id;
                    $notification->title=$user->f_name. ' '.$user->l_name.' partner contract renewal';
                    $notification->description='partner '.$user->f_name. ' '. $user->l_name.'('. $user->code .') contract expired in 4 days.';
                    $notification->save();
                    
                    EmailProvider::Email('partner_contract_renewal_before_expire_notification_for_support', $support_team_email_list->title, $user );
                }
            }
        }
        
        return Command::SUCCESS;
    }
}   
 
//php artisan check-partner-contract-renewal-and-send-email:daily