<?php
namespace App\Exports;

use Log;
use Maatwebsite\Excel\Concerns\FromView;
use Illuminate\Contracts\View\View;

class AdminPartnerList implements FromView
{
    public $datas;

    public function __construct($datas)
    {
        $this->datas = $datas;
    }

    public function view(): View
    {
        try {
            $datas = $this->datas;
            $view= view('backend.partner.registration.excel', compact('datas'));
            // Log::info('AdminPartnerList excel: ' . $view);
            return $view;
        } catch (\Exception $e) {
            Log::error('AdminPartnerList excel error: ' . json_encode($e));
            return '';
        }
    }
}
