<?php

namespace App\Http\Controllers;

use App\Models\BlogCategory;
use App\Models\CustomerNotification;
use App\Models\Posts;
use App\Models\Pricing;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Notification;
use App\Models\PartnerDetailMetaData;
use App\Models\Subscription;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Cookie;
use App\Providers\MessageManagementProvider;
use App\Providers\HelperServiceProvider;
use Illuminate\Support\Facades\Log;
use DB;
use App\Providers\PartnerRegistrationProvider;
use App\Http\Middleware\PartnerCheck;

class Dashboard extends Controller
{

    public function login(Request $request){
        $request->validate([
            'email' => 'required|email',
            'password' => 'required',
        ]);
        try{
            $credentials = $request->only('email', 'password');

            if (Auth::attempt($credentials, $request->remember)) {
                // Log out the user from all other devices
                Auth::logoutOtherDevices($request->password);
                
                // Authentication passed
                // Your custom logic after successful authentication
                if($request->remember){
                    Cookie::queue(Cookie::make('aurobees_email', $request->email, 5*24*365, '/', null, true, false));
                    Cookie::queue(Cookie::make('aurobees_password', $request->password, 5*24*365, '/', null, true, false));
                }
                return redirect()->route('dashboard');
            }
            // Authentication failed
            // Your custom logic for handling failed login attempts
            return back()->withErrors([
                'email' => 'Wrong email or password, Kindly try again.',
            ]);
        }catch(\Exception $e) {
            Log::error('Login Error: '. $e);
            $message =MessageManagementProvider::MessageManage('excetion-error');
            return redirect()->back()->with('message',$message);
        }
    }

    public function Dashboard(){
        try{
            if(Auth::user()->role=='Administrator' && Auth::user()->status=='N'){
                $users = User::where('role', 'Administrator')->where('status', 'N')->count();
                $customers = User::where('role', 'Customer')->where('status', 'N')->count();
                $partner = User::where('role', 'Partner')->where('status', 'N')->count();
                $inActive = User::where('status', 'Y')->count();
                $blog_category = BlogCategory::where('status','Published')->count();

                $blog = Posts::where('post_type','post')->where('post_status','Published')->count();
                return view('admin.index', compact('users', 'customers', 'partner','inActive','blog_category'));
            }elseif(Auth::user()->role=='Customer' && Auth::user()->status=='N'){
                $currentDate = date('Y-m-d H:i:s'); // Get the current date
                if(Cookie::get('planPurchaseData')){
                    return redirect()->route('purchase-plan.store');
                }
                $activeSubscriptions=Subscription::where('user_id', Auth::user()->id)->where('status','Active')->where('upgrade_status','0')->get();
                $invoiceDate='';
                $estimatedAmount='';
                if($activeSubscriptions){
                    foreach($activeSubscriptions as $activeSub){
                        if(!$invoiceDate || $invoiceDate>@$activeSub->end_at){
                            $invoiceDate=@$activeSub->end_at;
                            if(@$activeSub->grand_amount>1){
                                $estimatedAmount=@$activeSub->currency_code.' '.@$activeSub->grand_amount;
                            }else{
                                $estimatedAmount='';
                            }
                        }
                    }
                }


                $total_no_of_lob=Subscription::where('user_id', Auth::user()->id)->count();
                $active_no_of_user1=Subscription::where('user_id', Auth::user()->id)->where('status','Active')->where('end_at','>=',$currentDate)->where('plan_name','!=','Ecommerce')->sum('quantity');
                $active_no_of_user2=Subscription::where('user_id', Auth::user()->id)->where('status','Active')->where('end_at','>=',$currentDate)->where('plan_name','Ecommerce')->count();
                $active_no_of_user=@$active_no_of_user1+@$active_no_of_user2;
                $futureDate = date('Y-m-d H:i:s', strtotime($currentDate . ' +5 days'));
                // Get the date one year back from the current date
                $oneYearBackDate = date('Y-m-d', strtotime('-1 year', strtotime($currentDate)));

                $billing_no_of_lob=Subscription::where('user_id', Auth::user()->id)->where('status','Active')->whereBetween('end_at',[$currentDate,$futureDate])->count();
                $subscription_list=Subscription::where('user_id', Auth::user()->id)->where('status','Active')->where('end_at','>=',$currentDate)->limit(10)->get();

                //last 12 month active user map
                $month_list=HelperServiceProvider::Prev12Month();
                $getPlanList=Subscription::where('user_id', Auth::user()->id)->where('status','Active')->where('end_at','>=',$oneYearBackDate)->select('plan_id')->groupBy('plan_id')->get();
                $parent_list = array();
                if ($getPlanList) {
                    foreach ($getPlanList as $childKey => $plan) {
                        $childList = array();
                        $childList['id'] = $childKey + 1;
                        $childList['name'] = $plan['Pricing']['LOB']['title'];
                        $countMonth=0;
                        foreach ($month_list as $subChildKey => $month) {
                            $subChildList = array();
                            $active_user_month1 = Subscription::where('user_id', Auth::user()->id)->where('plan_id',$plan->plan_id)->where('status', 'Active')->where('start_at', '<=', $month['l_date'])->where('end_at', '>=', $month['f_date'])->where('plan_name','!=','Ecommerce')->sum('quantity');
                            $active_user_month2 = Subscription::where('user_id', Auth::user()->id)->where('plan_id',$plan->plan_id)->where('status', 'Active')->where('start_at', '<=', $month['l_date'])->where('end_at', '>=', $month['f_date'])->where('plan_name','Ecommerce')->count();
                            $active_user_month =@$active_user_month1+@$active_user_month2;
                            if($active_user_month){
                                $countMonth++;
                                $subChildList['user'] = $active_user_month;
                                $subChildList['month'] = $month['name'];
                                $subChildList['id'] = $countMonth;
                                $subChildList['start_at'] = $month['f_date'];
                                $subChildList['end_at'] = $month['l_date'];

                                $childList['list'][] = $subChildList;
                            }
                        }
                        if($countMonth != 12){
                            for($i = $countMonth+1; $i <=12; $i++){
                                $subChildList['user'] ='';
                                $subChildList['month'] = '';
                                $subChildList['id'] = $i;

                                $childList['list'][] = $subChildList;
                            }
                        }

                        $parent_list[] = $childList;
                    }
                }
                $overviewActiveUser=$parent_list;

                return view('frontend.customer.index', compact('total_no_of_lob', 'active_no_of_user', 'billing_no_of_lob', 'subscription_list','overviewActiveUser','invoiceDate','estimatedAmount'));
            }elseif(Auth::user()->role=='Partner' && Auth::user()->status=='N'){
                return SELF::PartnerDashboard();
            }else{
                session()->flush();
                Session::flash('message', MessageManagementProvider::MessageManage('account-delete'));
                return redirect('login');
            }
        }catch(\Exception $e) {
            Log::error('Dashboard Error: '. $e);
            $message =MessageManagementProvider::MessageManage('excetion-error');
            return redirect()->back()->with('message',$message);
        }
    }

    public function setNotification(){                                       //admin
        $total = Notification::where('status', '0')->count();
        $message='';
        $datas=Notification::where('status', '0')->orderBy('id', 'DESC')->limit(10)->get();
        foreach($datas as $data){
            //0->default, 1->customer registration, 2->partner registration, 3->lob subscription, 4->post/blog comment
            if($data->notification_from=='1'){
                $message.='<a href="'.route('admin.customer.view').'" class="dropdown-item">'.$data->title.'<br><b>Date:</b>'.date('d-m-Y  h:i:sa',strtotime(@$data->created_at)). '</a>';
            }elseif($data->notification_from=='2'){
                $message.='<a href="'.route('admin.partner.view').'" class="dropdown-item">'.$data->title.'<br><b>Date:</b>'.date('d-m-Y  h:i:sa',strtotime(@$data->created_at)). '</a>';
            }elseif($data->notification_from=='3'){
                $message.='<a href="'.route('lob.subscription.list').'" class="dropdown-item">'.$data->title. '<br><b>Date:</b>'.date('d-m-Y  h:i:sa',strtotime(@$data->created_at)). '</a>';
            }elseif($data->notification_from=='4'){
                if($data->table_id){
                    $message.='<a href="'.route('post.comment', $data->table_id).'" class="dropdown-item">'.$data->title.'<br><b>Date:</b>'.date('d-m-Y  h:i:sa',strtotime(@$data->created_at)). '</a>';
                }else{
                    $message.='<a href="'.route('post.list').'" class="dropdown-item">'.$data->title. '<br><b>Date:</b>'.date('d-m-Y  h:i:sa',strtotime(@$data->created_at)).'</a>';
                }
            }elseif($data->notification_from=='5'){
                $message.='<a href="'.route('page.event.event-form-data.list', $data->table_id).'" class="dropdown-item">'.$data->title.'<br><b>Date:</b>'.date('d-m-Y  h:i:sa',strtotime(@$data->created_at)). '</a>';
            }else{
                $message.='<a href="'.route('AllNotification').'" class="dropdown-item">'.$data->title.'<br><b>Date:</b>'.date('d-m-Y  h:i:sa',strtotime(@$data->created_at)). '</a>';
            }
        }
        $status['total']=$total;
        $status['message']=$message;
        return $status;
    }

    public function AllNotification(){                                         //admin
        $d2 = date('Y-m-d H:i:s', strtotime('-30 days'));
        $datas=Notification::where('created_at','>',$d2)->orderBy('id', 'DESC')->get();
        Notification::where("status", '0')->update(["status" => "1"]);
        return view('backend.setting.notification.index',compact('datas'));
    }

    public function ReadNotification(){                                        //admin
        Notification::where("status", '0')->update(["status" => "1"]);
        return redirect()->back();
    }

    public function CustomerReadNotification(){
        CustomerNotification::where('user_id',Auth::user()->id)->where("status", '0')->update(["status" => "1"]);
        return redirect()->back();
    }

    private function PartnerDashboard(){
        try{
            if(!Session::get('approved_partner_status')){
                $userID=Auth::user()->id;
                $checkPage3=PartnerDetailMetaData::where('user_id',Auth::user()->id)->where('key','individual_business')->count();
                $userID=Auth::user()->id;
                // session()->flush();
                Session::put('partner_registration_id', $userID);
                if(!$checkPage3){
                    Session::put('partner_registration_page_id', 3);
                    return redirect()->route('become-a-partner.basic-information');
                }
                if(!Auth::user()->company){
                    Session::put('partner_registration_page_id', 4);
                    return redirect()->route('become-a-partner.company-information');
                }
                $checkPage5=PartnerDetailMetaData::where('user_id', $userID)->where('key','what_is_your_company_primary_vertical_market_focus')->count();
                if(!$checkPage5){
                    Session::put('partner_registration_page_id', 5);
                    return redirect()->route('become-a-partner.company-financial-information');
                }
                $checkPage6=PartnerDetailMetaData::where('user_id', $userID)->where('key','total_number_of_employees')->count();
                if(!$checkPage6){
                    Session::put('partner_registration_page_id', 6);
                    return redirect()->route('become-a-partner.company-financial-information2');
                }
                $checkPage7=PartnerDetailMetaData::where('user_id', $userID)->where('key','company_registration_number')->count();
                if(!$checkPage7){
                    Session::put('partner_registration_page_id', 7);
                    return redirect()->route('become-a-partner.company-documents-upload');
                }
                if(!PartnerRegistrationProvider::PartnerRegistrationRejectStatus() || !PartnerRegistrationProvider::PartnerRegistrationUnderProcess()){
                    Session::put('partner_registration_page_id', 9);
                    return redirect()->route('become-a-partner.profile-verification-summary');
                }
                $checkPage11=PartnerDetailMetaData::where('user_id', $userID)->where('key','partner_contract')->first();
                if(!$checkPage11 || @$checkPage11->verify=='Reject' ){
                    Session::put('partner_registration_page_id', 11);
                    return redirect()->route('become-a-partner.partner-contract');
                }
                $checkPage11=PartnerDetailMetaData::where('user_id', $userID)->where('key','partner_contract')->first();
                if(!$checkPage11 || @$checkPage11->verify!='Approve' && !PartnerRegistrationProvider::CheckStatus()){
                    Session::put('partner_registration_page_id', 10);
                    return redirect()->route('become-a-partner.contract-verification');
                }
            }
            return self::PartnerDashboardData();
            // session()->flush();
            // return redirect('login');
        
        }catch(\Exception $e) {
            Log::error('Dashboard Error: '. $e);
            $message =MessageManagementProvider::MessageManage('excetion-error');
            return redirect()->back()->with('message',$message);
        }
    }

    private function  PartnerDashboardData(){
        try{
            $date=date('Y-m-d');
            if (!(Auth::user()->role == 'Partner' && Auth::user()->status == 'N' && Auth::user()->agreement_from_date <= $date &&  Auth::user()->agreement_to_date >= $date )) {
                session()->flush();
                $message='Your account is deleted by admin or your agreement was expired.';
                return redirect('login')->with('message', $message);  
            }
            
            //approved partner status
            Session::put('approved_partner_status', true);
            $sevenDaysAgo = date('Y-m-d', strtotime('-7 days'));
            $currentDate=date('Y-m-d H:i:s');
            $currentMonth=date('Y-m-01');

            $totalCustomer=User::where('role', 'Customer')->where('status', 'N')->where('is_email_verified', '1')->where('partner_code', Auth::user()->code)->count();
            $currentWeekNewLOB=Subscription::join('users', 'subscriptions.user_id','=','users.id')->where('subscriptions.status', 'Active')->whereBetween('subscriptions.start_at', [$sevenDaysAgo, $currentDate])->where('users.partner_code', Auth::user()->code)->count();
           
            $data = Subscription::select('subscriptions.currency_code',
                    DB::raw('COUNT(*) as total_subscriptions'),
                    DB::raw('SUM(grand_amount) as grand_amount_sum'),
                    DB::raw('SUM(partner_commission_amount) as partner_commission_sum')
                )
                ->join('users', 'subscriptions.user_id', '=', 'users.id')
                ->where('subscriptions.status', 'Active')
                ->whereBetween('subscriptions.start_at', [$currentMonth, $currentDate])
                ->where('users.partner_code', Auth::user()->code)
                ->groupBy('subscriptions.currency_code')
                ->first();
            $grand_amount_sum=0;
            $partner_commission_sum=0;
            $amountCurrencyCode='$';
            if($data){
                $grand_amount_sum=$data->grand_amount_sum;
                $partner_commission_sum=$data->partner_commission_sum;
                $amountCurrencyCode=$data->currency_code;
            }
                
            //lob list
            $lobWiseSubscriptionEcommerce=[];
            $lobWiseRevenue=[];
            $revenueGenerated12Months=[];
            $month_list=HelperServiceProvider::Prev12Month();
            $lobList=Pricing::select('pricings.id','industries.title' )->join('industries', 'pricings.lob_id', '=', 'industries.id')->where('pricings.status', 'Published')->where('pricings.language', 'en')->get();
            if($lobList){
                foreach($lobList as $lob){
                    
                    //Lob wise Subscription E-commerce
                    // $currentWeekActiveLOB=Subscription::join('users', 'subscriptions.user_id','=','users.id')->where('subscriptions.plan_id', $lob->id)->where('subscriptions.status', 'Active')->where('subscriptions.plan_name', 'Ecommerce')->whereBetween('subscriptions.start_at', [$sevenDaysAgo, $currentDate])->where('users.partner_code', Auth::user()->code)->count();
                    // $ActiveLOB=Subscription::join('users', 'subscriptions.user_id','=','users.id')->where('subscriptions.plan_id', $lob->id)->where('subscriptions.status', 'Active')->where('subscriptions.plan_name', 'Ecommerce')->where('subscriptions.end_at', '>=', $currentDate)->where('users.partner_code', Auth::user()->code)->count();
                    $currentWeekActiveLOB=Subscription::select(DB::raw('SUM(quantity) as totalQty'))->join('users', 'subscriptions.user_id','=','users.id')->where('subscriptions.plan_id', $lob->id)->where('subscriptions.status', 'Active')->where('subscriptions.plan_name', 'Ecommerce')->whereBetween('subscriptions.start_at', [$sevenDaysAgo, $currentDate])->where('users.partner_code', Auth::user()->code)->first();
                    $ActiveLOB=Subscription::select(DB::raw('SUM(quantity) as totalQty'))->join('users', 'subscriptions.user_id','=','users.id')->where('subscriptions.plan_id', $lob->id)->where('subscriptions.status', 'Active')->where('subscriptions.plan_name', 'Ecommerce')->where('subscriptions.end_at', '>=', $currentDate)->where('users.partner_code', Auth::user()->code)->first();
                    if(@$ActiveLOB->totalQty || @$currentWeekActiveLOB->totalQty){
                        $lobWiseSubscriptionEcommerce[]=['name'=> $lob->title, 'total' =>$ActiveLOB->totalQty - $currentWeekActiveLOB->totalQty , 'week' =>$currentWeekActiveLOB->totalQty ];
                    }

                    //LOB wise Revenue of current Month
                    $currentMonthActiveLOB=Subscription::select(
                            DB::raw('SUM(grand_amount) as grand_amount_sum'),
                            DB::raw('SUM(partner_commission_amount) as partner_commission_sum')
                        )
                        ->join('users', 'subscriptions.user_id','=','users.id')
                        ->where('subscriptions.plan_id', $lob->id)
                        ->where('subscriptions.status', 'Active')
                        ->whereBetween('subscriptions.start_at', [$currentMonth, $currentDate])
                        ->where('users.partner_code', Auth::user()->code)
                        ->first();
                    if($currentMonthActiveLOB->grand_amount_sum || $currentMonthActiveLOB->partner_commission_sum){
                        $lobWiseRevenue[]=['name'=> $lob->title, 'total' =>number_format($currentMonthActiveLOB->grand_amount_sum, 2,'.',''), 'partner' =>number_format($currentMonthActiveLOB->partner_commission_sum, 2, '.','')];
                    }

                    //last 12th month revenue generated trend
                    $childArray=[];
                    $childArrayEmpty=[];
                    $monthActive=false;
                    foreach($month_list as $month){
                        $fromDate=date('Y-m-d 00:00:00', strtotime($month['f_date']));
                        $toDate=date('Y-m-d 23:59:59', strtotime($month['l_date']));

                        //12 month revenue generated trend
                        $subscriptionData=Subscription::select(
                                DB::raw('SUM(grand_amount-partner_commission_amount) as grand_amount_sum'),
                                DB::raw('SUM(partner_commission_amount) as partner_commission_sum'),
                                DB::raw('COUNT(subscriptions.id) as active_user')
                            )
                            ->join('users', 'subscriptions.user_id', '=', 'users.id')
                            ->where('subscriptions.status', 'Active')
                            ->whereBetween('subscriptions.start_at', [$fromDate, $toDate])
                            ->where('users.partner_code', Auth::user()->code)
                            ->where('subscriptions.plan_id', $lob->id)
                            ->first();

                        if($subscriptionData->grand_amount_sum){ $monthActive=true; }
                        if($monthActive){
                            $childArray[]=array('name'=> $month['name'], 'total'=>number_format($subscriptionData->grand_amount_sum,2,'.','') , 'partner'=>number_format($subscriptionData->partner_commission_sum,2,'.',''), 'active_user'=>$subscriptionData->active_user );
                        }else{
                            $childArrayEmpty[]=array('name'=> $month['name'], 'total'=>number_format($subscriptionData->grand_amount_sum,2,'.','') , 'partner'=>number_format($subscriptionData->partner_commission_sum,2,'.',''), 'active_user'=>$subscriptionData->active_user );
                        }
                    }
                    $childArray = array_merge($childArray, $childArrayEmpty);
                    if($childArray){
                        $revenueGenerated12Months[]=['name'=> $lob->title, 'data'=>$childArray];
                    }
                }
            }

            return view('frontend.become_a_partner.index', compact('totalCustomer', 'currentWeekNewLOB', 'grand_amount_sum', 'partner_commission_sum', 'lobWiseRevenue', 'revenueGenerated12Months', 'lobWiseSubscriptionEcommerce', 'amountCurrencyCode'));
        }catch(\Exception $e) {
            Log::error('Dashboard Partner Dashboard Data Error: '. $e);
            $message =MessageManagementProvider::MessageManage('excetion-error');
            return redirect()->back()->with('message',$message);
        }
    }
    
}
