<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Carbon\Carbon;
use App\Models\User;
use Mail;
use Illuminate\Support\Str;
use App\Models\EmailManagement;
use App\Models\UserVerify;
use App\Providers\MessageManagementProvider;
use App\Providers\EmailProvider;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use stdClass;
use Illuminate\Support\Facades\Log;

class ForgotPasswordController extends Controller
{
    /**
     * Write code on Method
     *
     * @return response()
     */
    public function showForgetPasswordForm(){
        return view('frontend.new_user.forget_password');
    }

    /**
     * Write code on Method
     *
     * @return response()
     */
    public function submitForgetPasswordForm(Request $request){
        try{
            $token = Str::random(64);
            $number=rand(10000,99999);
            $user=User::where('email',$request->email)->where('status','N')->first();
            if($user){
                if($user->is_email_verified){
                    UserVerify::create([
                        'user_id' => $user->id,
                        'token' => $token,
                        'otp' => $number
                    ]);

                    //otp mail
                    $value=new stdClass();
                    $value->f_name=$user->f_name;
                    $value->l_name=$user->l_name;
                    $value->otp=$number;
                    if($user->role=='Partner'){
                        EmailProvider::Email('become_a_partner_registration_forgot_password', $request->email, $value );
                    }else{
                        EmailProvider::Email('forgot_password', $request->email, $value );
                    }

                    $email=$request->email;
                    $successmessage =MessageManagementProvider::MessageManage('customer-new-registered');
                    return view('frontend.new_user.otp1',compact('token','email','successmessage'));
                }else{
                    $femail =   substr(trim($request->email),0,4);
                    $email  =   strstr($request->email, '@');
                    $trimEmail =   $femail.'********'.$email;
                    $link=route('resend.otp');
                    $link='<a href="'.$link.'">email validation</a>';

                    $message = MessageManagementProvider::MessageManage('email-not-verified');
                    $message = str_replace('{EMAIL_ADDRESS}',$trimEmail, $message);
                    $message = str_replace('{LINK}',$link, $message);
                    return redirect()->back()->with('message',$message);
                }
            }else{
                $message =MessageManagementProvider::MessageManage('email-not-exist');
                return redirect()->back()->with('message', $message);
            }
        }catch(\Exception $e) {
            Log::error('Forget Password Error: '. $e);
            $message = MessageManagementProvider::MessageManage('domain-may-not-exist');
            return redirect()->back()->with('message',$message);
        }
    }

    public function ForgetPasswordOtp(Request $request){
        $validateData=$request->validate([
            'token' => 'required',
            'otp' => 'min:5 |required'
        ]);
        try{
            $token=$request->token;
            $verifyUser = UserVerify::where('token', $token)->where('otp', $request->otp)->first();

            if($verifyUser){
                $user = $verifyUser->user;
                $secondsDifference=strtotime(date('Y-m-d H:i:s'))-strtotime($verifyUser->updated_at);
                if(round($secondsDifference/60)<=10){
                    $verifyUser->user->is_email_verified = 1;
                    $verifyUser->user->save();
                    Session::put('forgotPasswordToken', $token);
                    return redirect()->route('change-password.add');
                }else{
                    $message =MessageManagementProvider::MessageManage('otp-expired');
                    $message1 =MessageManagementProvider::MessageManage('email-again');
                    return redirect()->back()->with(['message'=> $message, 'message1'=>$message1]);
                }
            }else{

                $email=$request->email;
                $message =MessageManagementProvider::MessageManage('wrong-otp');
                return view('frontend.new_user.otp1',compact('token','email','message'));
            }
        }catch(\Exception $e) {
            Log::error('Forget Password Otp Error: '. $e);
            $message =MessageManagementProvider::MessageManage('excetion-error');
            return redirect()->back()->with('message',$message);
        }
    }

    public function ChangePasswordStore(Request $request){
        $validateData = $request->validate([
            'password'=>['required','min:8','regex:/^(?=.*?[A-Z])(?=.*?[a-z])(?=.*?[0-9])(?=.*?[#?!@$%^&*-]).{8,}$/'],
            'password_confirmation'=>['required','min:8','same:password'],
        ]);
        try{
            $mail_token =   Session::get('forgotPasswordToken');
            $verifyUser =   UserVerify::where('token', $mail_token)->first();
            $message    =   MessageManagementProvider::MessageManage('email-not-exist');

            if(!is_null($verifyUser) ){
                $user       = $verifyUser->user;
                $verifyUser->user->password = Hash::make($request->password);
                $verifyUser->user->save();
                $message    =  MessageManagementProvider::MessageManage('password-save');
                Session::forget('forgotPasswordToken');
            }
            return redirect()->route('home')->with('message', $message);
        }catch(\Exception $e) {
            Log::error('Forget Password Change Password Error: '. $e);
            $message =MessageManagementProvider::MessageManage('excetion-error');
            return redirect()->back()->with('message',$message);
        }
    }


    public function submitForgetPasswordFormAjax(Request $request){
        $request->validate([
            'email' => 'required|email|exists:users',
        ]);
        try{
            $token  = Str::random(64);
            $number = rand(10000,99999);
            $user   = User::where('email',$request->email)->where('status','N')->first();
            if($user){
                UserVerify::where('user_id',$user->id)->delete();
                UserVerify::create([
                    'user_id' => $user->id,
                    'token' => $token,
                    'otp' => $number
                ]);
                $name=$user->f_name;
                //otp mail
                $value=new stdClass();
                $value->f_name=$user->f_name;
                $value->l_name=$user->l_name;
                $value->otp=$number;
                if($user->role=='Partner'){
                    EmailProvider::Email('become_a_partner_registration_forgot_password', $request->email, $value );
                }else{
                    EmailProvider::Email('forgot_password', $request->email, $value );
                }

                $email=$request->email;
                $message['token']=$token;
                $message['email']=$email;
                return $message;
            }else{
                $message['error'] =MessageManagementProvider::MessageManage('email-not-exist');
                return  $message;
            }
        }catch(\Exception $e){
            Log::error('Forget Password Error: '. $e);
            $message =MessageManagementProvider::MessageManage('excetion-error');
            return $message;
        }
    }

    public function ChangePassword(Request $request){
        try{
            if(Session::get('forgotPasswordToken')){
                return view('frontend.new_user.change-password');
            }else{
                return redirect()->back();
            }
        }catch(\Exception $e){
            Log::error('Change Password Error: '. $e);
            $message =MessageManagementProvider::MessageManage('excetion-error');
            return redirect()->back()->with('message',$message);
        }
    }
}
