<?php

namespace App\Http\Controllers\backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\BlogCategory;
use App\Models\Posts;
use App\Models\Language;
use Intervention\Image\Facades\Image;


class BlogCategoryController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($type)
    {
        $datas=BlogCategory::where('type',$type)->get();
        return view('backend.blog_category.index',compact('datas','type'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($type)
    {
        $languages=Language::all();
        $defaultLanguagePagesList=BlogCategory::where('type',$type)->where('language','en')->where('status','Published')->get();
        return view('backend.blog_category.add',compact('languages','type','defaultLanguagePagesList'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request ,$type)
    {
        $validated = $request->validate([
            'name'=>'required',
            'image'=>'mimes:jpg,png,jpeg,gif,svg',
            'language'=>'required',
            'meta_title'=>'required',
            'meta_key'=>'required',
            'meta_description'=>'required',
        ]);

        if($request->language =='en' && $request->slug){
            $check_data=BlogCategory::where('slug',$request->slug)->where('language',$request->language)->count();
            if($check_data){
                $notification=array(
                    'message'=>'Title already exists!!.',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }elseif($request->language !='en' && $request->default_language_page){
            $check_data=BlogCategory::where('default_language_page',$request->default_language_page)->where('language',$request->language)->count();
            if($check_data){
                $notification=array(
                    'message'=>'Title already exists!!.',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }else{
            $notification=array(
                'message'=>'Please first add english language page!!.',
                'alert-type'=>'warning'
            );
            return redirect()->back()->with($notification);
        }

        $image_name=$request->file('image');
        $name_gen=hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
        $path = public_path('upload/blog_category/'.$name_gen);
        Image::make($image_name->getRealPath())->save($path);

        $last_img='upload/blog_category/'.$name_gen;

        $data=new BlogCategory();
        $data->name=$request->name;
        $data->type=$type;
        if($request->language =='en'){
            $data->slug        =   trim(strtolower($request->slug));
        }else{
            $data->default_language_page = $request->default_language_page;
        }
        $data->image=$last_img;
        $data->description=$request->description;
        $data->language=$request->language;
        $data->meta_title=$request->meta_title;
        $data->meta_key=$request->meta_key;
        $data->meta_description=$request->meta_description;
        $data->created_by=Auth::user()->id;
        $result=$data->save();
        if($result){
            $notification=array(
                'message'=>$type.' Category Save Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('user.blog.category.view',$type)->with($notification);
        }else{
            $notification=array(
                'message'=>'Some Problem on server!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($type, $id)
    {
        $data=BlogCategory::find($id);
        return view('backend.blog_category.view',compact('data','type'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($type, $id)
    {
        $languages=Language::all();
        $defaultLanguagePagesList=BlogCategory::where('language','en')->where('type',$type)->where('status','Published')->get();
        $data=BlogCategory::find($id);
        return view('backend.blog_category.edit',compact('data','languages','type','defaultLanguagePagesList'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $type, $id)
    {
        $request->validate([
            'image'=>'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'name'=>'required',
            'description'=>'required',
            'language'=>'required',
            'meta_key'=>'required',
            'meta_title'=>'required',
            'meta_description'=>'required',
            'status'=>'required',
        ]);

        if($request->language !='en'){
            $check_data=BlogCategory::where('id','!=',$id)->where('default_language_page',$request->default_language_page)->where('language',$request->language)->count();
            if($check_data){
                $notification=array(
                    'message'=>'Title already exists!!.',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }
        $data= BlogCategory::find($id);
        $old_image=$request->old_image;
        $image_name=$request->file('image');
        if($image_name){
            $name_gen=hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
            $path = public_path('upload/blog_category/'.$name_gen);
            Image::make($image_name->getRealPath())->save($path);

            $last_img='upload/blog_category/'.$name_gen;
            $data->image=$last_img;
            $unlink=@unlink($old_image);
        }
        $data->name=$request->name;
        if($request->language !='en'){
            $data->default_language_page = $request->default_language_page;
        }
        $data->description=$request->description;
        $data->language=$request->language;
        $data->meta_title=$request->meta_title;
        $data->meta_key=$request->meta_key;
        $data->status=$request->status;
        $data->meta_description=$request->meta_description;
        $data->updated_by=Auth::user()->id;
        $result=$data->update();
        if($result){
            $notification=array(
                'message'=>$type.' Category Update Successfully!!',
                'alert-type'=>'info'
            );
            return redirect()->route('user.blog.category.view', $type)->with($notification);
        }else{
            $notification=array(
                'message'=>'Some Problem on server!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($type, $id)
    {
        $data       =   BlogCategory::find($id);
        if($data->status=='Trash'){
            $dataCheck=Posts::where('blog_category_id',$id)->count();
            if($dataCheck==0){
                $result=$data->delete();
            }else{
                $notification=array(
                    'message'=>'First delete associated Category!!',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }else{
            $data->status='Trash';
            $result=$data->update();
        }
        if($result){
            $notification=array(
                'message'=>'Record Delete Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('user.blog.category.view',$type)->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
}
