<?php

namespace App\Http\Controllers\backend;

use App\Http\Controllers\Controller;
use App\Models\EmailManagement;
use Illuminate\Http\Request;

class EmailManagementController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
       $datas=EmailManagement::all();
        return view('backend.email_management.index',compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validateData=$request->validate([
            'key' => 'required',
            'title' => 'required',
            'template' => 'required'
        ]);
        $check_data=EmailManagement::where('key',$request->key)->count();
        if($check_data){
            $notification=array(
                'message'=>'Email already exists!!.',
                'alert-type'=>'warning'
            );
            return redirect()->back()->with($notification);
        }
        $data=new EmailManagement();
        $data->key=$request->key;
        $data->title=$request->title;
        $data->template=$request->template;
        $result=$data->save();
        if($result){
            $notification=array(
                'message'=>'Email Management Store Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('user.email.view')->with($notification);
        }else{
            $notification=array(
                'message'=>'Some Problem on server!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data= EmailManagement::find($id);
        return view('backend.email_management.edit',compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validateData=$request->validate([
            'title' => 'required',
            'template' => 'required'
        ]);

        

        $data=EmailManagement::find($id);
        $data->title=$request->title;
        $data->template=$request->template;
        //-----------------------------------------
        $file = $request->file('file');
        if(!empty($file) && $file != null){
            $path                       = hexdec(uniqid()).".".$file->extension();
            $file->move(public_path('upload/email/'), $path);
            $data->file            =   'upload/email/'.$path;
        }
        //-----------------------------------------
        $result=$data->save();
        if($result){
            $notification=array(
                'message'=>'Email Management Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('user.email.view')->with($notification);
        }else{
            $notification=array(
                'message'=>'Some Problem on server!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
