<?php

namespace App\Http\Controllers\backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Posts;
use App\Models\BlogCategory;
use Intervention\Image\Facades\Image;
use App\Models\Language;
use Str;
use Illuminate\Support\Facades\Auth;
use DataTables;

class LatestNewsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if($request->ajax()){
            // if(!$request->category_id || $request->category_id=='All'){
                $posts = Posts::where('post_type','news')->orderBy('id','DESC');
            // }else{
            //     $posts=Posts::where('blog_category_id',$request->category_id)->where('post_type','news')->orderBy('id','DESC');
            // }

            return DataTables::of($posts)
                ->addColumn('action', function($data) {
                    $html='<a href="'.route('latest-news.preview',$data->id).'" class="btn btn-outline-success"><i class="fas fa-eye"></i></a>';
                    $html .='<a href="'.route('latest-news.edit',$data->id).'" class="btn btn-outline-info"><i class="fas fa-edit"></i></a>';
                    if($data->post_status=='Trash'){
                        $html .='<a href="'.route('latest-news.delete',$data->id).'" onclick="return confirm(\'Are you sure you want to delete this item?\');" class="btn btn-outline-danger"  title="Permanently delete"><i class="fas fa-trash"></i></a>';
                    }else{
                        $html .='<a href="'.route('latest-news.delete',$data->id).'" onclick="return confirm(\'Are you sure you want to trash this item?\');" class="btn btn-outline-warning" title="Trash Item"><i class="fas fa-trash"></i></a>';
                    }
                    return $html;
                })
                ->editColumn('created_at', function($data) {
                    return date('Y-m-d', strtotime($data->created_at));
                })
                ->addIndexColumn()
                ->rawColumns(['action'])  // Allow HTML in the 'action' column
                ->make(true);
        }








        $categorys=BlogCategory::where('language','en')->where('type','news')->get();
        return view('backend.latest_news.index',compact('categorys'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $languages=Language::all();
        $categorys=BlogCategory::where('language','en')->where('type','news')->get();
        $defaultLanguagePagesList=Posts::where('post_type','news')->where('language','en')->where('post_status','Published')->get();
        return view('backend.latest_news.add',compact('languages','categorys','defaultLanguagePagesList'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'image'=>'nullable|mimes:jpg,png,jpeg,gif,svg',
            'pdf'=>'nullable|mimes:pdf',
            'video'=>'nullable|mimes:mp4,mov,ogg,qt',
            'post_title'=>'required',
            'location'=>'required',
            'blog_category_id'=>'required',
            'post_content'=>'required',
            'language'=>'required',
            'meta_key'=>'required',
            'meta_title'=>'required',
            'meta_description'=>'required',
            'media_type'=>'required',
        ]);

        if($request->language =='en' && $request->post_slug){
            $check_data=Posts::where('post_slug',$request->post_slug)->where('language',$request->language)->count();
            if($check_data){
                $notification=array(
                    'message'=>'Title already exists!!.',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }elseif($request->language !='en' && $request->default_language_page){
            $check_data=Posts::where('default_language_page',$request->default_language_page)->where('language',$request->language)->count();
            if($check_data){
                $notification=array(
                    'message'=>'Title already exists!!.',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }else{
            $notification=array(
                'message'=>'Please first add english language page!!.',
                'alert-type'=>'warning'
            );
            return redirect()->back()->with($notification);
        }

        $data    =   new Posts();
        if($request->media_type=='Image'){
            $image_name     =   $request->file('image');
            if($image_name){
                $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
                $path           =   public_path('upload/blog/'.$name_gen);
                Image::make($image_name->getRealPath())->save($path);
                $last_img       =   'upload/blog/'.$name_gen;
                $data->image            =   $last_img;
            }else{
                $notification=array(
                    'message'=>'Please Upload Image',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }elseif($request->media_type=='Video'){
            if($request->video_type=='MP4'){
                $video = $request->file('video');
                if(!empty($video) && $video != null){
                    $fileExentsion              = $video->extension();
                    $fileName                   = $video->getClientOriginalName();
                    $fileFullName               = time()."_".$fileName;
                    $path                       = Str::slug($fileFullName).".".$fileExentsion;
                    $video->move(public_path('upload/blog/'), $path);
                    $fullpath                   = 'upload/blog/'.$path;
                    $data->video            =   $fullpath;
                }else{
                    $notification=array(
                        'message'=>'Please Upload Video',
                        'alert-type'=>'warning'
                    );
                    return redirect()->back()->with($notification);
                }
            }elseif($request->video_type=='Youtube' && $request->youtube){
                $data->youtube            =   $request->youtube;
            }else{
                $notification=array(
                    'message'=>'Please Enter Youtube Link',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }

        //pdf
        $pdf = $request->file('pdf');
        if(!empty($pdf) && $pdf != null){
            $path               = hexdec(uniqid()).".".$pdf->extension();
            $pdf->move(public_path('upload/blog/'), $path);
            $data->pdf = 'upload/blog/'.$path;
        }

        $data->post_title       =   $request->post_title;
        $data->location       =   $request->location;
        $data->post_content     =   $request->post_content;
        if($request->language =='en'){
            $data->post_slug        =   trim(strtolower($request->post_slug));
        }else{
            $data->default_language_page = $request->default_language_page;
        }
        $data->post_type        =   'news';
        $data->blog_category_id =   $request->blog_category_id;
        $data->language         =   $request->language;
        $data->media_type         =   $request->media_type;
        $data->video_type         =   $request->video_type;
        $data->meta_key         =   $request->meta_key;
        $data->meta_title         =   $request->meta_title;
        $data->meta_description         =   $request->meta_description;
        $data->created_by       =   Auth::user()->id;

        $result=$data->save();
        if($result){
            $notification=array(
                'message'=>'Record Created Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('latest-news.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $data       =   Posts::find($id);
        return view('backend.latest_news.view',compact('data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $languages=Language::all();
        $data       =   Posts::find($id);
        $defaultLanguagePagesList=Posts::where('post_type','news')->where('language','en')->where('post_status','Published')->get();
        $categorys  =   BlogCategory::where('language','en')->where('type','news')->get();
        return view('backend.latest_news.edit',compact('data','languages','categorys','defaultLanguagePagesList'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'image'=>'nullable|mimes:jpg,png,jpeg,gif,svg',
            'pdf'=>'nullable|mimes:pdf',
            'post_title'=>'required',
            'post_content'=>'required',
            'blog_category_id'=>'required',
            'location'=>'required',
            'language'=>'required',
            'meta_key'=>'required',
            'meta_title'=>'required',
            'meta_description'=>'required',
            'post_status'=>'required',
            'video'=>'nullable|mimes:mp4,mov,ogg,qt',
            'media_type'=>'required',
        ]);

        if($request->language !='en'){
            $check_data=Posts::where('id','!=',$id)->where('default_language_page',$request->default_language_page)->where('language',$request->language)->count();
            if($check_data){
                $notification=array(
                    'message'=>'Title already exists!!.',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }

        $old_image=$request->old_image;
        $old_video=$request->old_video;

        $data= Posts::find($id);

        // ---------------------------------------------------------------------------------------------------
        if($request->media_type=='Image'){
            $image_name     =   $request->file('image');
            if($image_name ||$old_image){
                if($image_name){
                    $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
                    $path           =   public_path('upload/blog/'.$name_gen);
                    Image::make($image_name->getRealPath())->save($path);
                    $last_img       =   'upload/blog/'.$name_gen;
                    $data->image            =   $last_img;
                    if($old_image){
                        $unlink=@unlink($old_image);
                    }
                }
            }else{
                $notification=array(
                    'message'=>'Please Upload Image',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }elseif($request->media_type=='Video'){
            if($request->video_type=='MP4'){
                $video = $request->file('video');
                if((!empty($video) && $video != null) ||$old_video){
                    if(!empty($video) && $video != null){
                        $fileExentsion              = $video->extension();
                        $fileName                   = $video->getClientOriginalName();
                        $fileFullName               = time()."_".$fileName;
                        $path                       = Str::slug($fileFullName).".".$fileExentsion;
                        $video->move(public_path('upload/blog/'), $path);
                        $fullpath                   = 'upload/blog/'.$path;
                        $data->video            =   $fullpath;
                        if($old_video){
                            $unlink=@unlink($old_video);
                        }
                    }
                }else{
                    $notification=array(
                        'message'=>'Please Upload Video',
                        'alert-type'=>'warning'
                    );
                    return redirect()->back()->with($notification);
                }
            }elseif($request->video_type=='Youtube' && $request->youtube){
                $data->youtube            =   $request->youtube;
            }else{
                $notification=array(
                    'message'=>'Please Enter Youtube Link',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }
        // ---------------------------------------------------------------------------------------------------
        //pdf
        $pdf = $request->file('pdf');
        if(!empty($pdf) && $pdf != null){
            $path               = hexdec(uniqid()).".".$pdf->extension();
            $pdf->move(public_path('upload/blog/'), $path);
            $data->pdf = 'upload/blog/'.$path;
        }
        if($request->language !='en'){
            $data->default_language_page = $request->default_language_page;
        }
        $data->post_title       =   $request->post_title;
        $data->post_content     =   $request->post_content;
        $data->blog_category_id =   $request->blog_category_id;
        $data->location         =   $request->location;
        $data->language         =   $request->language;
        $data->meta_key         =   $request->meta_key;
        $data->meta_title         =   $request->meta_title;
        $data->meta_description         =   $request->meta_description;
        $data->post_status         =   $request->post_status;
        $data->media_type         =   $request->media_type;
        $data->video_type         =   $request->video_type;
        $data->created_at         =   $request->created_at;
        $data->updated_by=Auth::user()->id;
        $result=$data->update();

        if($result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('latest-news.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data       =   Posts::find($id);
        if($data->post_status=='Trash'){
            $result=$data->delete();
        }else{
            $data->post_status='Trash';
            $result=$data->update();
        }
        if($result){
            $notification=array(
                'message'=>'Record Delete Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('latest-news.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    public function GetCategoryName(Request $request){
        $code=$request->code;
        return BlogCategory::where('language',$code)->where('type','news')->get();
    }

    public function getCategory(Request $request)
    {
        if($request->id=='All'){
            $datas=Posts::where('post_type','news')->get();
            foreach($datas as $key =>$data){ ?>
                <tr>
                    <td><?= $key + 1  ?></td>
                    <td><?= $data->post_title  ?></td>
                    <td><?= $data->post_slug  ?></td>
                    <td><?= $data->created_at  ?></td>
                    <td><?= $data->post_status  ?></td>
                    <td>
                        <a href="<?=route('latest-news.preview',$data->id) ?>" class="btn btn-outline-success"><i class="fas fa-eye"></i></a>
                        <a href="<?=route('latest-news.edit',$data->id) ?>" class="btn btn-outline-info"><i class="fas fa-edit"></i></a>
                        <?php if($data->post_status=='Trash'){ ?>
                            <a href="<?=route('latest-news.delete',$data->id) ?>" onclick="return confirm('Are you sure you want to delete this item?');" class="btn btn-outline-danger"><i class="fas fa-trash"></i></a>
                        <?php }else{?>
                            <a href="<?=route('latest-news.delete',$data->id) ?>" onclick="return confirm('Are you sure you want to trash this item?');" class="btn btn-outline-warning" title="Trash Item"><i class="fas fa-trash"></i></a>
                        <?php } ?>
                    </td>
                </tr>
            <?php
            }
        }else{
            $datas=Posts::where('blog_category_id',$request->id)->where('post_type','news')->get();
            foreach($datas as $key =>$data){ ?>
                <tr>
                    <td><?= $key + 1  ?></td>
                    <td><?= $data->post_title  ?></td>
                    <td><?= $data->post_slug  ?></td>
                    <td><?= $data->created_at  ?></td>
                    <td><?= $data->post_status  ?></td>
                    <td>
                        <a href="<?=route('latest-news.preview',$data->id) ?>" class="btn btn-outline-success"><i class="fas fa-eye"></i></a>
                        <a href="<?=route('latest-news.edit',$data->id) ?>" class="btn btn-outline-info"><i class="fas fa-edit"></i></a>
                        <?php if($data->post_status=='Trash'){ ?>
                            <a href="<?=route('latest-news.delete',$data->id) ?>" onclick="return confirm('Are you sure you want to delete this item?');" class="btn btn-outline-danger"><i class="fas fa-trash"></i></a>
                        <?php }else{?>
                            <a href="<?=route('latest-news.delete',$data->id) ?>" onclick="return confirm('Are you sure you want to trash this item?');" class="btn btn-outline-warning" title="Trash Item"><i class="fas fa-trash"></i></a>
                        <?php } ?>
                    </td>
                </tr>
            <?php
            }
        }
    }
}
