<?php

namespace App\Http\Controllers\backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\CountryList;
use App\Models\StateList;
use App\Models\CallingCode;
use App\Models\PartnerDetailMetaData;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use App\Providers\EmailProvider;
use App\Models\EmailManagement;
use App\Models\PartnerNotification;
use stdClass;
use App\Providers\MessageManagementProvider;
use App\Exports\AdminPartnerList;
use Maatwebsite\Excel\Facades\Excel;

class PartnerManagementAdminController extends Controller
{
    public function index(Request $request){
        $code= $request->code;
        $company= $request->company;
        $email= $request->email;
        $phone= $request->phone;
        $country= $request->country;
        $agreement_expire= $request->agreement_expire;
        $agreement_from_date= $request->agreement_from_date;
        $agreement_to_date= $request->agreement_to_date;

        $countryList=CountryList::all();
        //$datas=User::where('status','N')->where('role','Partner')->orderBy('id','DESC')->paginate(10);
        $datas = User::where('status', 'N')
            ->where('role', 'Partner')
            ->where(function($query) use ($code, $phone, $email, $country, $company, $agreement_expire, $agreement_from_date, $agreement_to_date) {
                if (!is_null($code) && $code !== '') {
                    $query->where('code', 'like', "%{$code}%");
                }

                if (!is_null($phone) && $phone !== '') {
                    $query->orWhere('phone', 'like', "%{$phone}%");
                }

                if (!is_null($email) && $email !== '') {
                    $query->orWhere('email', 'like', "%{$email}%");
                }

                if (!is_null($country) && $country !== '') {
                    $query->orWhere('country', 'like', "%{$country}%");
                }

                if (!is_null($company) && $company !== '') {
                    $query->orWhere('company', 'like', "%{$company}%");
                }

                if (!is_null($agreement_expire) && $agreement_expire == 'Y') {
                    $query->Where('agreement_to_date', '<', date('Y-m-d'));
                }

                if (!is_null($agreement_expire) && $agreement_expire=='N' && !is_null($agreement_from_date) && $agreement_from_date !== '' && !is_null($agreement_to_date) && $agreement_to_date !== '') {
                    $query->WhereBetween('agreement_to_date', [$agreement_from_date, $agreement_to_date]);
                }elseif (!is_null($agreement_expire) && $agreement_expire=='N' && !is_null($agreement_from_date) && $agreement_from_date !== '') {
                    $query->Where('agreement_to_date', '>=', $agreement_from_date);
                }elseif (!is_null($agreement_expire) && $agreement_expire=='N' && !is_null($agreement_to_date) && $agreement_to_date !== '') {
                    $query->Where('agreement_to_date', '<=', $agreement_to_date);
                }

            })
            ->orderBy('id', 'DESC')
            ->paginate(10);


        return view('backend.partner.registration.index',compact('datas', 'countryList','code','company','email','phone','country','agreement_expire','agreement_from_date','agreement_to_date'));
    }

    public function show($id){
        //---------------------------------------------------------------
        $partner_details=PartnerDetailMetaData::where('user_id',$id)->get();
        //-------------------------------------------------------------------
        $data=User::find($id);
        return view('backend.partner.registration.show', compact('data','partner_details'));
    }

    public function edit($id){
        //---------------------------------------------------------------
        $partner_details=PartnerDetailMetaData::where('user_id',$id)->get();
        $country_list = CountryList::all();
        $state_list = StateList::all();
        $calling_code_list=CallingCode::all();
        //-------------------------------------------------------------------
        $data=User::find($id);
        return view('backend.partner.registration.edit',compact('data','country_list','state_list','calling_code_list','partner_details'));
    }

    public function update(Request $request, $id){
        $validateData=$request->validate([
            'email'=>'required|unique:users,email,'.$id,
            'f_name'=>'required|min:2',
            'l_name'=>'required|min:2',
            'company'=>'required|min:2',
            'country'=>'required|min:2',
            'code'=>'required|min:2',
            'calling_code'=>'required',
            'phone' => 'required|numeric',
            'pincode' => strtolower($request->country) === 'ae' ? 'nullable' : 'required|numeric',
            'statelist' => strtolower($request->country) === 'in' ? 'required' : 'nullable',
            'partner_commission_percentage'=>'nullable|numeric',
        ]);

        try{
            $data= User::find($id);
            //--------------------------------
            if(! User::where('code', $request->code)->orWhere('partner_code', $request->code)->exists()){
                $data->code=$request->code;
            }
            
            $data->f_name=ucwords($request->f_name);
            $data->l_name=ucwords($request->l_name);
            $data->phone=$request->phone;
            $data->email=$request->email;
            $data->company=$request->company;
            $data->country=$request->country;
            $data->state=($request->country=='IN')?$request->statelist:NULL;
            $data->city=$request->city;
            $data->address=$request->address;
            $data->pincode=($request->country=='AE')?Null:$request->pincode;
            $data->calling_code=$request->calling_code;
            $data->agreement_from_date=$request->agreement_from_date;
            $data->agreement_to_date=$request->agreement_to_date;
            $data->partner_commission_percentage=number_format($request->partner_commission_percentage,2,'.','');
            $data->updated_by=Auth::user()->id;
            $data->save();

            //meta data
            $allFileSlug=array('pan_card_copy','aadhar_card_copy','company_address_proof','company_registration_copy','passport_copy','passport_copy','passport_copy','kyc_form','acra_profile_copy','tax_registration_document','passport_size_photo','partners_signature_copy','partner_contract');
            $rejectFieldsCount=0;
            $approveFieldsCount=0;
            $processFieldsCount=0;
            $partnerContractStatus='';

            $metaData=$request->data1;
            if(is_array($metaData)){
                $rejectedFileList=array();
                $rejectedFieldsData='<table width="100%"><thead><tr><td>Field Name</td><td>Entred Data / Uploaded Document</td><td>Remarks</td></tr></thead><tbody>';

                foreach($metaData as $meta){
                    if(is_array($meta)){
                        $child=PartnerDetailMetaData::find($meta['child_id']);
                        $child->verify= (@$meta['verify'])?@$meta['verify']:NULL;
                        $child->remarks= @$meta['remarks'];
                        $child->save();
                        if(@$meta['verify']=='Reject'){
                            if(@$child->key=='partner_contract'){
                                $partnerContractStatus='Reject';
                            }
                            $rejectedFieldsData .='<tr><td>'.ucfirst(str_replace('_',' ',$child->key)).'</td>';
                            if (in_array($child->key,$allFileSlug)){
                                $rejectedFieldsData .='<td><a href="'.url($child->value).'" target="_blank">View</a></td>';
                                $rejectedFileList[]=$child->value;
                            }else{
                                $rejectedFieldsData .='<td>'.$child->value.'</td>';
                            }
                            $rejectedFieldsData .='<td>'.$child->remarks.'</td></tr>';

                            $rejectFieldsCount++;
                        }elseif(@$meta['verify']=='Approve'){
                            if(@$child->key=='partner_contract'){
                                $partnerContractStatus='Approve';
                            }
                            $approveFieldsCount++;
                        }else{
                            $processFieldsCount++;
                        }
                    }
                }
                $rejectedFieldsData .= '</tbody></table>';
            }

            //mail
            $value=new stdClass();
            $value->f_name=$request->f_name;
            $value->l_name=$request->l_name;
            $value->BecomeAPartnerRegistrationRejectedDocumentOrFields=$rejectedFieldsData;
            $support_team_email_list=EmailManagement::where('key','support_team_email')->first();
            if(@$rejectFieldsCount>0){
                if($partnerContractStatus=='Reject'){
                    EmailProvider::Email('become_a_partner_registration_reject_partner_contract_for_partner', $request->email, $value, $rejectedFileList );
                    EmailProvider::Email('become_a_partner_registration_reject_partner_contract_for_support', $support_team_email_list->title, $value, $rejectedFileList );
                    //partner notification
                    $item= new PartnerNotification();
                    $item->user_id=$id;
                    $item->notification=MessageManagementProvider::MessageManage('admin-reject-contract-document');
                    $item->save();
                }else{
                    EmailProvider::Email('become_a_partner_registration_rejecting_document_or_fields_for_partner', $request->email, $value, $rejectedFileList );
                    EmailProvider::Email('become_a_partner_registration_rejecting_document_or_fields_for_support', $support_team_email_list->title, $value, $rejectedFileList );
                    //partner notification
                    $item= new PartnerNotification();
                    $item->user_id=$id;
                    $item->notification=MessageManagementProvider::MessageManage('admin-reject-kyc-document');
                    $item->save();
                }
            }elseif($processFieldsCount==0 && $approveFieldsCount>0){
                if($partnerContractStatus=='Approve'){
                    EmailProvider::Email('become_a_partner_registration_complete_all_verification_for_partner', $request->email, $value );
                    EmailProvider::Email('become_a_partner_registration_complete_all_verification_for_support', $support_team_email_list->title, $value );
                    //partner notification
                    $item= new PartnerNotification();
                    $item->user_id=$id;
                    $item->notification=MessageManagementProvider::MessageManage('registration-completed-successfully');
                    $item->save();
                }else{
                    EmailProvider::Email('become_a_partner_registration_approve_all_documents_or_fields_upto_page_7_for_partner', $request->email, $value );
                    EmailProvider::Email('become_a_partner_registration_approve_all_documents_or_fields_upto_page_7_for_support', $support_team_email_list->title, $value );
                    //partner notification
                    $item= new PartnerNotification();
                    $item->user_id=$id;
                    $item->notification=MessageManagementProvider::MessageManage('please-update-contract');
                    $item->save();
                }
            }

            $notification=array(
                'message'=>'Partner Update Successfully!!',
                'alert-type'=>'info'
            );
            return redirect()->route('admin.partner.view')->with($notification);
        }catch(\Exception $e){
            Log::error($e);
            return redirect()->back();
        }
    }

    public function destroy($id){
        $data=User::find($id);
        $data->deleted_by=Auth::user()->id;
        $data->status='Y';
        $data->deleted_datetime=date('Y-m-d H:i:s');
        $result=$data->update();

        $notification=array(
            'message'=>'Partner Delete Successfully!!',
            'alert-type'=>'info'
        );
        return redirect()->back()->with($notification);
    }

    public function inActiveUser(){
        $datas=User::where('status','Y')->where('role','Partner')->orderBy('id','DESC')->get();
        return view('backend.partner.registration.inactive',compact('datas'));
    }

    public function inActiveUserEdit($id){
        $data=User::find($id);
        $data->updated_by=Auth::user()->id;
        $data->status='N';
        $result=$data->update();

        $notification=array(
            'message'=>'Partner Active Successfully!!',
            'alert-type'=>'info'
        );
        return redirect()->back()->with($notification);
    }

    public function ExcelExport(Request $request){
        try{
            $code = $request->code;
            $company = $request->company;
            $email = $request->email;
            $phone = $request->phone;
            $country = $request->country;
            $agreement_expire = $request->agreement_expire;
            $agreement_from_date = $request->agreement_from_date;
            $agreement_to_date = $request->agreement_to_date;

            $datas = User::where('status', 'N')
                ->where('role', 'Partner')
                ->where(function($query) use ($code, $phone, $email, $country, $company, $agreement_expire, $agreement_from_date, $agreement_to_date) {
                    if (!is_null($code) && $code !== '') {
                        $query->where('code', 'like', "%{$code}%");
                    }

                    if (!is_null($phone) && $phone !== '') {
                        $query->orWhere('phone', 'like', "%{$phone}%");
                    }

                    if (!is_null($email) && $email !== '') {
                        $query->orWhere('email', 'like', "%{$email}%");
                    }

                    if (!is_null($country) && $country !== '') {
                        $query->orWhere('country', 'like', "%{$country}%");
                    }

                    if (!is_null($company) && $company !== '') {
                        $query->orWhere('company', 'like', "%{$company}%");
                    }

                    if (!is_null($agreement_expire) && $agreement_expire == 'Y') {
                        $query->Where('agreement_to_date', '<', date('Y-m-d'));
                    }

                    if (!is_null($agreement_expire) && $agreement_expire == 'N') {
                        if (!is_null($agreement_from_date) && $agreement_from_date !== '' && !is_null($agreement_to_date) && $agreement_to_date !== '') {
                            $query->whereBetween('agreement_to_date', [$agreement_from_date, $agreement_to_date]);
                        } elseif (!is_null($agreement_from_date) && $agreement_from_date !== '') {
                            $query->where('agreement_to_date', '>=', $agreement_from_date);
                        } elseif (!is_null($agreement_to_date) && $agreement_to_date !== '') {
                            $query->where('agreement_to_date', '<=', $agreement_to_date);
                        }
                    }

                })
                ->orderBy('id', 'DESC')
                ->get();

            if (!$datas->isEmpty()) {
                return Excel::download(new AdminPartnerList($datas), 'Partner-List.xlsx');
            } else {
               return redirect()->back();
            }
        }catch(\Exception $e){
            Log::info('AdminPartnerList excel: ' . $e);
            return redirect()->back();
        }
    }

}
