<?php

namespace App\Http\Controllers\backend\operation;

use App\Http\Controllers\Controller;
use App\Models\SubscriptionNextBilling;
use Illuminate\Http\Request;
use App\Models\Subscription;
use App\Models\OrderMeta;
use App\Models\Transaction;
use App\Exports\AdminSubscriptionExport;
use Maatwebsite\Excel\Facades\Excel;
use DataTables;
use Illuminate\Support\Facades\DB;
use App\Providers\SubscriptionNotificationProvider;

class LobSubscriptionDetailController extends Controller
{
    public function index(Request $request){

        if($request->ajax()){
            $products = Subscription::select(
                    'subscriptions.id',
                    'subscriptions.serial_number',
                    'subscriptions.plan_name',
                    'subscriptions.plan_duration',
                    'subscriptions.country_code',
                    'subscriptions.currency_code',
                    'subscriptions.rate',
                    'subscriptions.quantity',
                    'subscriptions.total_rate',
                    'subscriptions.tax',
                    'subscriptions.grand_amount',
                    'subscriptions.start_at',
                    'subscriptions.end_at',
                    'subscriptions.status',
                    'subscriptions.remarks',
                    'users.partner_code',
                    DB::raw('CONCAT_WS(" ", users.f_name, users.l_name) as name'),
                    'industries.title as industry_title'
                )
                ->join('users', 'subscriptions.user_id', '=', 'users.id')
                ->join('pricings', 'subscriptions.plan_id', '=', 'pricings.id')
                ->join('industries', 'pricings.lob_id', '=', 'industries.id');
            //from date to date filter
            if($request->filled('subscription_from_date') && $request->filled('subscription_to_date')){
                $products = $products->whereBetween('subscriptions.created_at', [$request->subscription_from_date, $request->subscription_to_date]);
            }elseif($request->filled('subscription_from_date')){
                $products = $products->where('subscriptions.created_at', '>=', $request->subscription_from_date);
            }elseif($request->filled('subscription_to_date')){
                $products = $products->where('subscriptions.created_at', '<=', $request->subscription_to_date);
            }
            //subscription_partner_code
            if($request->filled('subscription_partner_code')){
                $products = $products->where('users.partner_code', $request->subscription_partner_code);
            }
            //subscription_user_code
            if($request->filled('subscription_user_code') ){
                $products = $products->where('users.code', $request->subscription_user_code);
            }   
            //subscription_status
            if($request->filled('subscription_status') ){
                $products = $products->where('subscriptions.status', $request->subscription_status);
            } 
            //subscription_lob
            if($request->filled('subscription_lob') ){
                $products = $products->where('subscriptions.plan_id', $request->subscription_lob);
            } 
            //subscription_plan_name
            if($request->filled('subscription_plan_name') ){
                $products = $products->where('subscriptions.plan_name', $request->subscription_plan_name);
            } 
            //subscription_plan_duration
            if($request->filled('subscription_plan_duration') ){
                $products = $products->where('subscriptions.plan_duration', $request->subscription_plan_duration);
            }

            return DataTables::of($products)
                ->addColumn('action', function($data) {
                    return '<a href="'.route('lob.subscription.preview',$data->id).'" class="btn btn-outline-success"><i class="fas fa-eye"></i></a>
                        <button type="button" data-id="'.$data->id.'" class="btn btn-outline-info lob-subscription-model-button-new"><i class="fas fa-edit"></i></button>
                        <button type="button" data-id="'.$data->id.'" class="btn btn-outline-info lob-subscription-model-next-billing"><i class="fa fa-newspaper"></i></button>
                    ';
                        //<button type="button" id="model_'.$data->id.'" data-id="'.$data->id.'" data-remarks="'.$data->remarks.'" data-status="'.$data->status.'" class="btn btn-outline-info lob-subscription-model-button"><i class="fas fa-edit"></i></button>
                })
                
                ->addIndexColumn()
                ->rawColumns(['action'])  // Allow HTML in the 'action' column
                ->make(true);
        }
        
        return view('backend.operation.subscription.index');
    }

    public function show($id){
        $data=Subscription::find($id);
        return view('backend.operation.subscription.view',compact('data'));
    }

    public function edit(Request $request){
        try{
            $id=$request->id;
            $status=$request->status;
            $remarks=$request->remarks;

            $data=Subscription::find($id);
            $oldStatus=$data->status;
            if($data->start_at =='' && $data->end_at=='' && $status=='Active'){
                //transaction
                $transaction = Transaction::where('subscription_id', $id)->orderBy('id', 'desc')->first();
                if($transaction){
                    $transaction->status='Success';
                    $transaction->save();
                }else{
                    $transaction=new Transaction();
                    $transaction->subscription_id=$id;
                    $transactionID=hexdec(uniqid());
                    $transaction->transaction_id=$transactionID;
                    $transaction->status='Success';
                    $transaction->message='Offline';
                    $transaction->amount=$data->grand_amount;
                    $transaction->currency=$data->currency_code;
                    $transaction->save();
                }

                if($data->plan_duration=='MTH'){
                    $currentDate = date('Y-m-d H:i:s'); // Get the current date
                    $futureDate = date('Y-m-d H:i:s', strtotime($currentDate . ' +30 days'));
                }elseif($data->plan_duration=='QTR'){
                    $currentDate = date('Y-m-d H:i:s'); // Get the current date
                    $futureDate = date('Y-m-d H:i:s', strtotime($currentDate . ' +90 days'));
                }elseif($data->plan_duration=='YLY'){
                    $currentDate = date('Y-m-d H:i:s'); // Get the current date
                    $futureDate = date('Y-m-d H:i:s', strtotime($currentDate . ' +365 days'));
                }else{
                    $currentDate=NULL;
                    $futureDate=NULL;
                }
                $data->start_at=$currentDate;
                $data->end_at=$futureDate;

                
                
            }
            $data->status=$status;
            $data->remarks=$remarks;
            $result=$data->save();
            if($data->start_at =='' && $data->end_at=='' && $status=='Active'){
                //notification and mail
                SubscriptionNotificationProvider::Notification($data->id);
            }elseif($status != $oldStatus){
                //admin_status_change_subscription
                SubscriptionNotificationProvider::Notification($data->id, true);
            }
            if($result){
                $notification=array(
                    'message'=>'Record Updated Successfully!!',
                    'alert-type'=>'success'
                );
                return response()->json($notification);
            }else{
                $notification=array(
                    'message'=>'Something Wrong!!',
                    'alert-type'=>'error'
                );
                return response()->json($notification);
            }
        }catch(\Exception $e){
            $notification=array(
                'message'=>$e,
                'alert-type'=>'error'
            );
            return response()->json($notification);
        }
    }

    public function excel(Request $request){
        $products = Subscription::join('users', 'subscriptions.user_id', '=', 'users.id')
            ->join('pricings', 'subscriptions.plan_id', '=', 'pricings.id')
            ->join('industries', 'pricings.lob_id', '=', 'industries.id');
        //from date to date filter
        if($request->filled('subscription_from_date') && $request->filled('subscription_to_date')){
            $products = $products->whereBetween('subscriptions.created_at', [$request->subscription_from_date, $request->subscription_to_date]);
        }elseif($request->filled('subscription_from_date')){
            $products = $products->where('subscriptions.created_at', '>=', $request->subscription_from_date);
        }elseif($request->filled('subscription_to_date')){
            $products = $products->where('subscriptions.created_at', '<=', $request->subscription_to_date);
        }
        //subscription_partner_code
        if($request->filled('subscription_partner_code')){
            $products = $products->where('users.partner_code', $request->subscription_partner_code);
        }
        //subscription_user_code
        if($request->filled('subscription_user_code') ){
            $products = $products->where('users.code', $request->subscription_user_code);
        }   
        //subscription_status
        if($request->filled('subscription_status') ){
            $products = $products->where('subscriptions.status', $request->subscription_status);
        } 
        //subscription_lob
        if($request->filled('subscription_lob') ){
            $products = $products->where('subscriptions.plan_id', $request->subscription_lob);
        } 
        //subscription_plan_name
        if($request->filled('subscription_plan_name') ){
            $products = $products->where('subscriptions.plan_name', $request->subscription_plan_name);
        } 
        //subscription_plan_duration
        if($request->filled('subscription_plan_duration') ){
            $products = $products->where('subscriptions.plan_duration', $request->subscription_plan_duration);
        }
        $products = $products->orderBy('subscriptions.id', 'DESC');
        $products = $products->get();

        return Excel::download(new AdminSubscriptionExport($products), 'subscription.xlsx');
    }
    
    public function editPopup(Request $request){
        $data=Subscription::find($request->id);
        $transaction = Transaction::where('subscription_id', $data->id)->orderBy('id', 'desc')->first();
        if(!$transaction){
            $transaction=new Transaction();
            $transaction->subscription_id=$request->id;
            $transaction->save();
        }
        return view('backend.operation.subscription.popup',compact('data', 'transaction'));
    }
    public function updatePopup(Request $request){
        try{
            $data=Subscription::find($request->id);
            $oldStatus=$data->status;
            $oldStart_at=$data->start_at;
            $oldEnd_at=$data->end_at;

            //transaction
            $transaction = Transaction::where('subscription_id', $data->id)->orderBy('id', 'desc')->first();
            if($transaction){
                $transaction->status=$request->payment_status;
                $transaction->transaction_id=$request->transaction_id;
                $transaction->payment_date=$request->payment_date;
                $transaction->amount=$request->grand_amount;
                $transaction->save();
            }else{
                $transaction=new Transaction();
                $transaction->subscription_id=$data->id;
                //$transactionID=hexdec(uniqid());
                $transaction->transaction_id=$request->transaction_id;
                $transaction->status=$request->payment_status;
                $transaction->payment_date=$request->payment_date;
                $transaction->message='Offline';
                $transaction->amount=$request->grand_amount;
                $transaction->currency=$data->currency_code;
                $transaction->save();
            }
            //subscription date
            if($oldStart_at=='' && $oldEnd_at=='' && $request->status=='Active' && $request->start_at=='' && $request->end_at==''){
                if($data->plan_duration=='MTH'){
                    $currentDate = date('Y-m-d H:i:s'); // Get the current date
                    $futureDate = date('Y-m-d H:i:s', strtotime($currentDate . ' +30 days'));
                }elseif($data->plan_duration=='QTR'){
                    $currentDate = date('Y-m-d H:i:s'); // Get the current date
                    $futureDate = date('Y-m-d H:i:s', strtotime($currentDate . ' +90 days'));
                }elseif($data->plan_duration=='YLY'){
                    $currentDate = date('Y-m-d H:i:s'); // Get the current date
                    $futureDate = date('Y-m-d H:i:s', strtotime($currentDate . ' +365 days'));
                }else{
                    $currentDate=NULL;
                    $futureDate=NULL;
                }
                $data->start_at=$currentDate;
                $data->end_at=$futureDate;
            }else{
                $data->start_at=$request->start_at;
                $data->end_at=$request->end_at;
            }


            $data->grand_amount=$request->grand_amount;
            $data->status=$request->status;
            $data->remarks=$request->remarks;
            $data->quantity=$request->quantity;
            $result=$data->save();

            if($oldStart_at=='' && $oldEnd_at=='' && $request->status=='Active'){
                //notification and mail
                SubscriptionNotificationProvider::Notification($data->id);
            }elseif($request->status != $oldStatus){
                //admin_status_change_subscription
                SubscriptionNotificationProvider::Notification($data->id, true);
            }
            if($result){
                $notification=array(
                    'message'=>'Record Updated Successfully!!',
                    'alert-type'=>'success'
                );
                return response()->json($notification);
            }else{
                $notification=array(
                    'message'=>'Something Wrong!!',
                    'alert-type'=>'error'
                );
                return response()->json($notification);
            }
        }catch(\Exception $e){
            $notification=array(
                'message'=>$e,
                'alert-type'=>'error'
            );
            return response()->json($notification);
        }
    }
    //next billing Cycle
    public function editNextBilling(Request $request){
        $subscription_id = $request->id;
        $subscription = Subscription::find($subscription_id);
        $subscriptionNextBilling = SubscriptionNextBilling::where('subscription_id', $subscription_id)->first();
        
        $quantity = ($subscriptionNextBilling && $subscriptionNextBilling->quantity)?$subscriptionNextBilling->quantity:$subscription->quantity;
        $plan_rate = ($subscriptionNextBilling && $subscriptionNextBilling->plan_rate)?$subscriptionNextBilling->plan_rate:$subscription->plan_rate;
        
        return view('backend.operation.subscription.next-billing',compact('subscription', 'subscription_id', 'quantity', 'plan_rate'));
    }

    public function updateNextBilling(Request $request){
        $subscription_id = $request->id;
        $quantity = $request->quantity;
        $plan_rate = $request->plan_rate;
        SubscriptionNextBilling::where('subscription_id', $subscription_id)->delete();
        if($quantity || $plan_rate){
            $data = new SubscriptionNextBilling();
            $data->subscription_id = $subscription_id;
            $data->quantity = $quantity;
            $data->plan_rate = $plan_rate;
            $data->save();
        }
        $notification=array(
            'message'=>'Record Updated Successfully!!',
            'alert-type'=>'success'
        );
        return response()->json($notification);
    }

}
