<?php

namespace App\Http\Controllers\backend\page\contact_us;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Language;
use Intervention\Image\Facades\Image;
use App\Models\ContactUs;
use App\Models\ContactUsGlobalOffices;

class ContactUsController extends Controller
{
    public function index()
    {
        $datas=ContactUs::all();
        return view('backend.page.contact-us.index',compact('datas'));
    }

    public function create()
    {
        $languages      =   Language::all();
        return view('backend.page.contact-us.add',compact('languages'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'title'=>'required',
            'slug'=>'required',
            'banner_image'=>'required|image|mimes:jpeg,png,jpg,gif,svg',
            'map'=>'required|image|mimes:jpeg,png,jpg,gif,svg',
            'lets_connect_text'=>'required',
            'first_name_text'=>'required',
            'last_name_text'=>'required',
            'email_text'=>'required',
            'phone_text'=>'required',
            'corporate_headquarters_text'=>'required',
            'link_text'=>'required',
            'link_link'=>'required',
            'address'=>'required',
            'global_offices_text'=>'required',
            'language'=>'required',
            'meta_key'=>'required',
            'meta_title'=>'required',
            'meta_description'=>'required',
        ]);
        $check_data=ContactUs::where('slug',$request->slug)->where('language',$request->language)->count();
        if($check_data){
            $notification=array(
                'message'=>'Title already exists!!.',
                'alert-type'=>'warning'
            );
            return redirect()->back()->with($notification);
        }

        $data    =   new ContactUs();
        //--------------------------------------
        $image_1_name     =   $request->file('banner_image');
        $image_1_name_gen       =   hexdec(uniqid()).'.'.$image_1_name->getClientOriginalExtension();
        $path           =   public_path('upload/contact/'.$image_1_name_gen);
        Image::make($image_1_name->getRealPath())->save($path);
        $last_img       =   'upload/contact/'.$image_1_name_gen;
        $data->banner_image            =   $last_img;
        //--------------------------------------
        $image_1_name     =   $request->file('map');
        $image_1_name_gen       =   hexdec(uniqid()).'.'.$image_1_name->getClientOriginalExtension();
        $path           =   public_path('upload/contact/'.$image_1_name_gen);
        Image::make($image_1_name->getRealPath())->save($path);
        $last_img       =   'upload/contact/'.$image_1_name_gen;
        $data->map            =   $last_img;
        //--------------------------------------

        $data->title       =   $request->title;
        $data->slug        =   trim(strtolower($request->slug));

        $data->lets_connect_text     =   $request->lets_connect_text;
        $data->first_name_text     =   $request->first_name_text;
        $data->last_name_text     =   $request->last_name_text;
        $data->email_text     =   $request->email_text;
        $data->phone_text     =   $request->phone_text;
        $data->corporate_headquarters_text     =   $request->corporate_headquarters_text;
        $data->link_text     =   $request->link_text;
        $data->link_link     =   $request->link_link;
        $data->address     =   $request->address;
        $data->global_offices_text     =   $request->global_offices_text;

        $data->language         =   $request->language;
        $data->meta_key         =   $request->meta_key;
        $data->meta_title         =   $request->meta_title;
        $data->meta_description         =   $request->meta_description;
        $data->created_by       =   Auth::user()->id;
        $result=$data->save();

        if($result){
            $notification=array(
                'message'=>'Record Created Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('page.contact-us.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $languages  =Language::all();
        $data       =   ContactUs::find($id);
        return view('backend.page.contact-us.edit',compact('data','languages'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'title'=>'required',
            'banner_image'=>'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'map'=>'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'lets_connect_text'=>'required',
            'first_name_text'=>'required',
            'last_name_text'=>'required',
            'email_text'=>'required',
            'phone_text'=>'required',
            'corporate_headquarters_text'=>'required',
            'link_text'=>'required',
            'link_link'=>'required',
            'address'=>'required',
            'global_offices_text'=>'required',
            'language'=>'required',
            'meta_key'=>'required',
            'meta_title'=>'required',
            'meta_description'=>'required',
        ]);
        $old_banner_image=$request->old_banner_image;
        $old_map=$request->old_map;

        $check_data=ContactUs::where('id','!=',$id)->where('slug',$request->slug)->where('language',$request->language)->count();
        if($check_data){
            $notification=array(
                'message'=>'Title already exists!!.',
                'alert-type'=>'warning'
            );
            return redirect()->back()->with($notification);
        }

        $data    = ContactUs::find($id);
        //--------------------------------------
        $image_1_name     =   $request->file('banner_image');
        if($image_1_name){
            $image_1_name_gen       =   hexdec(uniqid()).'.'.$image_1_name->getClientOriginalExtension();
            $path           =   public_path('upload/contact/'.$image_1_name_gen);
            Image::make($image_1_name->getRealPath())->save($path);
            $last_img       =   'upload/contact/'.$image_1_name_gen;
            $data->banner_image            =   $last_img;
            if($old_banner_image){
                $unlink=@unlink($old_banner_image);
            }
        }
        //--------------------------------------
        $image_1_name     =   $request->file('map');
        if($image_1_name){
            $image_1_name_gen       =   hexdec(uniqid()).'.'.$image_1_name->getClientOriginalExtension();
            $path           =   public_path('upload/contact/'.$image_1_name_gen);
            Image::make($image_1_name->getRealPath())->save($path);
            $last_img       =   'upload/contact/'.$image_1_name_gen;
            $data->map            =   $last_img;
            if($old_map){
                $unlink=@unlink($old_map);
            }
        }
        //--------------------------------------

        $data->title       =   $request->title;
        // $data->slug        =   trim(strtolower($request->slug));
        $data->lets_connect_text     =   $request->lets_connect_text;
        $data->first_name_text     =   $request->first_name_text;
        $data->last_name_text     =   $request->last_name_text;
        $data->email_text     =   $request->email_text;
        $data->phone_text     =   $request->phone_text;
        $data->corporate_headquarters_text     =   $request->corporate_headquarters_text;
        $data->link_text     =   $request->link_text;
        $data->link_link     =   $request->link_link;
        $data->address     =   $request->address;
        $data->global_offices_text     =   $request->global_offices_text;

        $data->language         =   $request->language;
        $data->meta_key         =   $request->meta_key;
        $data->meta_title         =   $request->meta_title;
        $data->meta_description         =   $request->meta_description;
        $data->status         =   $request->status;
        $data->updated_by=Auth::user()->id;
        $result=$data->update();

        if($result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('page.contact-us.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data       =   ContactUs::find($id);
        if($data->status=='Trash'){
            $dataCheck=ContactUsGlobalOffices::where('contact_us_id',$id)->count();
            if($dataCheck==0 ){
                $result=$data->delete();
            }else{
                $notification=array(
                    'message'=>'First delete associated Category!!',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }else{
            $data->status='Trash';
            $result=$data->update();
        }
        if($result){
            $notification=array(
                'message'=>'Record Delete Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->back()->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
}
