<?php

namespace App\Http\Controllers\backend\page\contact_us;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Language;
use Intervention\Image\Facades\Image;
use App\Models\ContactUs;
use App\Models\ContactUsGlobalOffices;
use App\Models\ContactUsGlobalOfficesAddress;

class ContactUsGlobalOfficesAddressController extends Controller
{
    public function index($contact_us_id, $contact_us_global_office_id)
    {
        $datas=ContactUsGlobalOfficesAddress::where('contact_us_global_office_id',$contact_us_global_office_id)->get();
        return view('backend.page.contact-us.global-office.address',compact('datas','contact_us_id','contact_us_global_office_id'));
    }

    public function update(Request $request, $contact_us_id, $contact_us_global_office_id)
    {
        $request->validate([
            'row.*.image'=>'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'row.*.title'=>'required',
            'row.*.description'=>'required',
            'row.*.link'=>'nullable|url'
        ]);
        foreach ($request->row as $photo){
            if(@$photo['old_id']){
                $data= ContactUsGlobalOfficesAddress::find($photo['old_id']);
                $image_name     =  @$photo['image'];
                if($image_name){
                    $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
                    $path           =   public_path('upload/contact/'.$name_gen);
                    Image::make($image_name->getRealPath())->save($path);
                    $last_img       =   'upload/contact/'.$name_gen;
                    $data->image  =   $last_img;
                    if($photo['old_image']){
                        $unlink=@unlink($photo['old_image']);
                    }
                }

                $data->title=$photo['title'];
                $data->link=$photo['link'];
                $data->description=$photo['description'];
                $data->updated_by=Auth::user()->id;
                $result=$data->save();
            }
            else{
                $image_name     =  @$photo['image'];
                if($image_name){
                    $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
                    $path           =   public_path('upload/contact/'.$name_gen);
                    Image::make($image_name->getRealPath())->save($path);
                    $last_img       =   'upload/contact/'.$name_gen;

                    $data    =   new ContactUsGlobalOfficesAddress();
                    $data->image  =   $last_img;
                    $data->contact_us_id =$contact_us_id;
                    $data->contact_us_global_office_id =$contact_us_global_office_id;
                    $data->title=$photo['title'];
                    $data->link=$photo['link'];
                    $data->description=$photo['description'];
                    $data->created_by=Auth::user()->id;
                    $result=$data->save();
                }
            }
        }
        if(@$result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('page.contact-us.global-office.list',$contact_us_id)->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    public function destroy(Request $request)
    {
        $id=$request->id;
        ContactUsGlobalOfficesAddress::where('id',$id)->delete();
        exit;
    }
}
