<?php

namespace App\Http\Controllers\backend\page\event;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Event;
use App\Models\EventDate;
use App\Models\Language;
use Intervention\Image\Facades\Image;

class EventController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $datas=Event::all();
        return view('backend.page.event.index',compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $languages      =   Language::all();
        return view('backend.page.event.add',compact('languages'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'title'=>'required',
            'slug'=>'required',
            'banner_image'=>'required|image|mimes:jpeg,png,jpg,gif,svg',
            'sub_title'=>'required',
            'form_title'=>'required',
            'form_submit_message'=>'required',
            'language'=>'required',
            'meta_key'=>'required',
            'meta_title'=>'required',
            'meta_description'=>'required',
        ]);
        $check_data=Event::where('slug',$request->slug)->where('language',$request->language)->count();
        if($check_data){
            $notification=array(
                'message'=>'Title already exists!!.',
                'alert-type'=>'warning'
            );
            return redirect()->back()->with($notification);
        }

        $data    =   new Event();
        //--------------------------------------
        $image_1_name     =   $request->file('banner_image');
        $image_1_name_gen       =   hexdec(uniqid()).'.'.$image_1_name->getClientOriginalExtension();
        $path           =   public_path('upload/event/'.$image_1_name_gen);
        Image::make($image_1_name->getRealPath())->save($path);
        $last_img       =   'upload/event/'.$image_1_name_gen;
        $data->banner_image            =   $last_img;
        //--------------------------------------

        $data->title       =   $request->title;
        $data->slug        =   trim(strtolower($request->slug));
        $data->sub_title     =   $request->sub_title;
        $data->form_title     =   $request->form_title;
        $data->form_submit_message     =   $request->form_submit_message;

        $data->language         =   $request->language;
        $data->meta_key         =   $request->meta_key;
        $data->meta_title         =   $request->meta_title;
        $data->meta_description         =   $request->meta_description;
        $data->created_by       =   Auth::user()->id;
        $result=$data->save();

        if($result){
            $notification=array(
                'message'=>'Record Created Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('page.event.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $languages  =Language::all();
        $data       =   Event::find($id);
        return view('backend.page.event.edit',compact('data','languages'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'title'=>'required',
            'slug'=>'required',
            'banner_image'=>'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'sub_title'=>'required',
            'form_title'=>'required',
            'form_submit_message'=>'required',
            'language'=>'required',
            'meta_key'=>'required',
            'meta_title'=>'required',
            'meta_description'=>'required',
        ]);
        $old_banner_image=$request->old_banner_image;

        $check_data=Event::where('id','!=',$id)->where('slug',$request->slug)->where('language',$request->language)->count();
        if($check_data){
            $notification=array(
                'message'=>'Title already exists!!.',
                'alert-type'=>'warning'
            );
            return redirect()->back()->with($notification);
        }

        $data    = Event::find($id);
        //--------------------------------------
        $image_1_name     =   $request->file('banner_image');
        if($image_1_name){
            $image_1_name_gen       =   hexdec(uniqid()).'.'.$image_1_name->getClientOriginalExtension();
            $path           =   public_path('upload/event/'.$image_1_name_gen);
            Image::make($image_1_name->getRealPath())->save($path);
            $last_img       =   'upload/event/'.$image_1_name_gen;
            $data->banner_image            =   $last_img;
            if($old_banner_image){
                $unlink=@unlink($old_banner_image);
            }
        }
        //--------------------------------------

        $data->title       =   $request->title;
        // $data->slug        =   trim(strtolower($request->slug));

        $data->sub_title     =   $request->sub_title;
        $data->form_title     =   $request->form_title;
        $data->form_submit_message     =   $request->form_submit_message;

        $data->language         =   $request->language;
        $data->meta_key         =   $request->meta_key;
        $data->meta_title         =   $request->meta_title;
        $data->meta_description         =   $request->meta_description;
        $data->status         =   $request->status;
        $data->updated_by=Auth::user()->id;
        $result=$data->update();

        if($result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('page.event.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data       =   Event::find($id);
        if($data->status=='Trash'){
            $dataCheck=EventDate::where('event_id',$id)->count();
            if($dataCheck==0 ){
                $result=$data->delete();
            }else{
                $notification=array(
                    'message'=>'First delete associated Category!!',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }else{
            $data->status='Trash';
            $result=$data->update();
        }
        if($result){
            $notification=array(
                'message'=>'Record Delete Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->back()->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
}
