<?php

namespace App\Http\Controllers\backend\page\general_page;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\GeneralPageManagement;
use Illuminate\Support\Facades\Auth;
use App\Models\Language;

class GeneralPageManagemnt extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($type)
    {
        $datas=GeneralPageManagement::where('type',$type)->get();
        return view('backend.page.general-page.index',compact('datas','type'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($type)
    {
        $languages      =   Language::all();
        return view('backend.page.general-page.add',compact('languages','type'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, $type)
    {
        $request->validate([
            'language'  =>'required',
            'title'  =>'required',
            'slug'  =>'required',
            'description'  =>'required',
            'language'=>'required',
            'meta_key'=>'required',
            'meta_title'=>'required',
            'meta_description'=>'required'
        ]);

        $check_data=GeneralPageManagement::where('type',$type)->where('slug',$request->slug)->where('language',$request->language)->count();
        if($check_data){
            $notification=array(
                'message'=>'Title already exists!!.',
                'alert-type'=>'warning'
            );
            return redirect()->back()->with($notification);
        }
        $data    =   new GeneralPageManagement();
        $data->type       =   $request->type;
        $data->title       =   $request->title;
        $data->slug        =   trim(strtolower($request->slug));
        $data->description =   $request->description;
        $data->language         =   $request->language;
        $data->meta_key         =   $request->meta_key;
        $data->meta_title         =   $request->meta_title;
        $data->meta_description         =   $request->meta_description;
        $data->created_by       =   Auth::user()->id;
        $result=$data->save();
        if($result){
            $notification=array(
                'message'=>'Record Created Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('general.page.list',$type)->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($type,$id)
    {
        $languages  =Language::all();
        $data       =   GeneralPageManagement::find($id);
        return view('backend.page.general-page.edit',compact('data','languages','type'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,$type, $id)
    {
        $request->validate([
            'language'  =>'required',
            'title'  =>'required',
            'description'  =>'required',
            'language'=>'required',
            'meta_key'=>'required',
            'meta_title'=>'required',
            'meta_description'=>'required'
        ]);

        $check_data=GeneralPageManagement::where('type',$type)->where('id','!=',$id)->where('slug',$request->slug)->where('language',$request->language)->count();
        if($check_data){
            $notification=array(
                'message'=>'Title already exists!!.',
                'alert-type'=>'warning'
            );
            return redirect()->back()->with($notification);
        }

        $data    =  GeneralPageManagement::find($id);
        $data->title       =   $request->title;
        // $data->slug        =   trim(strtolower($request->slug));
        $data->description =   $request->description;
        $data->language         =   $request->language;
        $data->meta_key         =   $request->meta_key;
        $data->meta_title         =   $request->meta_title;
        $data->meta_description         =   $request->meta_description;
        $data->status         =   $request->status;
        $data->updated_by=Auth::user()->id;
        $result=$data->update();
        if($result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('general.page.list',$type)->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($type,$id)
    {
        $data       =   GeneralPageManagement::find($id);
        if($data->status=='Trash'){
            $result=$data->delete();
        }else{
            $data->status='Trash';
            $result=$data->update();
        }
        if($result){
            $notification=array(
                'message'=>'Record Delete Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->back()->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
}
